/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.inline;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.ModuleLoweringPass;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.KlibConfigurationKeys;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.inline.DumpSyntheticAccessors;
import org.jetbrains.kotlin.ir.inline.SyntheticAccessorCollector;
import org.jetbrains.kotlin.ir.inline.SyntheticAccessorsDumper;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011H\u0002J\u001e\u0010\u0015\u001a\u0002H\u0016\"\n\b\u0000\u0010\u0016\u0018\u0001*\u00020\u0017*\u00020\u0018H\u0082\b\u00a2\u0006\u0002\u0010\u0019J\f\u0010\u001a\u001a\u00020\r*\u00020\u0018H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/ir/inline/DumpSyntheticAccessors;", "Lorg/jetbrains/kotlin/backend/common/ModuleLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/LoweringContext;)V", "dumpDirectory", "Ljava/io/File;", "lower", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dumpFile", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "collectAccessorTargetSymbols", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "accessorSymbols", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getSingleExpression", "E", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "id", "FileKey", "Companion", "ir.inline"})
@SourceDebugExtension(value={"SMAP\nDumpSyntheticAccessors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpSyntheticAccessors.kt\norg/jetbrains/kotlin/ir/inline/DumpSyntheticAccessors\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 setUtils.kt\norg/jetbrains/kotlin/utils/SetUtilsKt\n*L\n1#1,323:1\n102#1,15:334\n102#1,15:349\n102#1,15:364\n1761#2,3:324\n1056#2:327\n1869#2:328\n1870#2:330\n1634#2,2:332\n1636#2:379\n1#3:329\n22#4:331\n*S KotlinDebug\n*F\n+ 1 DumpSyntheticAccessors.kt\norg/jetbrains/kotlin/ir/inline/DumpSyntheticAccessors\n*L\n76#1:334,15\n79#1:349,15\n93#1:364,15\n44#1:324,3\n49#1:327\n49#1:328\n49#1:330\n73#1:332,2\n73#1:379\n73#1:331\n*E\n"})
public final class DumpSyntheticAccessors
implements ModuleLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final File dumpDirectory;

    public DumpSyntheticAccessors(@NotNull LoweringContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.dumpDirectory = Companion.getDumpDirectoryOrNull(context2.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrModuleFragment irModule) {
        Object fileDump;
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        File file = this.dumpDirectory;
        if (file == null) {
            return;
        }
        File dumpDirectory = file;
        dumpDirectory.mkdirs();
        HashMap<Object, HashSet> fileDumps = new HashMap<Object, HashSet>();
        for (IrFile irFile : irModule.getFiles()) {
            fileDump = this.dumpFile(irFile);
            if (fileDump == null) continue;
            HashSet hashSet = fileDumps.computeIfAbsent(new FileKey(irFile), arg_0 -> DumpSyntheticAccessors.lower$lambda$1(DumpSyntheticAccessors::lower$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"computeIfAbsent(...)");
            ((Collection)hashSet).add(fileDump);
        }
        if (!((Map)fileDumps).isEmpty()) {
            Object p0;
            boolean bl;
            block16: {
                Collection collection = fileDumps.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        p0 = (Collection)element$iv;
                        boolean bl2 = false;
                        boolean bl3 = !p0.isEmpty();
                        if (!bl3) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
            }
            if (bl) {
                Object object = Companion.getDumpFileForModule(dumpDirectory, irModule.getName());
                Object object2 = Charsets.UTF_8;
                fileDump = object;
                int element$iv = 8192;
                p0 = fileDump;
                object = new PrintWriter((p0 = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)p0), (Charset)object2)) instanceof BufferedWriter ? (BufferedWriter)p0 : new BufferedWriter((Writer)p0, element$iv));
                object2 = null;
                try {
                    void $this$forEach$iv;
                    PrintWriter writer = (PrintWriter)object;
                    boolean bl4 = false;
                    ((Appendable)writer).append("/* MODULE name=" + irModule.getName().asString() + " */").append('\n');
                    ((Appendable)writer).append('\n');
                    Set set = fileDumps.entrySet();
                    Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                    Iterable $this$sortedBy$iv = set;
                    boolean $i$f$sortedBy = false;
                    $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a2, T b2) {
                            Map.Entry it = (Map.Entry)a2;
                            boolean bl = false;
                            Comparable comparable = (FileKey)it.getKey();
                            it = (Map.Entry)b2;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((FileKey)it.getKey()));
                        }
                    });
                    boolean $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        CharSequence charSequence;
                        Map.Entry entry = (Map.Entry)element$iv2;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull((Object)entry);
                        Object k2 = entry.getKey();
                        Intrinsics.checkNotNullExpressionValue(k2, (String)"component1(...)");
                        FileKey fileKey = (FileKey)k2;
                        Object v2 = entry.getValue();
                        Intrinsics.checkNotNullExpressionValue(v2, (String)"component2(...)");
                        HashSet dumps = (HashSet)v2;
                        if (!(!((Collection)dumps).isEmpty())) continue;
                        Appendable appendable = writer;
                        StringBuilder stringBuilder = new StringBuilder().append("/* FILE package=");
                        CharSequence charSequence2 = fileKey.getPackageFqName();
                        if (charSequence2.length() == 0) {
                            StringBuilder stringBuilder2 = stringBuilder;
                            boolean bl6 = false;
                            charSequence = "<root>";
                            stringBuilder = stringBuilder2;
                        } else {
                            charSequence = charSequence2;
                        }
                        appendable.append(stringBuilder.append((String)charSequence).append(" fileName=").append(fileKey.getFileName()).append(" */").toString()).append('\n');
                        ((Appendable)writer).append('\n');
                        for (String fileDump2 : CollectionsKt.sorted((Iterable)dumps)) {
                            ((Appendable)writer).append(fileDump2).append('\n');
                        }
                        ((Appendable)writer).append('\n');
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
            }
        }
    }

    private final String dumpFile(IrFile irFile) {
        SyntheticAccessorCollector syntheticAccessorCollector = new SyntheticAccessorCollector();
        IrVisitorVoid p0 = syntheticAccessorCollector;
        boolean bl = false;
        IrVisitorsKt.acceptVoid((IrElement)irFile, p0);
        HashSet<IrFunctionSymbol> accessorSymbols = syntheticAccessorCollector.getAccessorSymbols();
        if (accessorSymbols.isEmpty()) {
            return null;
        }
        Set<IrSymbol> accessorTargetSymbols = this.collectAccessorTargetSymbols((Set<? extends IrFunctionSymbol>)accessorSymbols);
        SyntheticAccessorsDumper syntheticAccessorsDumper = new SyntheticAccessorsDumper((Set<? extends IrFunctionSymbol>)accessorSymbols, accessorTargetSymbols);
        IrVisitorVoid p02 = syntheticAccessorsDumper;
        boolean bl2 = false;
        IrVisitorsKt.acceptVoid((IrElement)irFile, p02);
        return syntheticAccessorsDumper.getDump();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Set<IrSymbol> collectAccessorTargetSymbols(Set<? extends IrFunctionSymbol> accessorSymbols) {
        Set set;
        Collection $this$mapToSetOrEmpty$iv = accessorSymbols;
        boolean $i$f$mapToSetOrEmpty = false;
        if (!$this$mapToSetOrEmpty$iv.isEmpty()) {
            void destination$iv$iv;
            void $this$mapTo$iv$iv;
            Iterable iterable = $this$mapToSetOrEmpty$iv;
            Collection collection = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrSymbol irSymbol;
                IrExpression expression$iv;
                Object object;
                IrBody irBody;
                Object $this$getSingleExpression$iv;
                void accessorSymbol;
                IrFunctionSymbol irFunctionSymbol = (IrFunctionSymbol)item$iv$iv;
                void var21_31 = destination$iv$iv;
                boolean bl = false;
                IrFunction accessor = accessorSymbol.getOwner();
                if (accessor instanceof IrConstructor) {
                    IrExpression irExpression;
                    IrBody body$iv;
                    DumpSyntheticAccessors dumpSyntheticAccessors = this;
                    $this$getSingleExpression$iv = accessor;
                    boolean $i$f$getSingleExpression = false;
                    if (((IrFunction)$this$getSingleExpression$iv).getBody() == null) {
                        CompilationExceptionKt.compilationException(dumpSyntheticAccessors.id((IrFunction)$this$getSingleExpression$iv) + " has no body", (IrDeclaration)$this$getSingleExpression$iv);
                        throw new KotlinNothingValueException();
                    }
                    irBody = body$iv;
                    if (irBody instanceof IrExpressionBody) {
                        irExpression = ((IrExpressionBody)body$iv).getExpression();
                    } else if (irBody instanceof IrBlockBody) {
                        object = CollectionsKt.singleOrNull(((IrBlockBody)body$iv).getStatements());
                        irExpression = object instanceof IrReturn ? (IrReturn)object : null;
                        if (irExpression == null || (irExpression = ((IrReturn)irExpression).getValue()) == null) {
                            CompilationExceptionKt.compilationException(dumpSyntheticAccessors.id((IrFunction)$this$getSingleExpression$iv) + " is expected to have exactly the single expression in block body", (IrDeclaration)$this$getSingleExpression$iv);
                            throw new KotlinNothingValueException();
                        }
                    } else {
                        if (!(irBody instanceof IrSyntheticBody)) throw new NoWhenBranchMatchedException();
                        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.syntheticBodyIsNotSupported((IrDeclaration)$this$getSingleExpression$iv);
                        throw new KotlinNothingValueException();
                    }
                    expression$iv = irExpression;
                    if (!(expression$iv instanceof IrDelegatingConstructorCall)) {
                        CompilationExceptionKt.compilationException(dumpSyntheticAccessors.id((IrFunction)$this$getSingleExpression$iv) + " is expected to have expression of type " + Reflection.getOrCreateKotlinClass(IrDelegatingConstructorCall.class).getSimpleName() + " but has " + Reflection.getOrCreateKotlinClass(expression$iv.getClass()).getSimpleName(), (IrDeclaration)$this$getSingleExpression$iv);
                        throw new KotlinNothingValueException();
                    }
                    IrConstructorSymbol accessorTargetSymbol = ((IrDelegatingConstructorCall)expression$iv).getSymbol();
                    irSymbol = accessorTargetSymbol;
                } else {
                    IrExpression irExpression;
                    IrBody body$iv;
                    if (!(accessor instanceof IrSimpleFunction)) throw new NoWhenBranchMatchedException();
                    DumpSyntheticAccessors dumpSyntheticAccessors = this;
                    $this$getSingleExpression$iv = accessor;
                    boolean $i$f$getSingleExpression = false;
                    if (((IrFunction)$this$getSingleExpression$iv).getBody() == null) {
                        CompilationExceptionKt.compilationException(dumpSyntheticAccessors.id((IrFunction)$this$getSingleExpression$iv) + " has no body", (IrDeclaration)$this$getSingleExpression$iv);
                        throw new KotlinNothingValueException();
                    }
                    irBody = body$iv;
                    if (irBody instanceof IrExpressionBody) {
                        irExpression = ((IrExpressionBody)body$iv).getExpression();
                    } else if (irBody instanceof IrBlockBody) {
                        object = CollectionsKt.singleOrNull(((IrBlockBody)body$iv).getStatements());
                        irExpression = object instanceof IrReturn ? (IrReturn)object : null;
                        if (irExpression == null || (irExpression = ((IrReturn)irExpression).getValue()) == null) {
                            CompilationExceptionKt.compilationException(dumpSyntheticAccessors.id((IrFunction)$this$getSingleExpression$iv) + " is expected to have exactly the single expression in block body", (IrDeclaration)$this$getSingleExpression$iv);
                            throw new KotlinNothingValueException();
                        }
                    } else {
                        if (!(irBody instanceof IrSyntheticBody)) throw new NoWhenBranchMatchedException();
                        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.syntheticBodyIsNotSupported((IrDeclaration)$this$getSingleExpression$iv);
                        throw new KotlinNothingValueException();
                    }
                    expression$iv = irExpression;
                    if (!(expression$iv instanceof IrDeclarationReference)) {
                        CompilationExceptionKt.compilationException(dumpSyntheticAccessors.id((IrFunction)$this$getSingleExpression$iv) + " is expected to have expression of type " + Reflection.getOrCreateKotlinClass(IrDeclarationReference.class).getSimpleName() + " but has " + Reflection.getOrCreateKotlinClass(expression$iv.getClass()).getSimpleName(), (IrDeclaration)$this$getSingleExpression$iv);
                        throw new KotlinNothingValueException();
                    }
                    IrDeclarationReference expression2 = (IrDeclarationReference)expression$iv;
                    if (expression2 instanceof IrCall) {
                        IrSimpleFunctionSymbol irSimpleFunctionSymbol = ((IrCall)expression2).getSymbol();
                        irSymbol = irSimpleFunctionSymbol;
                    } else if (expression2 instanceof IrFieldAccessExpression) {
                        IrFieldSymbol irFieldSymbol = ((IrFieldAccessExpression)expression2).getSymbol();
                        irSymbol = irFieldSymbol;
                    } else if (expression2 instanceof IrValueAccessExpression) {
                        IrValueSymbol irValueSymbol = ((IrValueAccessExpression)expression2).getSymbol();
                        irSymbol = irValueSymbol;
                    } else {
                        IrExpression irExpression2;
                        IrBody body$iv2;
                        void this_$iv;
                        if (!(expression2 instanceof IrConstructorCall)) throw new IllegalStateException(("Unexpected type of expression in accessor " + this.id(accessor) + ", " + RenderIrElementKt.render$default(expression2, null, 1, null)).toString());
                        $this$getSingleExpression$iv = this;
                        IrFunction $this$getSingleExpression$iv2 = accessor;
                        boolean $i$f$getSingleExpression2 = false;
                        if ($this$getSingleExpression$iv2.getBody() == null) {
                            CompilationExceptionKt.compilationException(super.id($this$getSingleExpression$iv2) + " has no body", $this$getSingleExpression$iv2);
                            throw new KotlinNothingValueException();
                        }
                        object = body$iv2;
                        if (object instanceof IrExpressionBody) {
                            irExpression2 = ((IrExpressionBody)body$iv2).getExpression();
                        } else if (object instanceof IrBlockBody) {
                            Object object2 = CollectionsKt.singleOrNull(((IrBlockBody)body$iv2).getStatements());
                            irExpression2 = object2 instanceof IrReturn ? (IrReturn)object2 : null;
                            if (irExpression2 == null || (irExpression2 = ((IrReturn)irExpression2).getValue()) == null) {
                                CompilationExceptionKt.compilationException(super.id($this$getSingleExpression$iv2) + " is expected to have exactly the single expression in block body", $this$getSingleExpression$iv2);
                                throw new KotlinNothingValueException();
                            }
                        } else {
                            if (!(object instanceof IrSyntheticBody)) throw new NoWhenBranchMatchedException();
                            org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.syntheticBodyIsNotSupported($this$getSingleExpression$iv2);
                            throw new KotlinNothingValueException();
                        }
                        IrExpression expression$iv2 = irExpression2;
                        if (!(expression$iv2 instanceof IrConstructorCall)) {
                            CompilationExceptionKt.compilationException(super.id($this$getSingleExpression$iv2) + " is expected to have expression of type " + Reflection.getOrCreateKotlinClass(IrConstructorCall.class).getSimpleName() + " but has " + Reflection.getOrCreateKotlinClass(expression$iv2.getClass()).getSimpleName(), $this$getSingleExpression$iv2);
                            throw new KotlinNothingValueException();
                        }
                        IrConstructorSymbol irConstructorSymbol = ((IrConstructorCall)expression$iv2).getSymbol();
                        irSymbol = irConstructorSymbol;
                    }
                }
                var21_31.add(irSymbol);
            }
            set = (Set)destination$iv$iv;
            return set;
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final String id(IrFunction $this$id) {
        return $this$id.getClass().getSimpleName() + ' ' + IrUtilsKt.getFqNameWhenAvailable($this$id);
    }

    private static final HashSet lower$lambda$0(FileKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HashSet();
    }

    private static final HashSet lower$lambda$1(Function1 $tmp0, Object p0) {
        return (HashSet)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/ir/inline/DumpSyntheticAccessors$Companion;", "", "<init>", "()V", "getDumpDirectoryOrNull", "Ljava/io/File;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getDumpFileForModule", "dumpDirectory", "moduleName", "Lorg/jetbrains/kotlin/name/Name;", "ir.inline"})
    @SourceDebugExtension(value={"SMAP\nDumpSyntheticAccessors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpSyntheticAccessors.kt\norg/jetbrains/kotlin/ir/inline/DumpSyntheticAccessors$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,323:1\n1#2:324\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final File getDumpDirectoryOrNull(@NotNull CompilerConfiguration configuration2) {
            File file;
            Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
            String string = configuration2.get(KlibConfigurationKeys.SYNTHETIC_ACCESSORS_DUMP_DIR);
            if (string != null) {
                String p0 = string;
                boolean bl = false;
                file = new File(p0);
            } else {
                file = null;
            }
            return file;
        }

        @NotNull
        public final File getDumpFileForModule(@NotNull File dumpDirectory, @NotNull Name moduleName2) {
            Intrinsics.checkNotNullParameter((Object)dumpDirectory, (String)"dumpDirectory");
            Intrinsics.checkNotNullParameter((Object)moduleName2, (String)"moduleName");
            return FilesKt.resolve((File)dumpDirectory, (String)("synthetic-accessors-dump-" + moduleName2.asStringStripSpecialMarkers() + ".kt"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u000f\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ir/inline/DumpSyntheticAccessors$FileKey;", "", "packageFqName", "", "fileName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "getPackageFqName", "()Ljava/lang/String;", "getFileName", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "ir.inline"})
    private static final class FileKey
    implements Comparable<FileKey> {
        @NotNull
        private final String packageFqName;
        @NotNull
        private final String fileName;

        public FileKey(@NotNull String packageFqName, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            this.packageFqName = packageFqName;
            this.fileName = fileName;
        }

        @NotNull
        public final String getPackageFqName() {
            return this.packageFqName;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        public FileKey(@NotNull IrFile irFile) {
            Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
            this(irFile.getPackageFqName().asString(), IrDeclarationsKt.getName(irFile));
        }

        @Override
        public int compareTo(@NotNull FileKey other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Function1[] function1Array = new Function1[]{compareTo.1.INSTANCE, compareTo.2.INSTANCE};
            return ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])function1Array);
        }

        @NotNull
        public final String component1() {
            return this.packageFqName;
        }

        @NotNull
        public final String component2() {
            return this.fileName;
        }

        @NotNull
        public final FileKey copy(@NotNull String packageFqName, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            return new FileKey(packageFqName, fileName);
        }

        public static /* synthetic */ FileKey copy$default(FileKey fileKey, String string, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = fileKey.packageFqName;
            }
            if ((n2 & 2) != 0) {
                string2 = fileKey.fileName;
            }
            return fileKey.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "FileKey(packageFqName=" + this.packageFqName + ", fileName=" + this.fileName + ')';
        }

        public int hashCode() {
            int result2 = this.packageFqName.hashCode();
            result2 = result2 * 31 + this.fileName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileKey)) {
                return false;
            }
            FileKey fileKey = (FileKey)other;
            if (!Intrinsics.areEqual((Object)this.packageFqName, (Object)fileKey.packageFqName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.fileName, (Object)fileKey.fileName);
        }
    }
}

