/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageMatcher;
import org.jetbrains.kotlin.com.intellij.lang.LanguageUtil;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.search.DelegatingGlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.templateLanguages.TemplateLanguage;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

class FileLanguageGlobalScope
extends DelegatingGlobalSearchScope {
    private final Project myProject;
    @NotNull
    private final Collection<? extends LanguageMatcher> myLanguageMatchers;

    FileLanguageGlobalScope(@NotNull Project project, @NotNull GlobalSearchScope baseScope, @NotNull Collection<? extends LanguageMatcher> languageMatchers) {
        if (project == null) {
            FileLanguageGlobalScope.$$$reportNull$$$0(0);
        }
        if (baseScope == null) {
            FileLanguageGlobalScope.$$$reportNull$$$0(1);
        }
        if (languageMatchers == null) {
            FileLanguageGlobalScope.$$$reportNull$$$0(2);
        }
        super(baseScope);
        this.myProject = project;
        this.myLanguageMatchers = languageMatchers;
    }

    FileLanguageGlobalScope(Project project, GlobalSearchScope scope2, LanguageMatcher matcher) {
        this(project, scope2, Collections.singleton(matcher));
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            FileLanguageGlobalScope.$$$reportNull$$$0(3);
        }
        return super.contains(file) && this.matchesLanguage(file);
    }

    private boolean matchesLanguage(@NotNull VirtualFile file) {
        Language baseLanguage;
        if (file == null) {
            FileLanguageGlobalScope.$$$reportNull$$$0(4);
        }
        if ((baseLanguage = LanguageUtil.getLanguageForPsi(this.myProject, file)) instanceof TemplateLanguage) {
            FileViewProvider viewProvider = PsiManager.getInstance(this.myProject).findViewProvider(file);
            if (viewProvider == null) {
                return false;
            }
            return ContainerUtil.or(viewProvider.getLanguages(), fileLanguage -> ContainerUtil.or(this.myLanguageMatchers, matcher -> matcher.matchesLanguage((Language)fileLanguage)));
        }
        if (baseLanguage != null) {
            return ContainerUtil.or(this.myLanguageMatchers, matcher -> matcher.matchesLanguage(baseLanguage));
        }
        return false;
    }

    @Override
    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            FileLanguageGlobalScope.$$$reportNull$$$0(5);
        }
        if (scope2 instanceof FileLanguageGlobalScope) {
            FileLanguageGlobalScope other = (FileLanguageGlobalScope)scope2;
            if (this.myBaseScope == other.myBaseScope) {
                Collection<? extends LanguageMatcher> intersection = ContainerUtil.intersection(this.myLanguageMatchers, other.myLanguageMatchers);
                if (intersection.isEmpty()) {
                    GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
                    if (globalSearchScope == null) {
                        FileLanguageGlobalScope.$$$reportNull$$$0(6);
                    }
                    return globalSearchScope;
                }
                return new FileLanguageGlobalScope(this.myProject, this.myBaseScope, intersection);
            }
        }
        GlobalSearchScope globalSearchScope = super.intersectWith(scope2);
        if (globalSearchScope == null) {
            FileLanguageGlobalScope.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            FileLanguageGlobalScope.$$$reportNull$$$0(8);
        }
        if (scope2 instanceof FileLanguageGlobalScope) {
            FileLanguageGlobalScope other = (FileLanguageGlobalScope)scope2;
            if (this.myBaseScope == other.myBaseScope) {
                Set<? extends LanguageMatcher> intersection = ContainerUtil.union(this.myLanguageMatchers, other.myLanguageMatchers);
                return new FileLanguageGlobalScope(this.myProject, this.myBaseScope, intersection);
            }
        }
        GlobalSearchScope globalSearchScope = super.uniteWith(scope2);
        if (globalSearchScope == null) {
            FileLanguageGlobalScope.$$$reportNull$$$0(9);
        }
        return globalSearchScope;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        FileLanguageGlobalScope scope2 = (FileLanguageGlobalScope)o2;
        if (!this.myProject.equals(scope2.myProject)) {
            return false;
        }
        return this.myLanguageMatchers.equals(scope2.myLanguageMatchers);
    }

    @Override
    public int calcHashCode() {
        int result2 = super.calcHashCode();
        result2 = 31 * result2 + this.myProject.hashCode();
        result2 = 31 * result2 + this.myLanguageMatchers.hashCode();
        return result2;
    }

    @Override
    public String toString() {
        return "(restricted by file languages: " + this.myLanguageMatchers + " in " + this.myBaseScope + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageMatchers";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/FileLanguageGlobalScope";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/FileLanguageGlobalScope";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWith";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteWith";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "matchesLanguage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "intersectWith";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "uniteWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

