/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.core.CoreBundle;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public final class CheckUtil {
    private CheckUtil() {
    }

    public static void checkWritable(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            CheckUtil.$$$reportNull$$$0(0);
        }
        if (!element.isWritable()) {
            if (element instanceof PsiDirectory) {
                String url = ((PsiDirectory)element).getVirtualFile().getPresentableUrl();
                throw new IncorrectOperationException(CoreBundle.message("cannot.modify.a.read.only.directory", url));
            }
            PsiFile file = element.getContainingFile();
            if (file == null) {
                throw new IncorrectOperationException();
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                throw new IncorrectOperationException();
            }
            throw new IncorrectOperationException(CoreBundle.message("cannot.modify.a.read.only.file", virtualFile.getPresentableUrl()));
        }
    }

    public static void checkDelete(@NotNull VirtualFile file) throws IncorrectOperationException {
        if (file == null) {
            CheckUtil.$$$reportNull$$$0(1);
        }
        VfsUtilCore.visitChildrenRecursively(file, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (FileTypeRegistry.getInstance().isFileIgnored(file)) {
                    return false;
                }
                if (!file.isWritable()) {
                    throw new IncorrectOperationException(CoreBundle.message("cannot.delete.a.read.only.file", file.getPresentableUrl()));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/CheckUtil$1", "visitFile"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/CheckUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkWritable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDelete";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

