/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import javax.inject.Inject;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenVariantAttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.capabilities.CapabilityInternal;
import org.gradle.internal.component.external.model.AbstractStatelessDerivationStrategy;
import org.gradle.internal.component.external.model.DefaultConfigurationMetadata;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ShadowedImmutableCapability;
import org.gradle.internal.component.external.model.maven.DefaultMavenModuleResolveMetadata;
import org.gradle.internal.component.model.ModuleConfigurationMetadata;

public class JavaEcosystemVariantDerivationStrategy
extends AbstractStatelessDerivationStrategy {
    private final MavenVariantAttributesFactory mavenAttributesFactory;

    @Inject
    public JavaEcosystemVariantDerivationStrategy(MavenVariantAttributesFactory mavenAttributesFactory) {
        this.mavenAttributesFactory = mavenAttributesFactory;
    }

    @Override
    public boolean derivesVariants() {
        return true;
    }

    @Override
    public ImmutableList<? extends ModuleConfigurationMetadata> derive(ModuleComponentResolveMetadata metadata) {
        if (metadata instanceof DefaultMavenModuleResolveMetadata) {
            DefaultMavenModuleResolveMetadata md = (DefaultMavenModuleResolveMetadata)metadata;
            ImmutableAttributes attributes = md.getAttributes();
            DefaultConfigurationMetadata compileConfiguration = (DefaultConfigurationMetadata)md.getConfiguration("compile");
            DefaultConfigurationMetadata runtimeConfiguration = (DefaultConfigurationMetadata)md.getConfiguration("runtime");
            ModuleComponentIdentifier componentId = md.getId();
            ImmutableCapabilities shadowedPlatformCapability = this.buildShadowPlatformCapability(componentId, false);
            ImmutableCapabilities shadowedEnforcedPlatformCapability = this.buildShadowPlatformCapability(componentId, true);
            return ImmutableList.of((Object)this.libraryCompileScope(compileConfiguration, attributes), (Object)this.libraryRuntimeScope(runtimeConfiguration, attributes), (Object)this.libraryWithSourcesVariant(runtimeConfiguration, attributes, metadata), (Object)this.libraryWithJavadocVariant(runtimeConfiguration, attributes, metadata), (Object)this.platformWithUsageAttribute(compileConfiguration, attributes, "java-api", false, shadowedPlatformCapability), (Object)this.platformWithUsageAttribute(runtimeConfiguration, attributes, "java-runtime", false, shadowedPlatformCapability), (Object)this.platformWithUsageAttribute(compileConfiguration, attributes, "java-api", true, shadowedEnforcedPlatformCapability), (Object)this.platformWithUsageAttribute(runtimeConfiguration, attributes, "java-runtime", true, shadowedEnforcedPlatformCapability));
        }
        return null;
    }

    private DefaultConfigurationMetadata libraryWithSourcesVariant(DefaultConfigurationMetadata runtimeConfiguration, ImmutableAttributes originAttributes, ModuleComponentResolveMetadata metadata) {
        return runtimeConfiguration.mutate().withName("sources").withAttributes(this.mavenAttributesFactory.sourcesVariant(originAttributes)).withArtifacts((ImmutableList<? extends ModuleComponentArtifactMetadata>)ImmutableList.of((Object)metadata.optionalArtifact("jar", "jar", "sources"))).withoutConstraints().build();
    }

    private ModuleConfigurationMetadata libraryWithJavadocVariant(DefaultConfigurationMetadata runtimeConfiguration, ImmutableAttributes originAttributes, ModuleComponentResolveMetadata metadata) {
        return runtimeConfiguration.mutate().withName("javadoc").withAttributes(this.mavenAttributesFactory.javadocVariant(originAttributes)).withArtifacts((ImmutableList<? extends ModuleComponentArtifactMetadata>)ImmutableList.of((Object)metadata.optionalArtifact("jar", "jar", "javadoc"))).withoutConstraints().build();
    }

    private ImmutableCapabilities buildShadowPlatformCapability(ModuleComponentIdentifier componentId, boolean enforced) {
        return ImmutableCapabilities.of((Capability)new ShadowedImmutableCapability((CapabilityInternal)new DefaultImmutableCapability(componentId.getGroup(), componentId.getModule(), componentId.getVersion()), enforced ? "-derived-enforced-platform" : "-derived-platform"));
    }

    private ModuleConfigurationMetadata libraryCompileScope(DefaultConfigurationMetadata conf, ImmutableAttributes originAttributes) {
        ImmutableAttributes attributes = this.mavenAttributesFactory.compileScope(originAttributes);
        return conf.mutate().withAttributes(attributes).withoutConstraints().build();
    }

    private ModuleConfigurationMetadata libraryRuntimeScope(DefaultConfigurationMetadata conf, ImmutableAttributes originAttributes) {
        ImmutableAttributes attributes = this.mavenAttributesFactory.runtimeScope(originAttributes);
        return conf.mutate().withAttributes(attributes).withoutConstraints().build();
    }

    private ModuleConfigurationMetadata platformWithUsageAttribute(DefaultConfigurationMetadata conf, ImmutableAttributes originAttributes, String usage, boolean enforcedPlatform, ImmutableCapabilities shadowedPlatformCapability) {
        ImmutableAttributes attributes = this.mavenAttributesFactory.platformWithUsage(originAttributes, usage, enforcedPlatform);
        String prefix = enforcedPlatform ? "enforced-platform-" : "platform-";
        DefaultConfigurationMetadata.Builder builder = conf.mutate().withName(prefix + conf.getName()).withAttributes(attributes).withConstraintsOnly().withCapabilities(shadowedPlatformCapability);
        if (enforcedPlatform) {
            builder = builder.withForcedDependencies();
        }
        return builder.build();
    }
}

