/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.metadata;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenVariantAttributesFactory;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.impl.CoercingStringValueSnapshot;

public class DefaultMavenVariantAttributesFactory
implements MavenVariantAttributesFactory {
    private final AttributesFactory attributesFactory;
    private final NamedObjectInstantiator objectInstantiator;
    private final Map<List<Object>, ImmutableAttributes> concatCache = new ConcurrentHashMap<List<Object>, ImmutableAttributes>();

    @Inject
    public DefaultMavenVariantAttributesFactory(AttributesFactory attributesFactory, NamedObjectInstantiator objectInstantiator) {
        this.attributesFactory = attributesFactory;
        this.objectInstantiator = objectInstantiator;
    }

    @Override
    public ImmutableAttributes compileScope(ImmutableAttributes original) {
        ImmutableList key = ImmutableList.of((Object)original, (Object)"java-api");
        return this.concatCache.computeIfAbsent((List<Object>)key, k -> {
            ImmutableAttributes result = original;
            result = this.attributesFactory.concat(result, USAGE_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("java-api", this.objectInstantiator));
            result = this.attributesFactory.concat(result, FORMAT_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("jar", this.objectInstantiator));
            result = this.attributesFactory.concat(result, CATEGORY_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("library", this.objectInstantiator));
            return result;
        });
    }

    @Override
    public ImmutableAttributes runtimeScope(ImmutableAttributes original) {
        ImmutableList key = ImmutableList.of((Object)original, (Object)"java-runtime");
        return this.concatCache.computeIfAbsent((List<Object>)key, k -> {
            ImmutableAttributes result = original;
            result = this.attributesFactory.concat(result, USAGE_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("java-runtime", this.objectInstantiator));
            result = this.attributesFactory.concat(result, FORMAT_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("jar", this.objectInstantiator));
            result = this.attributesFactory.concat(result, CATEGORY_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("library", this.objectInstantiator));
            return result;
        });
    }

    @Override
    public ImmutableAttributes platformWithUsage(ImmutableAttributes original, String usage, boolean enforced) {
        String componentType = enforced ? "enforced-platform" : "platform";
        ImmutableList key = ImmutableList.of((Object)original, (Object)componentType, (Object)usage);
        return this.concatCache.computeIfAbsent((List<Object>)key, k -> {
            ImmutableAttributes result = original;
            result = this.attributesFactory.concat(result, USAGE_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot(usage, this.objectInstantiator));
            result = this.attributesFactory.concat(result, CATEGORY_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot(componentType, this.objectInstantiator));
            return result;
        });
    }

    @Override
    public ImmutableAttributes sourcesVariant(ImmutableAttributes original) {
        ImmutableList key = ImmutableList.of((Object)original, (Object)"documentation", (Object)"java-runtime", (Object)"sources");
        return this.concatCache.computeIfAbsent((List<Object>)key, k -> {
            ImmutableAttributes result = original;
            result = this.attributesFactory.concat(result, CATEGORY_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("documentation", this.objectInstantiator));
            result = this.attributesFactory.concat(result, Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)this.objectInstantiator.named(Bundling.class, "external")));
            result = this.attributesFactory.concat(result, DocsType.DOCS_TYPE_ATTRIBUTE, (Object)((DocsType)this.objectInstantiator.named(DocsType.class, "sources")));
            result = this.attributesFactory.concat(result, USAGE_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("java-runtime", this.objectInstantiator));
            return result;
        });
    }

    @Override
    public ImmutableAttributes javadocVariant(ImmutableAttributes original) {
        ImmutableList key = ImmutableList.of((Object)original, (Object)"documentation", (Object)"java-runtime", (Object)"javadoc");
        return this.concatCache.computeIfAbsent((List<Object>)key, k -> {
            ImmutableAttributes result = original;
            result = this.attributesFactory.concat(result, CATEGORY_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("documentation", this.objectInstantiator));
            result = this.attributesFactory.concat(result, Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)this.objectInstantiator.named(Bundling.class, "external")));
            result = this.attributesFactory.concat(result, DocsType.DOCS_TYPE_ATTRIBUTE, (Object)((DocsType)this.objectInstantiator.named(DocsType.class, "javadoc")));
            result = this.attributesFactory.concat(result, USAGE_ATTRIBUTE, (Isolatable)new CoercingStringValueSnapshot("java-runtime", this.objectInstantiator));
            return result;
        });
    }
}

