/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphDependency;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.CachingDependencyResultFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DefaultComponentSelectionDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedComponentVisitor;
import org.gradle.api.internal.artifacts.result.DefaultResolvedComponentResult;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.artifacts.result.MinimalResolutionResult;
import org.gradle.api.internal.artifacts.result.ResolvedComponentResultInternal;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.jspecify.annotations.Nullable;

public class ResolutionResultGraphBuilder
implements ResolvedComponentVisitor {
    private static final DefaultComponentSelectionDescriptor DEPENDENCY_LOCKING = new DefaultComponentSelectionDescriptor(ComponentSelectionCause.CONSTRAINT, (Describable)Describables.of((Object)"Dependency locking"));
    private final Long2ObjectMap<DefaultResolvedComponentResult> components = new Long2ObjectOpenHashMap();
    private final CachingDependencyResultFactory dependencyResultFactory = new CachingDependencyResultFactory();
    private long id;
    private ComponentSelectionReason selectionReason;
    private ComponentIdentifier componentId;
    private ModuleVersionIdentifier moduleVersion;
    private String repoName;
    private ImmutableList<ResolvedVariantResult> allVariants;
    private final Map<Long, ResolvedVariantResult> selectedVariants = new LinkedHashMap<Long, ResolvedVariantResult>();

    public static MinimalResolutionResult empty(ModuleVersionIdentifier id, ComponentIdentifier componentIdentifier, ImmutableAttributes attributes, ImmutableCapabilities capabilities, String rootVariantName, AttributeDesugaring attributeDesugaring) {
        ResolutionResultGraphBuilder builder = new ResolutionResultGraphBuilder();
        builder.startVisitComponent(0L, ComponentSelectionReasons.root(), null);
        builder.visitComponentDetails(componentIdentifier, id);
        DefaultResolvedVariantResult rootVariant = new DefaultResolvedVariantResult(componentIdentifier, Describables.of((Object)rootVariantName), (AttributeContainer)attributeDesugaring.desugar(attributes), capabilities, null);
        builder.visitSelectedVariant(1L, rootVariant);
        builder.visitComponentVariants(Collections.emptyList());
        builder.endVisitComponent();
        ResolvedComponentResultInternal root = builder.getRoot(0L);
        return new MinimalResolutionResult(1L, () -> root, attributes);
    }

    public ResolvedComponentResultInternal getRoot(long rootId) {
        for (DefaultResolvedComponentResult component : this.components.values()) {
            component.complete();
        }
        return (ResolvedComponentResultInternal)this.components.get(rootId);
    }

    @Override
    public void startVisitComponent(Long id, ComponentSelectionReason selectionReason, @Nullable String repoName) {
        this.id = id;
        this.selectionReason = selectionReason;
        this.selectedVariants.clear();
        this.allVariants = null;
        this.repoName = repoName;
    }

    @Override
    public void visitComponentDetails(ComponentIdentifier componentId, ModuleVersionIdentifier moduleVersion) {
        this.componentId = componentId;
        this.moduleVersion = moduleVersion;
    }

    @Override
    public void visitSelectedVariant(Long id, ResolvedVariantResult variant) {
        this.selectedVariants.put(id, variant);
    }

    @Override
    public void visitComponentVariants(List<ResolvedVariantResult> allVariants) {
        this.allVariants = ImmutableList.copyOf(allVariants);
    }

    @Override
    public void endVisitComponent() {
        if (!this.components.containsKey(this.id)) {
            this.components.put(this.id, (Object)new DefaultResolvedComponentResult(this.moduleVersion, this.selectionReason, this.componentId, (ImmutableMap<Long, ResolvedVariantResult>)ImmutableMap.copyOf(this.selectedVariants), this.allVariants, this.repoName));
        }
        this.selectedVariants.clear();
        this.allVariants = null;
    }

    public void visitOutgoingEdges(long fromComponentId, Collection<? extends ResolvedGraphDependency> dependencies) {
        ImmutableSet.Builder componentDependencies = ImmutableSet.builderWithExpectedSize((int)dependencies.size());
        ImmutableSetMultimap.Builder variantDependencies = ImmutableSetMultimap.builder();
        DefaultResolvedComponentResult fromComponent = (DefaultResolvedComponentResult)this.components.get(fromComponentId);
        for (ResolvedGraphDependency resolvedGraphDependency : dependencies) {
            UnresolvedDependencyResult dependencyResult;
            ResolvedVariantResult fromVariant = fromComponent.getVariant(resolvedGraphDependency.getFromVariant());
            if (fromVariant == null) {
                throw new IllegalStateException("Corrupt serialized resolution result. Cannot find variant (" + resolvedGraphDependency.getFromVariant() + ") for " + (resolvedGraphDependency.isConstraint() ? "constraint " : "") + fromComponent + " -> " + resolvedGraphDependency.getRequested().getDisplayName());
            }
            if (resolvedGraphDependency.getFailure() != null) {
                dependencyResult = this.dependencyResultFactory.createUnresolvedDependency(resolvedGraphDependency.getRequested(), fromComponent, resolvedGraphDependency.isConstraint(), resolvedGraphDependency.getReason(), resolvedGraphDependency.getFailure());
            } else {
                ResolvedVariantResult selectedVariant;
                DefaultResolvedComponentResult selectedComponent = (DefaultResolvedComponentResult)this.components.get(resolvedGraphDependency.getSelected().longValue());
                if (selectedComponent == null) {
                    throw new IllegalStateException("Corrupt serialized resolution result. Cannot find selected component (" + resolvedGraphDependency.getSelected() + ") for " + (resolvedGraphDependency.isConstraint() ? "constraint " : "") + fromVariant + " -> " + resolvedGraphDependency.getRequested().getDisplayName());
                }
                if (resolvedGraphDependency.getSelectedVariant() != null) {
                    selectedVariant = selectedComponent.getVariant(resolvedGraphDependency.getSelectedVariant());
                    if (selectedVariant == null) {
                        throw new IllegalStateException("Corrupt serialized resolution result. Cannot find selected variant (" + resolvedGraphDependency.getSelectedVariant() + ") for " + (resolvedGraphDependency.isConstraint() ? "constraint " : "") + fromVariant + " -> " + resolvedGraphDependency.getRequested().getDisplayName());
                    }
                } else {
                    selectedVariant = null;
                }
                dependencyResult = this.dependencyResultFactory.createResolvedDependency(resolvedGraphDependency.getRequested(), fromComponent, selectedComponent, selectedVariant, resolvedGraphDependency.isConstraint());
                selectedComponent.addDependent((ResolvedDependencyResult)dependencyResult);
            }
            componentDependencies.add((Object)dependencyResult);
            variantDependencies.put((Object)fromVariant, (Object)dependencyResult);
        }
        fromComponent.addDependencies((ImmutableSet<DependencyResult>)componentDependencies.build());
        fromComponent.addVariantDependencies((ImmutableSetMultimap<ResolvedVariantResult, DependencyResult>)variantDependencies.build());
    }

    public void addDependencyLockingFailures(long rootId, Set<UnresolvedDependency> extraFailures) {
        if (extraFailures.isEmpty()) {
            return;
        }
        ImmutableSet.Builder failuresAsDependencies = ImmutableSet.builderWithExpectedSize((int)extraFailures.size());
        DefaultResolvedComponentResult root = (DefaultResolvedComponentResult)this.components.get(rootId);
        for (UnresolvedDependency failure : extraFailures) {
            ModuleVersionSelector failureSelector = failure.getSelector();
            ModuleComponentSelector failureComponentSelector = DefaultModuleComponentSelector.newSelector(failureSelector.getModule(), failureSelector.getVersion());
            UnresolvedDependencyResult unresolvedDependency = this.dependencyResultFactory.createUnresolvedDependency((ComponentSelector)failureComponentSelector, root, true, ComponentSelectionReasons.of(DEPENDENCY_LOCKING), new ModuleVersionResolveException((ComponentSelector)failureComponentSelector, (Factory<String>)((Factory)() -> "Dependency lock state out of date"), failure.getProblem()));
            failuresAsDependencies.add((Object)unresolvedDependency);
        }
        root.addDependencies((ImmutableSet<DependencyResult>)failuresAsDependencies.build());
    }
}

