/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.annotations.impl;

import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.cache.Cache;
import org.gradle.cache.internal.ClassCacheFactory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.reflect.Methods;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.internal.reflect.annotations.AnnotationCategory;
import org.gradle.internal.reflect.annotations.FunctionAnnotationMetadata;
import org.gradle.internal.reflect.annotations.HasAnnotationMetadata;
import org.gradle.internal.reflect.annotations.PropertyAnnotationMetadata;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadata;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadataStore;
import org.gradle.internal.reflect.annotations.impl.DefaultFunctionAnnotationMetadata;
import org.gradle.internal.reflect.annotations.impl.DefaultPropertyAnnotationMetadata;
import org.gradle.internal.reflect.annotations.impl.DefaultTypeAnnotationMetadata;
import org.gradle.internal.reflect.validation.ReplayingTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeAwareProblemBuilder;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.util.internal.TextUtil;

public class DefaultTypeAnnotationMetadataStore
implements TypeAnnotationMetadataStore {
    private static final TypeAnnotationMetadata EMPTY_TYPE_ANNOTATION_METADATA = new TypeAnnotationMetadata(){

        @Override
        public ImmutableSet<Annotation> getAnnotations() {
            return ImmutableSet.of();
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return false;
        }

        @Override
        public ImmutableSortedSet<PropertyAnnotationMetadata> getPropertiesAnnotationMetadata() {
            return ImmutableSortedSet.of();
        }

        @Override
        public ImmutableSortedSet<FunctionAnnotationMetadata> getFunctionAnnotationMetadata() {
            return ImmutableSortedSet.of();
        }

        @Override
        public void visitValidationFailures(TypeValidationContext validationContext) {
        }

        @Override
        public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
            return Optional.empty();
        }
    };
    private final ImmutableSet<Class<? extends Annotation>> recordedTypeAnnotations;
    private final ImmutableSet<String> ignoredPackagePrefixes;
    private final ImmutableMap<Class<? extends Annotation>, AnnotationCategory> propertyAnnotationCategories;
    private final ImmutableMap<Class<? extends Annotation>, AnnotationCategory> functionAnnotationCategories;
    private final Cache<Class<?>, TypeAnnotationMetadata> cache;
    private final ImmutableSet<String> potentiallyIgnoredMethodNames;
    private final ImmutableSet<Equivalence.Wrapper<Method>> globallyIgnoredMethods;
    private final ImmutableSet<Class<?>> mutableNonFinalClasses;
    private final ImmutableSet<Class<? extends Annotation>> ignoredMethodAnnotations;
    private final ImmutableSet<Class<? extends Annotation>> ignoredMethodAnnotationsAllowedModifiers;
    private final Predicate<? super Method> generatedMethodDetector;
    private static final String REDUNDANT_GETTERS = "REDUNDANT_GETTERS";
    private static final String IGNORED_ANNOTATIONS_ON_FIELD = "IGNORED_ANNOTATIONS_ON_FIELD";
    private static final String PRIVATE_GETTER_MUST_NOT_BE_ANNOTATED = "PRIVATE_GETTER_MUST_NOT_BE_ANNOTATED";
    private static final String PRIVATE_METHOD_MUST_NOT_BE_ANNOTATED = "PRIVATE_METHOD_MUST_NOT_BE_ANNOTATED";
    private static final String MUTABLE_TYPE_WITH_SETTER = "MUTABLE_TYPE_WITH_SETTER";
    private static final String IGNORED_ANNOTATIONS_ON_METHOD = "IGNORED_ANNOTATIONS_ON_METHOD";
    private static final String IGNORED_ANNOTATIONS_ON_PROPERTY = "IGNORED_ANNOTATIONS_ON_PROPERTY";

    public DefaultTypeAnnotationMetadataStore(Collection<Class<? extends Annotation>> recordedTypeAnnotations, Map<Class<? extends Annotation>, ? extends AnnotationCategory> propertyAnnotationCategories, Map<Class<? extends Annotation>, ? extends AnnotationCategory> functionAnnotationCategories, Collection<String> ignoredPackagePrefixes, Collection<Class<?>> ignoredSuperTypes, Collection<Class<?>> ignoreMethodsFromTypes, Collection<Class<?>> mutableNonFinalClasses, Collection<Class<? extends Annotation>> ignoredMethodAnnotations, Collection<Class<? extends Annotation>> ignoredMethodAnnotationsAllowedModifiers, Predicate<? super Method> generatedMethodDetector, ClassCacheFactory cacheFactory) {
        this.recordedTypeAnnotations = ImmutableSet.copyOf(recordedTypeAnnotations);
        this.ignoredPackagePrefixes = DefaultTypeAnnotationMetadataStore.collectIgnoredPackagePrefixes(ignoredPackagePrefixes);
        this.propertyAnnotationCategories = DefaultTypeAnnotationMetadataStore.allAnnotationCategoriesForProperties(propertyAnnotationCategories, ignoredMethodAnnotations);
        this.functionAnnotationCategories = DefaultTypeAnnotationMetadataStore.allAnnotationCategories(functionAnnotationCategories, Collections.emptyList());
        this.cache = DefaultTypeAnnotationMetadataStore.initCache(ignoredSuperTypes, cacheFactory);
        this.potentiallyIgnoredMethodNames = DefaultTypeAnnotationMetadataStore.allMethodNamesOf(ignoreMethodsFromTypes);
        this.globallyIgnoredMethods = DefaultTypeAnnotationMetadataStore.allMethodsOf(ignoreMethodsFromTypes);
        this.mutableNonFinalClasses = ImmutableSet.copyOf(mutableNonFinalClasses);
        this.ignoredMethodAnnotations = ImmutableSet.copyOf(ignoredMethodAnnotations);
        this.ignoredMethodAnnotationsAllowedModifiers = ImmutableSet.copyOf(ignoredMethodAnnotationsAllowedModifiers);
        this.generatedMethodDetector = generatedMethodDetector;
    }

    private static ImmutableSet<String> collectIgnoredPackagePrefixes(Collection<String> ignoredPackagePrefixes) {
        return ImmutableSet.copyOf((Collection)ignoredPackagePrefixes.stream().map(prefix -> prefix + ".").collect(Collectors.toList()));
    }

    private static ImmutableMap<Class<? extends Annotation>, AnnotationCategory> allAnnotationCategoriesForProperties(Map<Class<? extends Annotation>, ? extends AnnotationCategory> propertyAnnotationCategories, Collection<Class<? extends Annotation>> ignoredMethodAnnotations) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(DefaultTypeAnnotationMetadataStore.allAnnotationCategories(propertyAnnotationCategories, ignoredMethodAnnotations));
        builder.put(Inject.class, (Object)AnnotationCategory.TYPE);
        return builder.build();
    }

    private static ImmutableMap<Class<? extends Annotation>, AnnotationCategory> allAnnotationCategories(Map<Class<? extends Annotation>, ? extends AnnotationCategory> annotationCategories, Collection<Class<? extends Annotation>> ignoredMethodAnnotations) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(annotationCategories);
        for (Class<? extends Annotation> ignoredMethodAnnotation : ignoredMethodAnnotations) {
            builder.put(ignoredMethodAnnotation, (Object)AnnotationCategory.TYPE);
        }
        return builder.build();
    }

    private static Cache<Class<?>, TypeAnnotationMetadata> initCache(Collection<Class<?>> ignoredSuperTypes, ClassCacheFactory cacheFactory) {
        Cache result = cacheFactory.newClassCache();
        for (Class<?> ignoredSuperType : ignoredSuperTypes) {
            result.put(ignoredSuperType, (Object)EMPTY_TYPE_ANNOTATION_METADATA);
        }
        return result;
    }

    private static ImmutableSet<String> allMethodNamesOf(Iterable<Class<?>> classes) {
        ImmutableSet.Builder methods = ImmutableSet.builder();
        for (Class<?> clazz : classes) {
            for (Method method : clazz.getMethods()) {
                methods.add((Object)method.getName());
            }
        }
        return methods.build();
    }

    private static ImmutableSet<Equivalence.Wrapper<Method>> allMethodsOf(Iterable<Class<?>> classes) {
        ImmutableSet.Builder methods = ImmutableSet.builder();
        for (Class<?> clazz : classes) {
            for (Method method : clazz.getMethods()) {
                methods.add((Object)Methods.SIGNATURE_EQUIVALENCE.wrap((Object)method));
            }
        }
        return methods.build();
    }

    @Override
    public TypeAnnotationMetadata getTypeAnnotationMetadata(Class<?> type) {
        return (TypeAnnotationMetadata)this.cache.get(type, this::createTypeAnnotationMetadata);
    }

    private TypeAnnotationMetadata createTypeAnnotationMetadata(Class<?> type) {
        ImmutableSortedSet functionMetadata;
        ImmutableSortedSet propertiesMetadata;
        if (type.isPrimitive() || type.isArray() || type.isAnnotation()) {
            return EMPTY_TYPE_ANNOTATION_METADATA;
        }
        Package typePackage = type.getPackage();
        if (typePackage != null) {
            String typePackageName = typePackage.getName();
            if (this.ignoredPackagePrefixes.stream().anyMatch(typePackageName::startsWith)) {
                return EMPTY_TYPE_ANNOTATION_METADATA;
            }
        }
        ImmutableSet.Builder typeAnnotations = ImmutableSet.builder();
        for (Annotation typeAnnotation : type.getDeclaredAnnotations()) {
            if (!this.recordedTypeAnnotations.contains(typeAnnotation.annotationType())) continue;
            typeAnnotations.add((Object)typeAnnotation);
        }
        HashMap<String, PropertyAnnotationMetadataBuilder> propertyMethodBuilders = new HashMap<String, PropertyAnnotationMetadataBuilder>();
        HashMap<MethodSignature, FunctionAnnotationMetadataBuilder> functionMethodBuilders = new HashMap<MethodSignature, FunctionAnnotationMetadataBuilder>();
        ReplayingTypeValidationContext validationContext = new ReplayingTypeValidationContext();
        this.inheritPropertyMethods(type, validationContext, propertyMethodBuilders);
        this.inheritFunctionMethods(type, validationContext, functionMethodBuilders);
        if (!type.isSynthetic()) {
            propertiesMetadata = this.extractPropertiesFrom(type, propertyMethodBuilders, validationContext);
            functionMetadata = this.extractFunctionsFrom(type, functionMethodBuilders, validationContext);
        } else {
            ImmutableSortedSet.Builder propertiesMetadataBuilder = ImmutableSortedSet.naturalOrder();
            for (PropertyAnnotationMetadataBuilder propertyMetadataBuilder : propertyMethodBuilders.values()) {
                propertiesMetadataBuilder.add((Object)propertyMetadataBuilder.build());
            }
            propertiesMetadata = propertiesMetadataBuilder.build();
            ImmutableSortedSet.Builder functionsMetadataBuilder = ImmutableSortedSet.naturalOrder();
            for (FunctionAnnotationMetadataBuilder functionMetadataBuilder : functionMethodBuilders.values()) {
                functionsMetadataBuilder.add((Object)functionMetadataBuilder.build());
            }
            functionMetadata = functionsMetadataBuilder.build();
        }
        return new DefaultTypeAnnotationMetadata((Iterable<? extends Annotation>)typeAnnotations.build(), (Iterable<? extends PropertyAnnotationMetadata>)propertiesMetadata, (Iterable<? extends FunctionAnnotationMetadata>)functionMetadata, validationContext);
    }

    private void inheritPropertyMethods(Class<?> type, TypeValidationContext validationContext, Map<String, PropertyAnnotationMetadataBuilder> methodBuilders) {
        this.visitSuperTypes(type, (superType, metadata) -> {
            for (PropertyAnnotationMetadata property : metadata.getPropertiesAnnotationMetadata()) {
                this.getOrCreatePropertyBuilder(property.getPropertyName(), property.getMethod(), validationContext, methodBuilders).inheritAnnotations(superType.isInterface(), property);
            }
        });
    }

    private void inheritFunctionMethods(Class<?> type, TypeValidationContext validationContext, Map<MethodSignature, FunctionAnnotationMetadataBuilder> methodBuilders) {
        this.visitSuperTypes(type, (superType, metadata) -> {
            for (FunctionAnnotationMetadata method : metadata.getFunctionAnnotationMetadata()) {
                this.getOrCreateFunctionBuilder(method.getMethod(), validationContext, methodBuilders).inheritAnnotations(superType.isInterface(), method);
            }
        });
    }

    private PropertyAnnotationMetadataBuilder getOrCreatePropertyBuilder(String propertyName, Method getter, TypeValidationContext validationContext, Map<String, PropertyAnnotationMetadataBuilder> propertyBuilders) {
        return propertyBuilders.computeIfAbsent(getter.getName(), methodName -> new PropertyAnnotationMetadataBuilder(propertyName, getter, validationContext));
    }

    private FunctionAnnotationMetadataBuilder getOrCreateFunctionBuilder(Method method, TypeValidationContext validationContext, Map<MethodSignature, FunctionAnnotationMetadataBuilder> methodBuilders) {
        return methodBuilders.computeIfAbsent(MethodSignature.of(method), methodName -> new FunctionAnnotationMetadataBuilder(method, validationContext));
    }

    private ImmutableSortedSet<PropertyAnnotationMetadata> extractPropertiesFrom(Class<?> type, Map<String, PropertyAnnotationMetadataBuilder> methodBuilders, TypeValidationContext validationContext) {
        Method[] methods = type.getDeclaredMethods();
        Arrays.sort(methods, Comparator.comparing(Method::getName));
        for (Method method : methods) {
            this.processPropertyMethodAnnotations(method, methodBuilders, validationContext);
        }
        ImmutableList<PropertyAnnotationMetadataBuilder> propertyBuilders = this.convertMethodToPropertyBuilders(methodBuilders);
        ImmutableMap<String, ImmutableMap<Class<? extends Annotation>, Annotation>> fieldAnnotationsByPropertyName = this.collectFieldAnnotations(type, validationContext);
        return this.mergePropertiesAndFieldMetadata(type, propertyBuilders, fieldAnnotationsByPropertyName, validationContext);
    }

    private ImmutableSortedSet<FunctionAnnotationMetadata> extractFunctionsFrom(Class<?> type, Map<MethodSignature, FunctionAnnotationMetadataBuilder> methodBuilders, TypeValidationContext validationContext) {
        Method[] methods = type.getDeclaredMethods();
        Arrays.sort(methods, Comparator.comparing(Method::getName));
        for (Method method : methods) {
            this.processFunctionMethodAnnotations(method, methodBuilders, validationContext);
        }
        ImmutableSortedSet.Builder methodsMetadataBuilder = ImmutableSortedSet.naturalOrder();
        methodBuilders.values().forEach(metadataBuilder -> methodsMetadataBuilder.add((Object)metadataBuilder.build()));
        return methodsMetadataBuilder.build();
    }

    private ImmutableList<PropertyAnnotationMetadataBuilder> convertMethodToPropertyBuilders(Map<String, PropertyAnnotationMetadataBuilder> methodBuilders) {
        LinkedHashMap<String, PropertyAnnotationMetadataBuilder> propertyBuilders = new LinkedHashMap<String, PropertyAnnotationMetadataBuilder>();
        List metadataBuilders = Ordering.from(Comparator.comparing(metadataBuilder -> metadataBuilder.getMethod().getName())).sortedCopy(methodBuilders.values());
        for (PropertyAnnotationMetadataBuilder metadataBuilder2 : metadataBuilders) {
            String propertyName = metadataBuilder2.getPropertyName();
            PropertyAnnotationMetadataBuilder previouslySeenBuilder = propertyBuilders.putIfAbsent(propertyName, metadataBuilder2);
            if (previouslySeenBuilder != null) {
                if (this.generatedMethodDetector.test(metadataBuilder2.getMethod()) || this.ignoredMethodAnnotations.stream().anyMatch(metadataBuilder2::hasAnnotation)) continue;
                if (this.ignoredMethodAnnotations.stream().anyMatch(previouslySeenBuilder::hasAnnotation)) {
                    propertyBuilders.put(propertyName, metadataBuilder2);
                    continue;
                }
                previouslySeenBuilder.visitPropertyProblem((Action<? super TypeAwareProblemBuilder>)problem -> problem.forProperty(propertyName).id(TextUtil.screamingSnakeToKebabCase((String)REDUNDANT_GETTERS), "Property has redundant getters", GradleCoreProblemGroup.validation().property()).contextualLabel(String.format("has redundant getters: '%s()' and '%s()'", previouslySeenBuilder.getMethod().getName(), metadataBuilder2.getMethod().getName())).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)REDUNDANT_GETTERS.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("Boolean property '" + propertyName + "' has both an `is` and a `get` getter").solution("Remove one of the getters").solution("Annotate one of the getters with @Internal"));
                continue;
            }
            Method method = metadataBuilder2.getMethod();
            if (PropertyAccessorType.of(method) != PropertyAccessorType.IS_GETTER || method.getReturnType() != Boolean.class) continue;
            if (!this.ignoredMethodAnnotations.stream().noneMatch(metadataBuilder2::hasAnnotation)) continue;
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateAction)((DeprecationMessageBuilder.DeprecateAction)DeprecationLogger.deprecateAction((String)("Declaring '" + propertyName + "' as a property using an 'is-' method with a Boolean type on " + method.getDeclaringClass().getCanonicalName())).withContext("The combination of method name and return type is not consistent with Java Bean property rules.")).withAdvice(String.format("Add a method named '%s' with the same behavior and mark the old one with @Deprecated and @ReplacedBy, or change the type of '%s.%s' (and the setter) to 'boolean'.", method.getName().replace("is", "get"), method.getDeclaringClass().getCanonicalName(), method.getName()))).startingWithGradle10("this property will no longer be treated like a property").withUpgradeGuideSection(8, "groovy_boolean_properties")).nagUser();
        }
        return ImmutableList.copyOf(propertyBuilders.values());
    }

    private ImmutableMap<String, ImmutableMap<Class<? extends Annotation>, Annotation>> collectFieldAnnotations(Class<?> type, TypeValidationContext validationContext) {
        ImmutableMap.Builder fieldAnnotationsByPropertyName = ImmutableMap.builder();
        for (Field declaredField : type.getDeclaredFields()) {
            if (declaredField.isSynthetic()) continue;
            fieldAnnotationsByPropertyName.put((Object)declaredField.getName(), DefaultTypeAnnotationMetadataStore.collectRelevantAnnotations(declaredField, this.propertyAnnotationCategories));
            ImmutableMap<Class<? extends Annotation>, Annotation> nonPropertyAnnotations = DefaultTypeAnnotationMetadataStore.collectRelevantAnnotations(declaredField, this.functionAnnotationCategories);
            if (nonPropertyAnnotations.isEmpty()) continue;
            validationContext.visitTypeProblem((Action<? super TypeAwareProblemBuilder>)((Action)problem -> problem.withAnnotationType(declaredField.getDeclaringClass()).id(TextUtil.screamingSnakeToKebabCase((String)IGNORED_ANNOTATIONS_ON_PROPERTY), "Ignored annotations on property", GradleCoreProblemGroup.validation().type()).contextualLabel(String.format("field '%s()' should not be annotated with: %s", declaredField.getName(), DefaultTypeAnnotationMetadataStore.simpleAnnotationNames(nonPropertyAnnotations.keySet().stream()))).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)IGNORED_ANNOTATIONS_ON_PROPERTY.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("Function annotations are ignored if they are placed on a field").solution("Remove the annotations")));
        }
        return fieldAnnotationsByPropertyName.build();
    }

    private ImmutableSortedSet<PropertyAnnotationMetadata> mergePropertiesAndFieldMetadata(Class<?> type, ImmutableList<PropertyAnnotationMetadataBuilder> propertyBuilders, ImmutableMap<String, ImmutableMap<Class<? extends Annotation>, Annotation>> fieldAnnotationsByPropertyName, TypeValidationContext validationContext) {
        ImmutableSortedSet.Builder propertiesMetadataBuilder = ImmutableSortedSet.naturalOrder();
        ImmutableSet.Builder fieldsSeenBuilder = ImmutableSet.builderWithExpectedSize((int)fieldAnnotationsByPropertyName.size());
        for (PropertyAnnotationMetadataBuilder metadataBuilder : propertyBuilders) {
            String propertyName = metadataBuilder.getPropertyName();
            ImmutableMap fieldAnnotations = (ImmutableMap)fieldAnnotationsByPropertyName.get((Object)propertyName);
            if (fieldAnnotations != null) {
                fieldsSeenBuilder.add((Object)propertyName);
                for (Annotation annotation : fieldAnnotations.values()) {
                    metadataBuilder.declareAnnotation(annotation);
                }
            }
            propertiesMetadataBuilder.add((Object)metadataBuilder.build());
        }
        ImmutableSortedSet propertiesMetadata = propertiesMetadataBuilder.build();
        ImmutableSet fieldsSeen = fieldsSeenBuilder.build();
        if (fieldsSeen.size() != fieldAnnotationsByPropertyName.size()) {
            fieldAnnotationsByPropertyName.entrySet().stream().filter(entry -> {
                String fieldName = (String)entry.getKey();
                ImmutableMap fieldAnnotations = (ImmutableMap)entry.getValue();
                return !fieldAnnotations.isEmpty() && !fieldsSeen.contains((Object)fieldName) && !fieldAnnotations.containsKey(Inject.class);
            }).forEach(entry -> {
                String fieldName = (String)entry.getKey();
                ImmutableMap fieldAnnotations = (ImmutableMap)entry.getValue();
                validationContext.visitTypeProblem((Action<? super TypeAwareProblemBuilder>)((Action)problem -> problem.withAnnotationType(type).id(TextUtil.screamingSnakeToKebabCase((String)IGNORED_ANNOTATIONS_ON_FIELD), "Incorrect annotations on field", GradleCoreProblemGroup.validation().property()).contextualLabel(String.format("field '%s' without corresponding getter has been annotated with %s", fieldName, DefaultTypeAnnotationMetadataStore.simpleAnnotationNames(fieldAnnotations.keySet().stream()))).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)IGNORED_ANNOTATIONS_ON_FIELD.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("Annotations on fields are only used if there's a corresponding getter for the field").solution("Add a getter for field '" + fieldName + "'").solution("Remove the annotations on '" + fieldName + "'")));
            });
        }
        return propertiesMetadata;
    }

    private boolean shouldIgnore(Method method) {
        if (method.isSynthetic()) {
            return true;
        }
        if (method.isBridge()) {
            return true;
        }
        return this.isIgnoredGeneratedGroovyMethod(method);
    }

    private boolean isIgnoredGeneratedGroovyMethod(Method method) {
        return this.generatedMethodDetector.test(method) && method.getName().contains("$");
    }

    private void processPropertyMethodAnnotations(Method method, Map<String, PropertyAnnotationMetadataBuilder> propertyBuilders, TypeValidationContext validationContext) {
        if (this.shouldIgnore(method)) {
            return;
        }
        if (this.potentiallyIgnoredMethodNames.contains((Object)method.getName()) && this.globallyIgnoredMethods.contains((Object)Methods.SIGNATURE_EQUIVALENCE.wrap((Object)method))) {
            return;
        }
        ImmutableMap<Class<? extends Annotation>, Annotation> annotations = DefaultTypeAnnotationMetadataStore.collectRelevantAnnotations(method, this.propertyAnnotationCategories);
        if (Modifier.isStatic(method.getModifiers())) {
            DefaultTypeAnnotationMetadataStore.validateNotAnnotatedForProperty(MethodKind.STATIC, method, (Set<Class<? extends Annotation>>)annotations.keySet(), validationContext);
            return;
        }
        PropertyAccessorType accessorType = PropertyAccessorType.of(method);
        if (accessorType == null) {
            DefaultTypeAnnotationMetadataStore.validateNotAnnotatedForProperty(MethodKind.FUNCTION, method, (Set<Class<? extends Annotation>>)annotations.keySet(), validationContext);
            return;
        }
        String propertyName = accessorType.propertyNameFor(method);
        if (accessorType == PropertyAccessorType.SETTER) {
            DefaultTypeAnnotationMetadataStore.validateNotAnnotatedForProperty(MethodKind.SETTER, method, (Set<Class<? extends Annotation>>)annotations.keySet(), validationContext);
            this.validateSetterForMutableType(method, accessorType, validationContext, propertyName);
            return;
        }
        boolean privateGetter = Modifier.isPrivate(method.getModifiers());
        if (privateGetter && annotations.isEmpty()) {
            return;
        }
        PropertyAnnotationMetadataBuilder metadataBuilder = this.getOrCreatePropertyBuilder(propertyName, method, validationContext, propertyBuilders);
        metadataBuilder.overrideMethod(method);
        if (privateGetter) {
            metadataBuilder.visitPropertyProblem((Action<? super TypeAwareProblemBuilder>)problem -> problem.forProperty(propertyName).id(TextUtil.screamingSnakeToKebabCase((String)PRIVATE_GETTER_MUST_NOT_BE_ANNOTATED), "Private property with wrong annotation", GradleCoreProblemGroup.validation().property()).contextualLabel(String.format("is private and annotated with %s", DefaultTypeAnnotationMetadataStore.simpleAnnotationNames(annotations.keySet().stream()))).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)PRIVATE_GETTER_MUST_NOT_BE_ANNOTATED.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("Annotations on private getters are ignored").solution("Make the getter public").solution("Annotate the public version of the getter"));
        }
        for (Annotation annotation : annotations.values()) {
            metadataBuilder.declareAnnotation(annotation);
        }
    }

    private void processFunctionMethodAnnotations(Method method, Map<MethodSignature, FunctionAnnotationMetadataBuilder> functionBuilders, TypeValidationContext validationContext) {
        if (this.shouldIgnore(method)) {
            return;
        }
        if (this.potentiallyIgnoredMethodNames.contains((Object)method.getName()) && this.globallyIgnoredMethods.contains((Object)Methods.SIGNATURE_EQUIVALENCE.wrap((Object)method))) {
            return;
        }
        ImmutableMap<Class<? extends Annotation>, Annotation> annotations = DefaultTypeAnnotationMetadataStore.collectRelevantAnnotations(method, this.functionAnnotationCategories);
        if (annotations.isEmpty()) {
            return;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            DefaultTypeAnnotationMetadataStore.validateNotAnnotatedForStaticFunction(method, (Set<Class<? extends Annotation>>)annotations.keySet(), validationContext);
            return;
        }
        PropertyAccessorType accessorType = PropertyAccessorType.of(method);
        if (accessorType != null) {
            DefaultTypeAnnotationMetadataStore.validateNotAnnotatedForPropertyGetter(method, (Set<Class<? extends Annotation>>)annotations.keySet(), validationContext);
            return;
        }
        FunctionAnnotationMetadataBuilder metadataBuilder = this.getOrCreateFunctionBuilder(method, validationContext, functionBuilders);
        metadataBuilder.overrideMethod(method);
        boolean privateMethod = Modifier.isPrivate(method.getModifiers());
        if (privateMethod) {
            metadataBuilder.visitFunctionProblem((Action<? super TypeAwareProblemBuilder>)problem -> problem.forFunction(method.getName()).id(TextUtil.screamingSnakeToKebabCase((String)PRIVATE_METHOD_MUST_NOT_BE_ANNOTATED), "Private method with wrong annotation", GradleCoreProblemGroup.validation().property()).contextualLabel(String.format("is private and annotated with %s", DefaultTypeAnnotationMetadataStore.simpleAnnotationNames(annotations.keySet().stream()))).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)PRIVATE_METHOD_MUST_NOT_BE_ANNOTATED.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("Annotations on private methods are ignored").solution("Make the method public").solution("Annotate the public version of the method"));
        }
        for (Annotation annotation : annotations.values()) {
            metadataBuilder.declareAnnotation(annotation);
        }
    }

    private void validateSetterForMutableType(Method setterMethod, PropertyAccessorType setterAccessorType, TypeValidationContext validationContext, String propertyName) {
        Class<?> setterType = setterAccessorType.propertyTypeFor(setterMethod);
        if (this.isSetterProhibitedForType(setterType)) {
            validationContext.visitPropertyProblem((Action<? super TypeAwareProblemBuilder>)((Action)problem -> problem.forProperty(propertyName).id(TextUtil.screamingSnakeToKebabCase((String)MUTABLE_TYPE_WITH_SETTER), "Mutable type with setter", GradleCoreProblemGroup.validation().property()).contextualLabel(String.format("of mutable type '%s' is writable", setterType.getName())).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)MUTABLE_TYPE_WITH_SETTER.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("Properties of type '" + setterType.getName() + "' are already mutable").solution("Remove the '" + setterMethod.getName() + "' method")));
        }
    }

    private boolean isSetterProhibitedForType(Class<?> setter) {
        return this.mutableNonFinalClasses.stream().anyMatch(prohibited -> prohibited.isAssignableFrom(setter));
    }

    private void visitSuperTypes(Class<?> type, TypeAnnotationMetadataVisitor visitor) {
        Arrays.stream(type.getInterfaces()).forEach(superInterface -> visitor.visitType((Class<?>)superInterface, this.getTypeAnnotationMetadata((Class<?>)superInterface)));
        Class<?> superclass = type.getSuperclass();
        if (superclass != null) {
            visitor.visitType(superclass, this.getTypeAnnotationMetadata(superclass));
        }
    }

    private static void validateNotAnnotatedForProperty(MethodKind methodKind, Method method, Set<Class<? extends Annotation>> annotationTypes, TypeValidationContext validationContext) {
        if (!annotationTypes.isEmpty()) {
            validationContext.visitTypeProblem((Action<? super TypeAwareProblemBuilder>)((Action)problem -> problem.withAnnotationType(method.getDeclaringClass()).id(TextUtil.screamingSnakeToKebabCase((String)IGNORED_ANNOTATIONS_ON_METHOD), "Ignored annotations on method", GradleCoreProblemGroup.validation().type()).contextualLabel(String.format("%s '%s()' should not be annotated with: %s", methodKind.getDisplayName(), method.getName(), DefaultTypeAnnotationMetadataStore.simpleAnnotationNames(annotationTypes.stream()))).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)IGNORED_ANNOTATIONS_ON_METHOD.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("Input/Output annotations are ignored if they are placed on something else than a getter").solution("Remove the annotations").solution("Rename the method")));
        }
    }

    private static void validateNotAnnotatedForPropertyGetter(Method method, Set<Class<? extends Annotation>> annotationTypes, TypeValidationContext validationContext) {
        if (!annotationTypes.isEmpty()) {
            validationContext.visitTypeProblem((Action<? super TypeAwareProblemBuilder>)((Action)problem -> problem.withAnnotationType(method.getDeclaringClass()).id(TextUtil.screamingSnakeToKebabCase((String)IGNORED_ANNOTATIONS_ON_PROPERTY), "Ignored annotations on property", GradleCoreProblemGroup.validation().type()).contextualLabel(String.format("%s '%s()' should not be annotated with: %s", MethodKind.PROPERTY.getDisplayName(), method.getName(), DefaultTypeAnnotationMetadataStore.simpleAnnotationNames(annotationTypes.stream()))).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)IGNORED_ANNOTATIONS_ON_PROPERTY.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("Function annotations are ignored if they are placed on a property getter").solution("Remove the annotations").solution("Rename the method")));
        }
    }

    private static void validateNotAnnotatedForStaticFunction(Method method, Set<Class<? extends Annotation>> annotationTypes, TypeValidationContext validationContext) {
        if (!annotationTypes.isEmpty()) {
            validationContext.visitTypeProblem((Action<? super TypeAwareProblemBuilder>)((Action)problem -> problem.withAnnotationType(method.getDeclaringClass()).id(TextUtil.screamingSnakeToKebabCase((String)IGNORED_ANNOTATIONS_ON_PROPERTY), "Ignored annotations on property", GradleCoreProblemGroup.validation().type()).contextualLabel(String.format("%s '%s()' should not be annotated with: %s", MethodKind.STATIC.getDisplayName(), method.getName(), DefaultTypeAnnotationMetadataStore.simpleAnnotationNames(annotationTypes.stream()))).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)IGNORED_ANNOTATIONS_ON_PROPERTY.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("Function annotations are ignored if they are placed on a static method").solution("Remove the annotations").solution("Make the method non-static")));
        }
    }

    private static String simpleAnnotationNames(Stream<Class<? extends Annotation>> annotationTypes) {
        return annotationTypes.map(annotationType -> "@" + annotationType.getSimpleName()).collect(Collectors.joining(", "));
    }

    private static ImmutableMap<Class<? extends Annotation>, Annotation> collectRelevantAnnotations(AnnotatedElement element, ImmutableMap<Class<? extends Annotation>, AnnotationCategory> relevantCategories) {
        Annotation[] annotations = element.getDeclaredAnnotations();
        if (annotations.length == 0) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder relevantAnnotations = ImmutableMap.builderWithExpectedSize((int)annotations.length);
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!relevantCategories.containsKey(annotationType)) continue;
            relevantAnnotations.put(annotationType, (Object)annotation);
        }
        return relevantAnnotations.build();
    }

    private class PropertyAnnotationMetadataBuilder
    extends HasAnnotationMetadataBuilder
    implements Comparable<PropertyAnnotationMetadataBuilder> {
        private final String propertyName;

        public PropertyAnnotationMetadataBuilder(String propertyName, Method getter, TypeValidationContext validationContext) {
            super(getter, validationContext);
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        protected ImmutableMap<Class<? extends Annotation>, AnnotationCategory> geAnnotationCategories() {
            return DefaultTypeAnnotationMetadataStore.this.propertyAnnotationCategories;
        }

        public PropertyAnnotationMetadata build() {
            return new DefaultPropertyAnnotationMetadata(this.propertyName, this.getMethod(), this.resolveAnnotations());
        }

        private void visitPropertyProblem(Action<? super TypeAwareProblemBuilder> problemSpec) {
            this.validationContext.visitPropertyProblem(problemSpec);
        }

        @Override
        protected ImmutableMap<AnnotationCategory, Annotation> resolveAnnotations() {
            List declaredTypes = this.declaredAnnotations.get((Object)AnnotationCategory.TYPE);
            for (Annotation declaredType : declaredTypes) {
                Class<? extends Annotation> ignoredMethodAnnotation = declaredType.annotationType();
                if (!DefaultTypeAnnotationMetadataStore.this.ignoredMethodAnnotations.contains(ignoredMethodAnnotation)) continue;
                if (this.declaredAnnotations.values().size() > 1 && this.ignoreAnnotationDisallowedModifiers(this.declaredAnnotations.values()).count() > 1L) {
                    this.handleAnnotatedIgnoredMethod(ignoredMethodAnnotation);
                }
                return ImmutableMap.of((Object)AnnotationCategory.TYPE, (Object)declaredType);
            }
            return super.resolveAnnotations();
        }

        private Stream<Annotation> ignoreAnnotationDisallowedModifiers(Collection<Annotation> annotations) {
            return annotations.stream().filter(annotation -> !DefaultTypeAnnotationMetadataStore.this.ignoredMethodAnnotationsAllowedModifiers.contains(annotation.annotationType()));
        }

        private void handleAnnotatedIgnoredMethod(Class<? extends Annotation> ignoredMethodAnnotation) {
            this.visitPropertyProblem((Action<? super TypeAwareProblemBuilder>)((Action)problem -> problem.forProperty(this.propertyName).id(TextUtil.screamingSnakeToKebabCase((String)"IGNORED_PROPERTY_MUST_NOT_BE_ANNOTATED"), "Has wrong combination of annotations", GradleCoreProblemGroup.validation().property()).contextualLabel(String.format("annotated with @%s should not be also annotated with %s", ignoredMethodAnnotation.getSimpleName(), DefaultTypeAnnotationMetadataStore.simpleAnnotationNames(this.ignoreAnnotationDisallowedModifiers(this.declaredAnnotations.values()).map(Annotation::annotationType).filter(annotationType -> !annotationType.equals(ignoredMethodAnnotation))))).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)"IGNORED_PROPERTY_MUST_NOT_BE_ANNOTATED".toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("A property is ignored but also has input annotations").solution("Remove the input annotations").solution("Remove the @" + ignoredMethodAnnotation.getSimpleName() + " annotation")));
        }

        @Override
        protected void handleConflictingAnnotation(String source, AnnotationCategory category, Collection<Annotation> annotationsForCategory) {
            this.visitPropertyProblem((Action<? super TypeAwareProblemBuilder>)((Action)problem -> problem.forProperty(this.propertyName).id(TextUtil.screamingSnakeToKebabCase((String)"CONFLICTING_ANNOTATIONS"), StringUtils.capitalize((String)category.getDisplayName()) + " has conflicting annotation", GradleCoreProblemGroup.validation().property()).contextualLabel(String.format("has conflicting %s annotations %s: %s", category.getDisplayName(), source, DefaultTypeAnnotationMetadataStore.simpleAnnotationNames(annotationsForCategory.stream().map(Annotation::annotationType)))).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)"CONFLICTING_ANNOTATIONS".toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("The different annotations have different semantics and Gradle cannot determine which one to pick").solution("Choose between one of the conflicting annotations")));
        }

        @Override
        public int compareTo(PropertyAnnotationMetadataBuilder o) {
            return this.propertyName.compareTo(o.propertyName);
        }
    }

    private class FunctionAnnotationMetadataBuilder
    extends HasAnnotationMetadataBuilder
    implements Comparable<FunctionAnnotationMetadataBuilder> {
        public FunctionAnnotationMetadataBuilder(Method method, TypeValidationContext validationContext) {
            super(method, validationContext);
        }

        @Override
        protected ImmutableMap<Class<? extends Annotation>, AnnotationCategory> geAnnotationCategories() {
            return DefaultTypeAnnotationMetadataStore.this.functionAnnotationCategories;
        }

        public FunctionAnnotationMetadata build() {
            return new DefaultFunctionAnnotationMetadata(this.getMethod(), this.resolveAnnotations());
        }

        private void visitFunctionProblem(Action<? super TypeAwareProblemBuilder> problemSpec) {
            this.validationContext.visitTypeProblem(problemSpec);
        }

        @Override
        protected void handleConflictingAnnotation(String source, AnnotationCategory category, Collection<Annotation> annotationsForCategory) {
            this.visitFunctionProblem((Action<? super TypeAwareProblemBuilder>)((Action)problem -> problem.forFunction(this.getMethod().getName()).id(TextUtil.screamingSnakeToKebabCase((String)"CONFLICTING_ANNOTATIONS"), StringUtils.capitalize((String)category.getDisplayName()) + " has conflicting annotation", GradleCoreProblemGroup.validation().type()).contextualLabel(String.format("has conflicting %s annotations %s: %s", category.getDisplayName(), source, DefaultTypeAnnotationMetadataStore.simpleAnnotationNames(annotationsForCategory.stream().map(Annotation::annotationType)))).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)"CONFLICTING_ANNOTATIONS".toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details("The different annotations have different semantics and Gradle cannot determine which one to pick").solution("Choose between one of the conflicting annotations")));
        }

        @Override
        public int compareTo(FunctionAnnotationMetadataBuilder o) {
            return this.getMethod().getName().compareTo(o.getMethod().getName());
        }
    }

    @FunctionalInterface
    private static interface TypeAnnotationMetadataVisitor {
        public void visitType(Class<?> var1, TypeAnnotationMetadata var2);
    }

    private static class MethodSignature {
        private final String name;
        private final Class<?>[] parameterTypes;

        public MethodSignature(String name, Class<?>[] parameterTypes) {
            this.name = name;
            this.parameterTypes = parameterTypes;
        }

        public static MethodSignature of(Method method) {
            return new MethodSignature(method.getName(), method.getParameterTypes());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodSignature that = (MethodSignature)o;
            return this.name.equals(that.name) && Arrays.equals(this.parameterTypes, that.parameterTypes);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + Arrays.hashCode(this.parameterTypes);
            return result;
        }
    }

    private static enum MethodKind {
        STATIC("static method"),
        PROPERTY("property"),
        FUNCTION("function"),
        SETTER("setter");

        private final String displayName;

        private MethodKind(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    private static abstract class HasAnnotationMetadataBuilder {
        protected static final String IGNORED_PROPERTY_MUST_NOT_BE_ANNOTATED = "IGNORED_PROPERTY_MUST_NOT_BE_ANNOTATED";
        protected static final String CONFLICTING_ANNOTATIONS = "CONFLICTING_ANNOTATIONS";
        protected final ListMultimap<AnnotationCategory, Annotation> declaredAnnotations = MultimapBuilder.treeKeys(Comparator.comparing(Describable::getDisplayName)).arrayListValues().build();
        protected final SetMultimap<AnnotationCategory, Annotation> inheritedInterfaceAnnotations = MultimapBuilder.treeKeys(Comparator.comparing(Describable::getDisplayName)).linkedHashSetValues().build();
        protected final SetMultimap<AnnotationCategory, Annotation> inheritedSuperclassAnnotations = MultimapBuilder.treeKeys(Comparator.comparing(Describable::getDisplayName)).linkedHashSetValues().build();
        protected final TypeValidationContext validationContext;
        protected Method method;

        private HasAnnotationMetadataBuilder(Method method, TypeValidationContext validationContext) {
            this.overrideMethod(method);
            this.validationContext = validationContext;
        }

        public Method getMethod() {
            return this.method;
        }

        public void overrideMethod(Method method) {
            this.method = method;
        }

        public void declareAnnotation(Annotation annotation) {
            AnnotationCategory category = (AnnotationCategory)this.geAnnotationCategories().get(annotation.annotationType());
            this.declaredAnnotations.put((Object)category, (Object)annotation);
        }

        public void inheritAnnotations(boolean fromInterface, HasAnnotationMetadata superProperty) {
            superProperty.getAnnotationsByCategory().forEach((arg_0, arg_1) -> (fromInterface ? this.inheritedInterfaceAnnotations : this.inheritedSuperclassAnnotations).put(arg_0, arg_1));
        }

        protected ImmutableSet<AnnotationCategory> allAnnotationCategories() {
            return ImmutableSet.builder().addAll((Iterable)this.declaredAnnotations.keySet()).addAll((Iterable)this.inheritedInterfaceAnnotations.keySet()).addAll((Iterable)this.inheritedSuperclassAnnotations.keySet()).build();
        }

        public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
            Iterable allAnnotations = Iterables.concat((Iterable)this.declaredAnnotations.values(), (Iterable)this.inheritedInterfaceAnnotations.values(), (Iterable)this.inheritedSuperclassAnnotations.values());
            for (Annotation annotation : allAnnotations) {
                if (!annotation.annotationType().equals(annotationType)) continue;
                return true;
            }
            return false;
        }

        protected ImmutableMap<AnnotationCategory, Annotation> resolveAnnotations() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (AnnotationCategory category : this.allAnnotationCategories()) {
                Annotation resolvedAnnotation;
                List declaredAnnotationsForCategory = this.declaredAnnotations.get((Object)category);
                if (!declaredAnnotationsForCategory.isEmpty()) {
                    resolvedAnnotation = this.resolveAnnotation("declared", category, declaredAnnotationsForCategory);
                } else {
                    Set interfaceAnnotations = this.inheritedInterfaceAnnotations.get((Object)category);
                    if (!interfaceAnnotations.isEmpty()) {
                        resolvedAnnotation = this.resolveAnnotation("inherited (from interface)", category, interfaceAnnotations);
                    } else {
                        Set superclassAnnotations = this.inheritedSuperclassAnnotations.get((Object)category);
                        resolvedAnnotation = this.resolveAnnotation("inherited (from superclass)", category, superclassAnnotations);
                    }
                }
                builder.put((Object)category, (Object)resolvedAnnotation);
            }
            return builder.build();
        }

        private Annotation resolveAnnotation(String source, AnnotationCategory category, Collection<Annotation> annotationsForCategory) {
            Iterator<Annotation> declaredAnnotationForCategoryIterator = annotationsForCategory.iterator();
            Annotation declaredAnnotationForCategory = declaredAnnotationForCategoryIterator.next();
            if (declaredAnnotationForCategoryIterator.hasNext()) {
                this.handleConflictingAnnotation(source, category, annotationsForCategory);
            }
            return declaredAnnotationForCategory;
        }

        protected abstract ImmutableMap<Class<? extends Annotation>, AnnotationCategory> geAnnotationCategories();

        protected abstract void handleConflictingAnnotation(String var1, AnnotationCategory var2, Collection<Annotation> var3);
    }
}

