/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestResult;
import org.jspecify.annotations.Nullable;

public class TestState {
    public final TestDescriptorInternal test;
    final TestStartEvent startEvent;
    private final Map<Object, TestState> executing;
    public boolean failedChild;
    public List<TestFailure> failures = new ArrayList<TestFailure>();
    public @Nullable TestFailure assumptionFailure = null;
    public long testCount;
    public long successfulCount;
    public long failedCount;
    public TestResult.ResultType resultType;
    TestCompleteEvent completeEvent;

    public TestState(TestDescriptorInternal test, TestStartEvent startEvent, Map<Object, TestState> executing) {
        this.test = test;
        this.startEvent = startEvent;
        this.executing = executing;
    }

    public boolean isFailed() {
        return this.failedChild || !this.failures.isEmpty();
    }

    public long getStartTime() {
        return this.startEvent.getStartTime();
    }

    public long getEndTime() {
        return this.completeEvent.getEndTime();
    }

    public long getExecutionTime() {
        return this.completeEvent.getEndTime() - this.startEvent.getStartTime();
    }

    public void completed(TestCompleteEvent event) {
        TestState parentState;
        this.completeEvent = event;
        TestResult.ResultType resultType = this.isFailed() ? TestResult.ResultType.FAILURE : (this.resultType = event.getResultType() != null ? event.getResultType() : TestResult.ResultType.SUCCESS);
        if (!this.test.isComposite()) {
            this.testCount = 1L;
            switch (this.resultType) {
                case SUCCESS: {
                    this.successfulCount = 1L;
                    break;
                }
                case FAILURE: {
                    this.failedCount = 1L;
                    break;
                }
            }
        }
        if (this.startEvent.getParentId() != null && (parentState = this.executing.get(this.startEvent.getParentId())) != null) {
            if (this.isFailed()) {
                parentState.failedChild = true;
            }
            parentState.testCount += this.testCount;
            parentState.successfulCount += this.successfulCount;
            parentState.failedCount += this.failedCount;
        }
    }
}

