/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.id.IdGenerator;
import org.gradle.launcher.daemon.client.DaemonClient;
import org.gradle.launcher.daemon.client.DaemonClientConnection;
import org.gradle.launcher.daemon.client.DaemonConnector;
import org.gradle.launcher.daemon.client.ReportStatusDispatcher;
import org.gradle.launcher.daemon.context.DaemonConnectDetails;
import org.gradle.launcher.daemon.protocol.Command;
import org.gradle.launcher.daemon.protocol.ReportStatus;
import org.gradle.launcher.daemon.protocol.Status;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.registry.DaemonStopEvent;
import org.gradle.launcher.daemon.registry.DaemonStopEvents;

public class ReportDaemonStatusClient {
    private static final Logger LOGGER = Logging.getLogger(DaemonClient.class);
    private final DaemonRegistry daemonRegistry;
    private final DaemonConnector connector;
    private final IdGenerator<UUID> idGenerator;
    private final ReportStatusDispatcher reportStatusDispatcher;
    private final DocumentationRegistry documentationRegistry;
    public static final String STATUS_FOOTER = "Only Daemons for the current Gradle version are displayed.";
    private static final String STATUS_FORMAT = "%1$6s %2$-8s %3$s";

    public ReportDaemonStatusClient(DaemonRegistry daemonRegistry, DaemonConnector connector, IdGenerator<UUID> idGenerator, DocumentationRegistry documentationRegistry) {
        Preconditions.checkNotNull((Object)daemonRegistry, (Object)"DaemonRegistry must not be null");
        Preconditions.checkNotNull((Object)connector, (Object)"DaemonConnector must not be null");
        Preconditions.checkNotNull(idGenerator, (Object)"IdGenerator must not be null");
        Preconditions.checkNotNull((Object)documentationRegistry, (Object)"DocumentationRegistry must not be null");
        this.daemonRegistry = daemonRegistry;
        this.connector = connector;
        this.idGenerator = idGenerator;
        this.reportStatusDispatcher = new ReportStatusDispatcher();
        this.documentationRegistry = documentationRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listAll() {
        List daemons = this.daemonRegistry.getAll();
        ArrayList<Status> statuses = new ArrayList<Status>();
        for (DaemonInfo daemon : daemons) {
            DaemonClientConnection connection = this.connector.maybeConnect((DaemonConnectDetails)daemon);
            if (connection == null) continue;
            try {
                ReportStatus statusCommand = new ReportStatus((UUID)this.idGenerator.generateId(), daemon.getToken());
                Status status = this.reportStatusDispatcher.dispatch(connection, (Command)statusCommand);
                if (status != null) {
                    statuses.add(status);
                    continue;
                }
                statuses.add(new Status(connection.getDaemon().getPid(), "UNKNOWN", "UNKNOWN"));
            }
            finally {
                connection.stop();
            }
        }
        List stopEvents = DaemonStopEvents.uniqueRecentDaemonStopEvents((List)this.daemonRegistry.getStopEvents());
        if (statuses.isEmpty()) {
            LOGGER.quiet("No Gradle daemons are running.");
        }
        if (!statuses.isEmpty() || !stopEvents.isEmpty()) {
            LOGGER.quiet(String.format(STATUS_FORMAT, "PID", "STATUS", "INFO"));
        }
        this.printRunningDaemons(statuses);
        this.printStoppedDaemons(stopEvents);
        LOGGER.quiet("");
        LOGGER.quiet("Only Daemons for the current Gradle version are displayed. " + this.documentationRegistry.getDocumentationRecommendationFor("on this", "gradle_daemon", "sec:status"));
    }

    @VisibleForTesting
    void printRunningDaemons(List<Status> statuses) {
        if (!statuses.isEmpty()) {
            for (Status status : statuses) {
                Long pid = status.getPid();
                LOGGER.quiet(String.format(STATUS_FORMAT, pid == null ? "PID unknown" : pid, status.getStatus(), status.getVersion()));
            }
        }
    }

    @VisibleForTesting
    void printStoppedDaemons(List<DaemonStopEvent> stopEvents) {
        if (!stopEvents.isEmpty()) {
            for (DaemonStopEvent event : stopEvents) {
                Long pid = event.getPid();
                LOGGER.quiet(String.format(STATUS_FORMAT, pid == null ? "PID unknown" : pid, "STOPPED", "(" + event.getReason() + ")"));
            }
        }
    }
}

