/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.tasks.compile.daemon.CompilerWorkerExecutor;
import org.gradle.api.internal.tasks.scala.DaemonScalaCompiler;
import org.gradle.api.internal.tasks.scala.HashedClasspath;
import org.gradle.api.internal.tasks.scala.NormalizingScalaCompiler;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.classloader.ClasspathHasher;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerFactory;
import org.gradle.process.internal.JavaForkOptionsFactory;

public class ScalaCompilerFactory
implements CompilerFactory<ScalaJavaJointCompileSpec> {
    private final CompilerWorkerExecutor compilerWorkerExecutor;
    private final FileCollection scalaClasspath;
    private final FileCollection zincClasspath;
    private final File daemonWorkingDir;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final ClassPathRegistry classPathRegistry;
    private final ClassLoaderRegistry classLoaderRegistry;
    private final ClasspathHasher classpathHasher;

    public ScalaCompilerFactory(File daemonWorkingDir, CompilerWorkerExecutor compilerWorkerExecutor, FileCollection scalaClasspath, FileCollection zincClasspath, JavaForkOptionsFactory forkOptionsFactory, ClassPathRegistry classPathRegistry, ClassLoaderRegistry classLoaderRegistry, ClasspathHasher classpathHasher) {
        this.daemonWorkingDir = daemonWorkingDir;
        this.compilerWorkerExecutor = compilerWorkerExecutor;
        this.scalaClasspath = scalaClasspath;
        this.zincClasspath = zincClasspath;
        this.forkOptionsFactory = forkOptionsFactory;
        this.classPathRegistry = classPathRegistry;
        this.classLoaderRegistry = classLoaderRegistry;
        this.classpathHasher = classpathHasher;
    }

    public Compiler<ScalaJavaJointCompileSpec> newCompiler(ScalaJavaJointCompileSpec spec) {
        Set scalaClasspathFiles = this.scalaClasspath.getFiles();
        Set zincClasspathFiles = this.zincClasspath.getFiles();
        HashedClasspath hashedScalaClasspath = new HashedClasspath(DefaultClassPath.of((Collection)scalaClasspathFiles), this.classpathHasher);
        DaemonScalaCompiler scalaCompiler = new DaemonScalaCompiler(this.daemonWorkingDir, hashedScalaClasspath, this.compilerWorkerExecutor, zincClasspathFiles, this.forkOptionsFactory, this.classPathRegistry, this.classLoaderRegistry);
        return new NormalizingScalaCompiler((Compiler<ScalaJavaJointCompileSpec>)scalaCompiler);
    }
}

