/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import com.google.common.collect.Interner;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildTree.class})
public class SimpleMapInterner
implements Interner<String> {
    private final Map<String, String> internedStrings;

    private SimpleMapInterner(Map<String, String> interned) {
        this.internedStrings = interned;
    }

    public static SimpleMapInterner notThreadSafe() {
        return new SimpleMapInterner(new HashMap<String, String>());
    }

    public static SimpleMapInterner threadSafe() {
        return new SimpleMapInterner(new ConcurrentHashMap<String, String>());
    }

    public String intern(String sample) {
        if (sample == null) {
            return null;
        }
        String interned = this.internedStrings.get(sample);
        if (interned != null) {
            return interned;
        }
        this.internedStrings.put(sample, sample);
        return sample;
    }
}

