/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.transforms;

import java.io.File;
import java.io.IOException;
import java.util.function.BiConsumer;
import org.gradle.api.file.RelativePath;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Pair;
import org.gradle.internal.classpath.ClassData;
import org.gradle.internal.classpath.ClasspathBuilder;
import org.gradle.internal.classpath.ClasspathEntryVisitor;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.classpath.transforms.ClassTransform;
import org.gradle.internal.classpath.transforms.ClasspathElementTransform;
import org.gradle.internal.file.FileException;
import org.gradle.util.internal.JarUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

class BaseClasspathElementTransform
implements ClasspathElementTransform {
    private static final Logger LOGGER = Logging.getLogger(BaseClasspathElementTransform.class);
    protected final File source;
    private final ClasspathBuilder classpathBuilder;
    private final ClasspathWalker classpathWalker;
    private final ClassTransform transform;

    BaseClasspathElementTransform(File source, ClasspathBuilder classpathBuilder, ClasspathWalker classpathWalker, ClassTransform transform) {
        this.source = source;
        this.classpathBuilder = classpathBuilder;
        this.classpathWalker = classpathWalker;
        this.transform = transform;
    }

    @Override
    public final void transform(File destination) {
        this.resultBuilder().accept(destination, builder -> {
            try {
                this.visitEntries(builder);
            }
            catch (FileException e) {
                LOGGER.debug("Malformed archive '{}'. Discarding contents.", (Object)this.source.getName(), (Object)e);
            }
        });
    }

    private BiConsumer<File, ClasspathBuilder.Action> resultBuilder() {
        if (this.source.isDirectory()) {
            return this.classpathBuilder::directory;
        }
        return this.classpathBuilder::jar;
    }

    private void visitEntries(ClasspathBuilder.EntryBuilder builder) throws IOException, FileException {
        this.classpathWalker.visit(this.source, entry -> this.visitEntry(builder, entry));
        this.finishProcessing(builder);
    }

    private void visitEntry(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry entry) throws IOException {
        try {
            if (this.isClassFile(entry)) {
                this.processClassFile(builder, entry);
            } else if (this.isManifest(entry)) {
                this.processManifest(builder, entry);
            } else {
                this.processResource(builder, entry);
            }
        }
        catch (Throwable e) {
            throw new IOException("Failed to process the entry '" + entry.getName() + "' from '" + this.source + "'", e);
        }
    }

    protected void processClassFile(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry classEntry) throws IOException {
        byte[] content = classEntry.getContent();
        ClassReader reader = new ClassReader(content);
        ClassWriter classWriter = new ClassWriter(1);
        Pair<RelativePath, ClassVisitor> chain = this.transform.apply(classEntry, (ClassVisitor)classWriter, new ClassData(reader, content));
        reader.accept((ClassVisitor)chain.right, 0);
        byte[] bytes = classWriter.toByteArray();
        builder.put(((RelativePath)chain.left).getPathString(), bytes, classEntry.getCompressionMethod());
    }

    protected void processManifest(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry manifestEntry) throws IOException {
        this.processResource(builder, manifestEntry);
    }

    protected void processResource(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry resourceEntry) throws IOException {
        builder.put(resourceEntry.getName(), resourceEntry.getContent(), resourceEntry.getCompressionMethod());
    }

    protected void finishProcessing(ClasspathBuilder.EntryBuilder builder) throws IOException {
    }

    private boolean isClassFile(ClasspathEntryVisitor.Entry entry) {
        return entry.getName().endsWith(".class");
    }

    private boolean isManifest(ClasspathEntryVisitor.Entry entry) {
        return JarUtil.isManifestName(entry.getName());
    }
}

