/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.model.annotations;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.internal.instrumentation.api.annotations.ReplacesEagerProperty;
import org.gradle.internal.reflect.annotations.AnnotationCategory;
import org.gradle.work.Incremental;
import org.gradle.work.NormalizeLineEndings;

public enum ModifierAnnotationCategory implements AnnotationCategory
{
    INCREMENTAL("incremental", Incremental.class, SkipWhenEmpty.class),
    NORMALIZATION("normalization", Classpath.class, CompileClasspath.class, PathSensitive.class),
    OPTIONAL("optional", Optional.class),
    IGNORE_EMPTY_DIRECTORIES("ignore empty directories", IgnoreEmptyDirectories.class),
    NORMALIZE_LINE_ENDINGS("ignore line endings", NormalizeLineEndings.class),
    REPLACES_EAGER_PROPERTY("replaces eager property", ReplacesEagerProperty.class);

    private final String displayName;
    private final ImmutableSet<Class<? extends Annotation>> annotations;

    @SafeVarargs
    private ModifierAnnotationCategory(String displayName, Class<? extends Annotation> ... annotations) {
        this.displayName = displayName;
        this.annotations = ImmutableSet.copyOf((Object[])annotations);
    }

    public static ImmutableSet<Class<? extends Annotation>> annotationsOf(ModifierAnnotationCategory ... categories) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Arrays.stream(categories).map(category -> category.annotations).forEach(arg_0 -> ((ImmutableSet.Builder)builder).addAll(arg_0));
        return builder.build();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static Map<Class<? extends Annotation>, AnnotationCategory> asMap(Collection<Class<? extends Annotation>> typeAnnotations) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Class<? extends Annotation> typeAnnotation : typeAnnotations) {
            builder.put(typeAnnotation, (Object)TYPE);
        }
        for (ModifierAnnotationCategory category : ModifierAnnotationCategory.values()) {
            for (Class annotation : category.annotations) {
                builder.put((Object)annotation, (Object)category);
            }
        }
        return builder.build();
    }
}

