/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;

public class DefaultBuildOperationListenerManager
implements BuildOperationListenerManager {
    private final AtomicReference<ImmutableList<ProgressShieldingBuildOperationListener>> listeners = new AtomicReference<ImmutableList>(ImmutableList.of());
    private final BuildOperationListener broadcaster = new BuildOperationListener(){

        @Override
        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            List listeners = (List)DefaultBuildOperationListenerManager.this.listeners.get();
            for (int i = 0; i < listeners.size(); ++i) {
                ((BuildOperationListener)listeners.get(i)).started(buildOperation, startEvent);
            }
        }

        @Override
        public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent progressEvent) {
            List listeners = (List)DefaultBuildOperationListenerManager.this.listeners.get();
            for (int i = 0; i < listeners.size(); ++i) {
                ((BuildOperationListener)listeners.get(i)).progress(operationIdentifier, progressEvent);
            }
        }

        @Override
        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            List listeners = (List)DefaultBuildOperationListenerManager.this.listeners.get();
            for (int i = listeners.size() - 1; i >= 0; --i) {
                ((BuildOperationListener)listeners.get(i)).finished(buildOperation, finishEvent);
            }
        }
    };

    @Override
    public void addListener(BuildOperationListener listener) {
        this.listeners.updateAndGet(current -> ImmutableList.builderWithExpectedSize((int)(current.size() + 1)).addAll((Iterable)current).add((Object)new ProgressShieldingBuildOperationListener(listener)).build());
    }

    @Override
    public void removeListener(BuildOperationListener listener) {
        this.listeners.updateAndGet(current -> (ImmutableList)current.stream().filter(l -> !((ProgressShieldingBuildOperationListener)l).delegate.equals(listener)).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public BuildOperationListener getBroadcaster() {
        return this.broadcaster;
    }

    private static class ProgressShieldingBuildOperationListener
    implements BuildOperationListener {
        private final Map<OperationIdentifier, Boolean> active = new ConcurrentHashMap<OperationIdentifier, Boolean>();
        private final BuildOperationListener delegate;

        private ProgressShieldingBuildOperationListener(BuildOperationListener delegate) {
            this.delegate = delegate;
        }

        @Override
        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            this.active.put(buildOperation.getId(), Boolean.TRUE);
            this.delegate.started(buildOperation, startEvent);
        }

        @Override
        public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent progressEvent) {
            if (this.active.containsKey(operationIdentifier)) {
                this.delegate.progress(operationIdentifier, progressEvent);
            }
        }

        @Override
        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            this.active.remove(buildOperation.getId());
            this.delegate.finished(buildOperation, finishEvent);
        }
    }
}

