/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ProgressMonitor;

public class CancellableDigestOutputStream
extends OutputStream {
    public static final int BYTES_TO_WRITE_BEFORE_CANCEL_CHECK = 131072;
    private final ProgressMonitor writeMonitor;
    private final OutputStream out;
    private final MessageDigest md = Constants.newMessageDigest();
    private long count;
    private long checkCancelAt;

    public CancellableDigestOutputStream(ProgressMonitor writeMonitor, OutputStream out) {
        this.writeMonitor = writeMonitor;
        this.out = out;
        this.checkCancelAt = 131072L;
    }

    public final ProgressMonitor getWriteMonitor() {
        return this.writeMonitor;
    }

    public final byte[] getDigest() {
        return this.md.digest();
    }

    public final long length() {
        return this.count;
    }

    @Override
    public final void write(int b) throws IOException {
        if (this.checkCancelAt <= this.count) {
            if (this.writeMonitor.isCancelled()) {
                throw new InterruptedIOException();
            }
            this.checkCancelAt = this.count + 131072L;
        }
        this.out.write(b);
        this.md.update((byte)b);
        ++this.count;
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            if (this.checkCancelAt <= this.count) {
                if (this.writeMonitor.isCancelled()) {
                    throw new InterruptedIOException();
                }
                this.checkCancelAt = this.count + 131072L;
            }
            int n = Math.min(len, 131072);
            this.out.write(b, off, n);
            this.md.update(b, off, n);
            this.count += (long)n;
            off += n;
            len -= n;
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

