/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import org.gradle.internal.logging.console.AbstractUserInputRenderer;
import org.gradle.internal.logging.console.Console;
import org.gradle.internal.logging.console.GlobalUserInputReceiver;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.RenderableOutputEvent;

public class UserInputConsoleRenderer
extends AbstractUserInputRenderer {
    private final Console console;

    public UserInputConsoleRenderer(OutputEventListener delegate, Console console, GlobalUserInputReceiver userInput) {
        super(delegate, userInput);
        this.console = console;
    }

    @Override
    void startInput() {
        this.toggleBuildProgressAreaVisibility(false);
        this.flushConsole();
    }

    @Override
    void handlePrompt(RenderableOutputEvent event) {
        event.render(this.console.getBuildOutputArea());
        this.flushConsole();
    }

    @Override
    void finishInput(RenderableOutputEvent event) {
        event.render(this.console.getBuildOutputArea());
        this.toggleBuildProgressAreaVisibility(true);
        this.flushConsole();
    }

    private void toggleBuildProgressAreaVisibility(boolean visible) {
        this.console.getBuildProgressArea().setVisible(visible);
    }

    private void flushConsole() {
        this.console.flush();
    }
}

