/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.internal;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.language.ComponentDependencies;

public class DefaultComponentDependencies
implements ComponentDependencies {
    private final Configuration implementation;
    private final DependencyHandler dependencyHandler;

    @Inject
    public DefaultComponentDependencies(RoleBasedConfigurationContainerInternal configurations, String implementationName, DependencyHandler dependencyHandler) {
        this.implementation = configurations.dependencyScopeLocked(implementationName);
        this.dependencyHandler = dependencyHandler;
    }

    protected DependencyHandler getDependencyHandler() {
        return this.dependencyHandler;
    }

    public Configuration getImplementationDependencies() {
        return this.implementation;
    }

    @Override
    public void implementation(Object notation) {
        this.implementation.getDependencies().add((Object)this.dependencyHandler.create(notation));
    }

    @Override
    public void implementation(Object notation, Action<? super ExternalModuleDependency> action) {
        ExternalModuleDependency dependency = (ExternalModuleDependency)this.dependencyHandler.create(notation);
        action.execute((Object)dependency);
        this.implementation.getDependencies().add((Object)dependency);
    }
}

