/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.internal.os.OperatingSystem;

public enum SymbolExtractorOsConfig {
    OBJCOPY("objcopy", (ImmutableList<String>)ImmutableList.of((Object)"--only-keep-debug"), ".debug"),
    DSYMUTIL("dsymutil", ImmutableList.of((Object)"-f"), ".dwarf"){

        @Override
        public List<String> getInputOutputFileArguments(String inputFilePath, String outputFilePath) {
            return ImmutableList.of((Object)"-o", (Object)outputFilePath, (Object)inputFilePath);
        }
    };

    private static final OperatingSystem OS;
    private final String executable;
    private final ImmutableList<String> arguments;
    private final String extension;

    private SymbolExtractorOsConfig(String executable, ImmutableList<String> arguments, String extension) {
        this.executable = executable;
        this.arguments = arguments;
        this.extension = extension;
    }

    public static SymbolExtractorOsConfig current() {
        if (OS.isMacOsX()) {
            return DSYMUTIL;
        }
        return OBJCOPY;
    }

    public String getExecutableName() {
        return this.executable;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public List<String> getInputOutputFileArguments(String inputFilePath, String outputFilePath) {
        return ImmutableList.of((Object)inputFilePath, (Object)outputFilePath);
    }

    public String getExtension() {
        return this.extension;
    }

    static {
        OS = OperatingSystem.current();
    }
}

