---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token GitLab pipeline trigger token'
---

## Description

The response body contains content that matches the pattern of a GitLab pipeline trigger token was identified. Pipeline trigger tokens can be used to execute pipelines for a branch or tag of a project. The token impersonates a user's project access and permissions. A malicious actor with access to this token can execute pipelines with custom variables, potentially being able to compromise the repository.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke a pipeline trigger token:

- Sign in to your GitLab account and visit the project that created the pipeline trigger token
- In the left-hand menu, select "Settings"
- Under the "Settings" options, select "CI/CD"
- Under the "Pipeline trigger tokens" section find the identified token
- Select the trash icon in the "Actions" column of the "Active pipeline trigger tokens" table
- When prompted, select "Revoke trigger"

For more information, please see [GitLabs documentation on pipeline trigger tokens](../../../../../ci/triggers/_index.md#create-a-pipeline-trigger-token).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.142 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
