---
stage: Plan
group: Optimize
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Contributor analytics
---

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

Contributor analytics give you an overview of the commits made by projects members to a project over time.

## View contributor analytics

The contributor analytics page displays a line chart with the number of commits to the selected project branch over time,
and line charts with the number of commits by each project member.

To view contributor analytics for a project:

1. On the left sidebar, select **Search or go to** and find your project.
1. Select **Analyze** > **Contributor analytics**.
1. From the **Branches** (**main**) dropdown list, select the branch you want to view commits for.
1. To view the number of commits made on a specific day, hover over the line chart.
1. Optional. To display commits only for a specific time period, select the pause icons ({{< icon name="status-paused" >}}) and slide them along the horizontal axis:

   - To change the start date, slide the left pause icon to the left or right.
   - To change the end date, slide the right pause icon to the left or right.

## View project commit history

To view a list of commits made by project members per day:

1. On the left sidebar, select **Search or go to** and find your project.
1. Select **Analyze** > **Contributor analytics**.
1. Select **History**.
1. From the **Branches** (**main**) dropdown list, select the branch you want to view commits for.
1. To view the number of commits made by the members on a specific day, hover over the line chart.
1. Optional. Filter the results.

   - To filter by author, from the **Author** dropdown list, select the user whose commits you want to view.
   - To filter by commit message, in the text box, enter your search criteria.

## Retrieve project commits as an RSS feed

To view the list of commits to the project as an RSS feed in Atom format:

1. On the left sidebar, select **Search or go to** and find your project.
1. Select **Analyze** > **Contributor analytics**.
1. Select **History**.
1. In the upper-right corner, select the feed symbol ({{< icon name="rss" >}}).
