---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: マイルストーン
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 製品: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

マイルストーンは、GitLabでの作業の追跡と整理に役立ちます。マイルストーンでは、次のことを行います。

- 関連するイシューとマージリクエストをグループ化して、目標に対する進捗状況を追跡します。
- オプションの開始日と期限を使用して、時間ベースの計画をサポートします。
- イテレーションと連携して、同時タイムボックスを追跡します。
- リリースを追跡し、リリースエビデンスを生成します。
- プロジェクトとグループに適用されます。

マイルストーンは、[プロジェクト](../_index.md)または[グループ](../../group/_index.md)に属することができます。プロジェクトマイルストーンは、そのプロジェクトのイシューとマージリクエストにのみ適用されます。グループマイルストーンは、そのグループのプロジェクト内の任意のイシューまたはマージリクエストに適用されます。

Project Milestones APIとGroup Milestones APIの詳細については、以下を参照してください。

- [Project Milestones API](../../../api/milestones.md)
- [Group Milestones API](../../../api/group_milestones.md)

## リリースとしてのマイルストーン

マイルストーンを使用して、リリースを追跡できます。これを行うには、次の手順を実行します。

1. マイルストーンの期限を、リリースのリリース日に設定します。リリースサイクルに定義された開始日がない場合は、マイルストーンの開始日を空白のままにすることができます。
1. マイルストーンのタイトルを、`Version 9.4`などのリリースのバージョンに設定します。
1. イシューの右側のサイドバーからマイルストーンを選択して、イシューをリリースに追加します。

さらに、リリースを作成するときにリリースエビデンスを自動的に生成するには、マイルストーンを[リリース機能](../releases/_index.md#associate-milestones-with-a-release)と統合します。

## プロジェクトマイルストーンとグループマイルストーン

マイルストーンは、[プロジェクト](../_index.md)または[グループ](../../group/_index.md)に属することができます。

**プロジェクトマイルストーン**は、そのプロジェクトのイシューまたはマージリクエストにのみ割り当てることができます。**グループマイルストーン**は、そのグループに含まれる任意のプロジェクトの任意のイシューまたはマージリクエストに割り当てることができます。

Project Milestones APIとGroup Milestones APIの詳細については、以下を参照してください。

- [Project Milestones API](../../../api/milestones.md)
- [Group Milestones API](../../../api/group_milestones.md)

### プロジェクトマイルストーンまたはグループマイルストーンを表示する

マイルストーンリストを表示するには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトまたはグループを見つけます。
1. **計画 > マイルストーン**を選択します。

プロジェクトでは、GitLabはプロジェクトに属するマイルストーンを表示します。グループでは、GitLabはグループおよびグループ内のすべてのプロジェクトとサブグループに属するマイルストーンを表示します。

### イシューがオフになっているプロジェクトでマイルストーンを表示する

プロジェクトでイシュートラッキングが[オフ](../settings/_index.md#configure-project-features-and-permissions)になっている場合、マイルストーンページにアクセスするには、そのURLを入力します。

これを行うには、次の手順を実行します。

1. プロジェクトに移動します。
1. プロジェクトURLに`/-/milestones`を追加します。たとえば、`https://gitlab.com/gitlab-org/sample-data-templates/sample-gitlab-project/-/milestones`などです。

または、このプロジェクトのイシューは、グループのマイルストーンページで確認できます。

このエクスペリエンスの改善は、イシュー[339009](https://gitlab.com/gitlab-org/gitlab/-/issues/339009)で追跡されています。

### すべてのマイルストーンを表示する

GitLabネームスペース全体でアクセスできるすべてのマイルストーンを表示できます。一部のマイルストーンは、自分がメンバーではないプロジェクトまたはグループに属することが原因で、表示されない場合があります。

これを行うには、次の手順を実行します。

1. 左側のサイドバーで、**検索または移動**を選択します。
1. **あなたの作業**を選択します。
1. 左側のサイドバーで、**マイルストーン**を選択します。

### マイルストーンの詳細を表示する

マイルストーンに関する詳細情報を表示するには、**マイルストーン**ページで、表示するマイルストーンのタイトルを選択します。

マイルストーンビューには、タイトルと説明が表示されます。タイトルと説明の下のタブには、次のものが表示されます。

- **イシュー**: マイルストーンに割り当てられたすべてのイシューを表示します。イシューは、次の名前の3つの列に表示されます。
  - 開始していないイシュー（オープンかつ未割り当て）
  - 進行中のイシュー（オープンかつ割り当て済）
  - 完了したイシュー（クローズ）
- **マージリクエスト**: マイルストーンに割り当てられたすべてのマージリクエストを表示します。マージリクエストは、次の名前の4つの列に表示されます。
  - 実行中（オープンかつ未割り当て）
  - マージ待ち（オープンかつ割り当て済）
  - 拒否（クローズ）
  - マージ済み
- **参加者**: マイルストーンに割り当てられたイシューのすべての担当者を表示します。
- **ラベル**: マイルストーンに割り当てられたイシューで使用されているすべてのラベルを表示します。

#### バーンダウンチャート

マイルストーンビューには、マイルストーンの完了の進捗状況を示す[バーンダウンチャートとバーンアップチャート](burndown_and_burnup_charts.md)があります。

![バーンダウンチャートとバーンアップチャート](img/burndown_and_burnup_charts_v15_3.png)

#### マイルストーンのサイドバー

マイルストーンビューのサイドバーには、以下の項目が表示されます。

- 完了率。クローズされたイシューの数をイシューの合計で割った数として計算されます
- 開始日と期限。
- マイルストーンに割り当てられたすべてのイシューとマージリクエストに費やされた合計時間。
- マイルストーンに割り当てられたすべてのイシューのイシューの重さの合計。
- 合計、オープン、クローズ、マージ済みのマージリクエストの数。
- 関連するリリースへのリンク。
- クリップボードにコピーできるマイルストーンの参照。

![プロジェクトマイルストーンページ](img/milestones_project_milestone_page_sidebar_v13_11.png)

## マイルストーンを作成する

{{< history >}}

- GitLab 15.0で、最小ユーザーロールがデベロッパーからレポーターに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/343889)されました。
- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

マイルストーンは、プロジェクトまたはグループのいずれかで作成できます。

前提要件:

- マイルストーンが属するプロジェクトまたはグループに対してプランナーロール以上を持っている必要があります。

マイルストーンを作成するには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトまたはグループを見つけます。
1. **計画 > マイルストーン**を選択します。
1. **新しいマイルストーン**を選択します。
1. タイトルを入力します。
1. オプション。説明、開始日、期限を入力します。
1. **新しいマイルストーン**を選択します。

![新しいマイルストーン](img/milestones_new_project_milestone_v16_11.png)

## マイルストーンを編集する

{{< history >}}

- GitLab 15.0で、最小ユーザーロールがデベロッパーからレポーターに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/343889)されました。
- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- マイルストーンが属するプロジェクトまたはグループに対してプランナーロール以上を持っている必要があります。

マイルストーンを編集するには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトまたはグループを見つけます。
1. **計画 > マイルストーン**を選択します。
1. マイルストーンのタイトルを選択します。
1. 右上隅にある**マイルストーンアクション**（{{< icon name="ellipsis_v" >}}）を選択し、**編集**を選択します。
1. タイトル、開始日、期限、または説明を編集します。
1. **変更の保存**を選択します。

## マイルストーンをクローズする

{{< history >}}

- GitLab 15.0で、最小ユーザーロールがデベロッパーからレポーターに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/343889)されました。
- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- マイルストーンが属するプロジェクトまたはグループに対してプランナーロール以上を持っている必要があります。

マイルストーンをクローズするには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトまたはグループを見つけます。
1. **計画 > マイルストーン**を選択します。
1. 次のいずれかの操作を行います。
   - クローズするマイルストーンの横で、**マイルストーンアクション**（{{< icon name="ellipsis_v" >}}） > **閉じる**を選択します。
   - マイルストーンのタイトルを選択し、**閉じる**を選択します。

## マイルストーンを削除する

{{< history >}}

- GitLab 15.0で、最小ユーザーロールがデベロッパーからレポーターに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/343889)されました。
- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

前提要件:

- マイルストーンが属するプロジェクトまたはグループに対してプランナーロール以上を持っている必要があります。

マイルストーンを削除するには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトまたはグループを見つけます。
1. **計画 > マイルストーン**を選択します。
1. 次のいずれかの操作を行います。
   - 削除するマイルストーンの横で、**マイルストーンアクション**（{{< icon name="ellipsis_v" >}}） > **削除**を選択します。
   - マイルストーンのタイトルを選択し、**マイルストーンアクション**（{{< icon name="ellipsis_v" >}}） > **削除**を選択します。
1. **マイルストーンを削除**を選択します。

## プロジェクトマイルストーンをグループマイルストーンにプロモートする

{{< history >}}

- GitLab 17.7で、最小ユーザーロールがレポーターからプランナーに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)されました。

{{< /history >}}

グループ内のプロジェクトが増えている場合は、このグループのプロジェクト間で同じマイルストーンを共有することをお勧めします。プロジェクトマイルストーンを親グループにプロモートして、同じグループ内の他のプロジェクトで使用できるようにすることができます。

マイルストーンをプロモートすると、このグループ内のすべてのプロジェクトを対象に、同じ名前のすべてのプロジェクトマイルストーンが1つのグループマイルストーンにマージされます。以前にこれらのプロジェクトマイルストーンのいずれかに割り当てられていたすべてのイシューとマージリクエストは、新しいグループマイルストーンに割り当てられます。

{{< alert type="warning" >}}

このアクションは元に戻すことができず、変更は永続的です。

{{< /alert >}}

前提要件:

- グループのプランナーロール以上を持っている必要があります。

プロジェクトマイルストーンをプロモートするには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **計画 > マイルストーン**を選択します。
1. 次のいずれかの操作を行います。
   - プロモートするマイルストーンの横で、**マイルストーンアクション**（{{< icon name="ellipsis_v" >}}） > **プロモート**を選択します。
   - マイルストーンのタイトルを選択し、**マイルストーンアクション**（{{< icon name="ellipsis_v" >}}） > **プロモート**を選択します。
1. **マイルストーンをプロモート**を選択します。

## マイルストーンをイシューまたはマージリクエストに割り当てる

各イシューと各マージリクエストには、1つのマイルストーンを割り当てることができます。マイルストーンは、各イシューページと各マージリクエストページの右側のサイドバーに表示されます。イシューボードにも表示されます。

マイルストーンを割り当てる、または割り当てを解除するには:

1. イシューまたはマージリクエストを表示します。
1. 右側のサイドバーで、**マイルストーン**の横にある**編集**を選択します。
1. **マイルストーンの割り当て**リストで、名前を入力してマイルストーンを検索します。プロジェクトマイルストーンとグループマイルストーンの両方から選択できます。
1. 割り当てるマイルストーンを選択します。

次の方法で、マイルストーンを割り当てる、または割り当てを解除することもできます。

- コメントまたは説明で`/milestone`[クイックアクション](../quick_actions.md)を使用する。
- イシューをボードの[マイルストーンリスト](../issue_board.md#milestone-lists)にドラッグする。
- イシューリストから[イシューを一括編集](../issues/managing_issues.md#bulk-edit-issues-from-a-project)する。

## マイルストーンでイシューとマージリクエストをフィルタリングする

### リストページのフィルター

プロジェクトおよびグループのイシュー/マージリクエストリストページから、グループマイルストーンとプロジェクトマイルストーンの両方でフィルタリングできます。

### イシューボードのフィルター

[プロジェクトイシューボード](../issue_board.md)から、次の場所でグループマイルストーンとプロジェクトマイルストーンの両方を使用してフィルタリングできます。

- [検索およびフィルターバー](../issue_board.md#filter-issues)
- [イシューボードの設定](../issue_board.md#configurable-issue-boards)

[グループイシューボード](../issue_board.md#group-issue-boards)から、次の場所でグループマイルストーンのみを使用してフィルタリングできます。

- [検索およびフィルターバー](../issue_board.md#filter-issues)
- [イシューボードの設定](../issue_board.md#configurable-issue-boards)

### 特別なマイルストーンフィルター

マイルストーンでフィルタリングするときは、特定のプロジェクトマイルストーンまたはグループマイルストーンを選択するだけでなく、特別なマイルストーンフィルターを選択することもできます。

- **なし**: マイルストーンが割り当てられていないイシューまたはマージリクエストを表示します。
- **すべて**: マイルストーンが割り当てられているイシューまたはマージリクエストを表示します。
- **今後**: 今後の期限が最も近いオープンマイルストーンが割り当てられているイシューまたはマージリクエストを表示します。
- **開始した**: 開始日が今日より前でオープンの割り当て済マイルストーンを持つイシューまたはマージリクエストを表示します。

<!--- When Upcoming and Started milestones change in GitLab 18.0, integrate the contents
of the below topic into "Special milestone filters" -->

#### 「今後」フィルターと「開始した」フィルター（非推奨）

{{< alert type="warning" >}}

この機能はGitLab 17.7で[非推奨](https://gitlab.com/gitlab-org/gitlab/-/issues/501294)になりました。18.0で[変更される予定](https://gitlab.com/gitlab-org/gitlab/-/issues/429728)です。

{{< /alert >}}

「今後」と「開始した」の特別なフィルターの動作は、今後のGitLabメジャーリリース18.0で変更される予定です。両方のフィルターの新しい動作の概要については、[イシュー429728](https://gitlab.com/gitlab-org/gitlab/-/issues/429728#proposed-issue-filter-logic-for-upcoming-and-started-milestones)を参照してください。

<!-- ## Troubleshooting

Include any troubleshooting steps that you can foresee. If you know beforehand what issues
one might have when setting this up, or when something is changed, or on upgrading, it's
important to describe those, too. Think of things that may go wrong and include them here.
This is important to minimize requests for support, and to avoid doc comments with
questions that you know someone might ask.

Each scenario can be a third-level heading, for example `### Getting error message X`.
If you have none to add when creating a doc, leave this section in place
but commented out to help encourage others to add to it in the future. -->
