/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.v8dtoa;

import java.util.Arrays;

public class FastDtoaBuilder {
    final char[] chars = new char[25];
    int end = 0;
    int point;
    boolean formatted = false;
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    void append(char c) {
        this.chars[this.end++] = c;
    }

    void decreaseLast() {
        int n = this.end - 1;
        this.chars[n] = (char)(this.chars[n] - '\u0001');
    }

    public void reset() {
        this.end = 0;
        this.formatted = false;
    }

    public String toString() {
        return "[chars:" + new String(this.chars, 0, this.end) + ", point:" + this.point + "]";
    }

    public String format() {
        if (!this.formatted) {
            int n = this.chars[0] == '-' ? 1 : 0;
            int n2 = this.point - n;
            if (n2 < -5 || n2 > 21) {
                this.toExponentialFormat(n, n2);
            } else {
                this.toFixedFormat(n, n2);
            }
            this.formatted = true;
        }
        return new String(this.chars, 0, this.end);
    }

    private void toFixedFormat(int n, int n2) {
        if (this.point < this.end) {
            if (n2 > 0) {
                System.arraycopy(this.chars, this.point, this.chars, this.point + 1, this.end - this.point);
                this.chars[this.point] = 46;
                ++this.end;
            } else {
                int n3 = n + 2 - n2;
                System.arraycopy(this.chars, n, this.chars, n3, this.end - n);
                this.chars[n] = 48;
                this.chars[n + 1] = 46;
                if (n2 < 0) {
                    Arrays.fill(this.chars, n + 2, n3, '0');
                }
                this.end += 2 - n2;
            }
        } else if (this.point > this.end) {
            Arrays.fill(this.chars, this.end, this.point, '0');
            this.end += this.point - this.end;
        }
    }

    private void toExponentialFormat(int n, int n2) {
        int n3;
        if (this.end - n > 1) {
            n3 = n + 1;
            System.arraycopy(this.chars, n3, this.chars, n3 + 1, this.end - n3);
            this.chars[n3] = 46;
            ++this.end;
        }
        this.chars[this.end++] = 101;
        n3 = 43;
        int n4 = n2 - 1;
        if (n4 < 0) {
            n3 = 45;
            n4 = -n4;
        }
        this.chars[this.end++] = n3;
        int n5 = n4 > 99 ? this.end + 2 : (n4 > 9 ? this.end + 1 : this.end);
        this.end = n5 + 1;
        do {
            int n6 = n4 % 10;
            this.chars[n5--] = digits[n6];
        } while ((n4 /= 10) != 0);
    }
}

