/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.color.Illuminants;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.LABColor;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ChromaticAdaption;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.OKLABColorValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.SRGBColorProfile;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import io.sf.jclf.math.linear3.Matrices;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.w3c.dom.DOMException;

class LABColorImpl
extends BaseColor
implements LABColor {
    private static final long serialVersionUID = 2L;
    private final BaseColor.Space colorSpace;
    private final String strSpace;
    private PrimitiveValue lightness = null;
    private PrimitiveValue a = null;
    private PrimitiveValue b = null;

    LABColorImpl(BaseColor.Space space, String string) {
        this.colorSpace = space;
        this.strSpace = string;
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.LAB;
    }

    @Override
    public String getColorSpace() {
        return this.strSpace;
    }

    @Override
    BaseColor.Space getSpace() {
        return this.colorSpace;
    }

    @Override
    void set(BaseColor baseColor) {
        super.set(baseColor);
        LABColorImpl lABColorImpl = (LABColorImpl)baseColor;
        this.lightness = lABColorImpl.getLightness();
        this.a = lABColorImpl.getA();
        this.b = lABColorImpl.getB();
    }

    @Override
    public PrimitiveValue item(int n) {
        switch (n) {
            case 0: {
                return this.alpha;
            }
            case 1: {
                return this.getLightness();
            }
            case 2: {
                return this.getA();
            }
            case 3: {
                return this.getB();
            }
        }
        return null;
    }

    @Override
    void setComponent(int n, PrimitiveValue primitiveValue) {
        switch (n) {
            case 0: {
                this.setAlpha(primitiveValue);
                break;
            }
            case 1: {
                this.setLightness(primitiveValue);
                break;
            }
            case 2: {
                this.setA(primitiveValue);
                break;
            }
            case 3: {
                this.setB(primitiveValue);
            }
        }
    }

    @Override
    public PrimitiveValue getLightness() {
        return this.lightness;
    }

    public void setLightness(PrimitiveValue primitiveValue) {
        boolean bl;
        int n;
        float f;
        if (BaseColor.Space.OK_Lab.equals((Object)this.colorSpace)) {
            f = 0.01f;
            n = 6;
            bl = false;
        } else {
            f = 1.0f;
            n = 4;
            bl = true;
        }
        this.lightness = LABColorImpl.normalizePcntToNumber(primitiveValue, f, n, bl);
    }

    @Override
    public PrimitiveValue getA() {
        return this.a;
    }

    public void setA(PrimitiveValue primitiveValue) {
        float f = BaseColor.Space.OK_Lab.equals((Object)this.colorSpace) ? 0.004f : 1.25f;
        this.a = LABColorImpl.normalizePcntToNumber(primitiveValue, f, 5, false);
    }

    @Override
    public PrimitiveValue getB() {
        return this.b;
    }

    public void setB(PrimitiveValue primitiveValue) {
        float f = BaseColor.Space.OK_Lab.equals((Object)this.colorSpace) ? 0.004f : 1.25f;
        this.b = LABColorImpl.normalizePcntToNumber(primitiveValue, f, 5, false);
    }

    @Override
    boolean hasConvertibleComponents() {
        return LABColorImpl.isConvertibleComponent(this.getA()) && LABColorImpl.isConvertibleComponent(this.getB()) && LABColorImpl.isConvertibleComponent(this.getLightness());
    }

    @Override
    void setColorComponents(double[] dArray) {
        NumberValue numberValue = NumberValue.createCSSNumberValue((short)0, (float)dArray[0]);
        numberValue.setSubproperty(true);
        numberValue.setAbsolutizedUnit();
        if (this.getSpace() == BaseColor.Space.OK_Lab) {
            numberValue.setMaximumFractionDigits(6);
        } else {
            numberValue.setMaximumFractionDigits(4);
        }
        this.setLightness(numberValue);
        NumberValue numberValue2 = NumberValue.createCSSNumberValue((short)0, (float)dArray[1]);
        numberValue2.setSubproperty(true);
        numberValue2.setAbsolutizedUnit();
        numberValue2.setMaximumFractionDigits(5);
        this.setA(numberValue2);
        NumberValue numberValue3 = NumberValue.createCSSNumberValue((short)0, (float)dArray[2]);
        numberValue3.setSubproperty(true);
        numberValue3.setAbsolutizedUnit();
        numberValue3.setMaximumFractionDigits(5);
        this.setB(numberValue3);
    }

    @Override
    public double[] toNumberArray() throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double[] dArray = new double[]{ColorUtil.floatNumber((CSSTypedValue)((Object)this.getLightness())), ColorUtil.floatNumber((CSSTypedValue)((Object)this.getA())), ColorUtil.floatNumber((CSSTypedValue)((Object)this.getB()))};
        return dArray;
    }

    @Override
    double[] toSRGB(boolean bl) {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        float f = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getLightness()));
        float f2 = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getA()));
        float f3 = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getB()));
        double[] dArray = new double[3];
        SRGBColorProfile sRGBColorProfile = new SRGBColorProfile();
        if (this.colorSpace == BaseColor.Space.OK_Lab) {
            ColorUtil.oklabToRGB(f, f2, f3, bl, sRGBColorProfile, dArray);
        } else {
            ColorUtil.labToClampedRGB(f, f2, f3, bl, sRGBColorProfile, dArray);
        }
        return dArray;
    }

    @Override
    public double[] toXYZ(Illuminant illuminant) {
        double[] dArray;
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        float f = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getLightness()));
        float f2 = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getA()));
        float f3 = ColorUtil.floatNumber((CSSTypedValue)((Object)this.getB()));
        if (this.colorSpace == BaseColor.Space.OK_Lab) {
            dArray = ColorUtil.oklabToXyzD65(f, f2, f3);
            if (illuminant == Illuminant.D50) {
                dArray = ColorUtil.d65xyzToD50(dArray);
            }
        } else {
            dArray = ColorUtil.labToXYZd50(f, f2, f3);
            if (illuminant == Illuminant.D65) {
                dArray = ColorUtil.d50xyzToD65(dArray);
            }
        }
        return dArray;
    }

    @Override
    public double[] toXYZ(double[] dArray) {
        double[] dArray2;
        double[] dArray3 = this.toNumberArray();
        if (this.colorSpace == BaseColor.Space.OK_Lab) {
            dArray2 = ColorUtil.oklabToXyzD65(dArray3[0], dArray3[1], dArray3[2]);
            if (!Arrays.equals(Illuminants.whiteD65, dArray)) {
                double[][] dArray4 = new double[3][3];
                ChromaticAdaption.chromaticAdaptionMatrix(Illuminants.whiteD65, dArray, dArray4);
                double[] dArray5 = new double[3];
                Matrices.multiplyByVector3((double[][])dArray4, (double[])dArray2, (double[])dArray5);
                dArray2 = dArray5;
            }
        } else {
            dArray2 = ColorUtil.labToXYZd50(dArray3[0], dArray3[1], dArray3[2]);
            if (!Arrays.equals(Illuminants.whiteD50, dArray)) {
                double[][] dArray6 = new double[3][3];
                ChromaticAdaption.chromaticAdaptionMatrix(Illuminants.whiteD50, dArray, dArray6);
                double[] dArray7 = new double[3];
                Matrices.multiplyByVector3((double[][])dArray6, (double[])dArray2, (double[])dArray7);
                dArray2 = dArray7;
            }
        }
        return dArray2;
    }

    @Override
    public String toString() {
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter();
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufferSimpleWriter.toString();
    }

    void writeCssText(SimpleWriter simpleWriter) throws IOException {
        if (this.colorSpace == BaseColor.Space.OK_Lab) {
            simpleWriter.write((CharSequence)"oklab(");
        } else {
            simpleWriter.write((CharSequence)"lab(");
        }
        this.lightness.writeCssText(simpleWriter);
        simpleWriter.write(' ');
        this.a.writeCssText(simpleWriter);
        simpleWriter.write(' ');
        this.b.writeCssText(simpleWriter);
        if (this.isNonOpaque()) {
            simpleWriter.write((CharSequence)" / ");
            this.appendAlphaChannel(simpleWriter);
        }
        simpleWriter.write(')');
    }

    @Override
    public String toMinifiedString() {
        StringBuilder stringBuilder = new StringBuilder(20);
        if (this.colorSpace == BaseColor.Space.OK_Lab) {
            stringBuilder.append("oklab(");
        } else {
            stringBuilder.append("lab(");
        }
        stringBuilder.append(this.lightness.getMinifiedCssText("color")).append(' ').append(this.a.getMinifiedCssText("color")).append(' ').append(this.b.getMinifiedCssText("color"));
        if (this.isNonOpaque()) {
            stringBuilder.append('/');
            this.appendAlphaChannelMinified(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = Objects.hash(new Object[]{this.getSpace()});
        n2 = 31 * n2 + (this.lightness == null ? 0 : this.lightness.hashCode());
        n2 = 31 * n2 + (this.a == null ? 0 : this.a.hashCode());
        n2 = 31 * n2 + (this.b == null ? 0 : this.b.hashCode());
        n2 = 31 * n2 + this.alpha.hashCode();
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LABColorImpl lABColorImpl = (LABColorImpl)object;
        if (this.colorSpace != lABColorImpl.colorSpace) {
            return false;
        }
        if (this.lightness == null ? lABColorImpl.lightness != null : !this.lightness.equals(lABColorImpl.lightness)) {
            return false;
        }
        if (this.a == null ? lABColorImpl.a != null : !this.a.equals(lABColorImpl.a)) {
            return false;
        }
        if (this.b == null ? lABColorImpl.b != null : !this.b.equals(lABColorImpl.b)) {
            return false;
        }
        return this.alpha.equals(lABColorImpl.alpha);
    }

    @Override
    public ColorValue packInValue() {
        if (this.colorSpace == BaseColor.Space.OK_Lab) {
            return new OKLABColorValue(this);
        }
        return new LABColorValue(this);
    }

    @Override
    public LABColorImpl clone() {
        LABColorImpl lABColorImpl = new LABColorImpl(this.colorSpace, this.strSpace);
        lABColorImpl.alpha = this.alpha.clone();
        if (this.lightness != null) {
            lABColorImpl.lightness = this.lightness.clone();
        }
        if (this.a != null) {
            lABColorImpl.a = this.a.clone();
        }
        if (this.b != null) {
            lABColorImpl.b = this.b.clone();
        }
        return lABColorImpl;
    }
}

