/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.math;

import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.Vec2f;
import com.jogamp.opengl.math.Vec4f;

public final class Vec3f {
    public static final Vec3f ONE = new Vec3f(1.0f, 1.0f, 1.0f);
    public static final Vec3f UNIT_Y = new Vec3f(0.0f, 1.0f, 0.0f);
    public static final Vec3f UNIT_Y_NEG = new Vec3f(0.0f, -1.0f, 0.0f);
    public static final Vec3f UNIT_Z = new Vec3f(0.0f, 0.0f, 1.0f);
    public static final Vec3f UNIT_Z_NEG = new Vec3f(0.0f, 0.0f, -1.0f);
    private float x;
    private float y;
    private float z;

    public Vec3f() {
    }

    public Vec3f(Vec3f vec3f) {
        this.set(vec3f);
    }

    public Vec3f(Vec4f vec4f) {
        this.set(vec4f);
    }

    public Vec3f(Vec2f vec2f, float f) {
        this.set(vec2f, f);
    }

    public Vec3f copy() {
        return new Vec3f(this);
    }

    public Vec3f(float[] fArray) {
        this.set(fArray);
    }

    public Vec3f(float f, float f2, float f3) {
        this.set(f, f2, f3);
    }

    public Vec3f set(Vec3f vec3f) {
        this.x = vec3f.x;
        this.y = vec3f.y;
        this.z = vec3f.z;
        return this;
    }

    public Vec3f set(Vec2f vec2f, float f) {
        this.x = vec2f.x();
        this.y = vec2f.y();
        this.z = f;
        return this;
    }

    public Vec3f set(Vec4f vec4f) {
        this.x = vec4f.x();
        this.y = vec4f.y();
        this.z = vec4f.z();
        return this;
    }

    public Vec3f set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        return this;
    }

    public Vec3f set(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        return this;
    }

    public void set(int n, float f) {
        switch (n) {
            case 0: {
                this.x = f;
                break;
            }
            case 1: {
                this.y = f;
                break;
            }
            case 2: {
                this.z = f;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public float[] get(float[] fArray) {
        fArray[0] = this.x;
        fArray[1] = this.y;
        fArray[2] = this.z;
        return fArray;
    }

    public float get(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public void setX(float f) {
        this.x = f;
    }

    public void setY(float f) {
        this.y = f;
    }

    public void setZ(float f) {
        this.z = f;
    }

    public Vec3f max(Vec3f vec3f) {
        this.x = Math.max(this.x, vec3f.x);
        this.y = Math.max(this.y, vec3f.y);
        this.z = Math.max(this.z, vec3f.z);
        return this;
    }

    public Vec3f min(Vec3f vec3f) {
        this.x = Math.min(this.x, vec3f.x);
        this.y = Math.min(this.y, vec3f.y);
        this.z = Math.min(this.z, vec3f.z);
        return this;
    }

    public Vec3f mul(float f) {
        return new Vec3f(this).scale(f);
    }

    public Vec3f mul(Vec3f vec3f, Vec3f vec3f2) {
        this.x = vec3f.x * vec3f2.x;
        this.y = vec3f.y * vec3f2.y;
        this.z = vec3f.z * vec3f2.z;
        return this;
    }

    public Vec3f scale(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    public Vec3f scale(float f, float f2, float f3) {
        this.x *= f;
        this.y *= f2;
        this.z *= f3;
        return this;
    }

    public Vec3f plus(Vec3f vec3f) {
        return new Vec3f(this).add(vec3f);
    }

    public Vec3f plus(Vec3f vec3f, Vec3f vec3f2) {
        this.x = vec3f.x + vec3f2.x;
        this.y = vec3f.y + vec3f2.y;
        this.z = vec3f.z + vec3f2.z;
        return this;
    }

    public Vec3f add(float f, float f2, float f3) {
        this.x += f;
        this.y += f2;
        this.z += f3;
        return this;
    }

    public Vec3f add(Vec3f vec3f) {
        this.x += vec3f.x;
        this.y += vec3f.y;
        this.z += vec3f.z;
        return this;
    }

    public Vec3f minus(Vec3f vec3f) {
        return new Vec3f(this).sub(vec3f);
    }

    public Vec3f minus(Vec3f vec3f, Vec3f vec3f2) {
        this.x = vec3f.x - vec3f2.x;
        this.y = vec3f.y - vec3f2.y;
        this.z = vec3f.z - vec3f2.z;
        return this;
    }

    public Vec3f sub(Vec3f vec3f) {
        this.x -= vec3f.x;
        this.y -= vec3f.y;
        this.z -= vec3f.z;
        return this;
    }

    public boolean isZero() {
        return FloatUtil.isZero(this.x) && FloatUtil.isZero(this.y) && FloatUtil.isZero(this.z);
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSq());
    }

    public float lengthSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vec3f normalize() {
        float f = this.lengthSq();
        if (FloatUtil.isZero(f)) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
        } else {
            float f2 = 1.0f / (float)Math.sqrt(f);
            this.x *= f2;
            this.y *= f2;
            this.z *= f2;
        }
        return this;
    }

    public float distSq(Vec3f vec3f) {
        float f = this.x - vec3f.x;
        float f2 = this.y - vec3f.y;
        float f3 = this.z - vec3f.z;
        return f * f + f2 * f2 + f3 * f3;
    }

    public float dist(Vec3f vec3f) {
        return (float)Math.sqrt(this.distSq(vec3f));
    }

    public float dot(Vec3f vec3f) {
        return this.x * vec3f.x + this.y * vec3f.y + this.z * vec3f.z;
    }

    public Vec3f cross(Vec3f vec3f) {
        return new Vec3f().cross(this, vec3f);
    }

    public Vec3f cross(Vec3f vec3f, Vec3f vec3f2) {
        this.x = vec3f.y * vec3f2.z - vec3f.z * vec3f2.y;
        this.y = vec3f.z * vec3f2.x - vec3f.x * vec3f2.z;
        this.z = vec3f.x * vec3f2.y - vec3f.y * vec3f2.x;
        return this;
    }

    public float cosAngle(Vec3f vec3f) {
        return this.dot(vec3f) / (this.length() * vec3f.length());
    }

    public float angle(Vec3f vec3f) {
        return (float)Math.acos(this.cosAngle(vec3f));
    }

    public boolean isEqual(Vec3f vec3f, float f) {
        if (this == vec3f) {
            return true;
        }
        return FloatUtil.isEqual(this.x, vec3f.x, f) && FloatUtil.isEqual(this.y, vec3f.y, f) && FloatUtil.isEqual(this.z, vec3f.z, f);
    }

    public boolean isEqual(Vec3f vec3f) {
        return this.isEqual(vec3f, 1.1920929E-7f);
    }

    public boolean equals(Object object) {
        if (object instanceof Vec3f) {
            return this.isEqual((Vec3f)object, 1.1920929E-7f);
        }
        return false;
    }

    public String toString() {
        return this.x + " / " + this.y + " / " + this.z;
    }
}

