/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValueSyntax;

class Dimension {
    CSSValueSyntax.Category category;
    int exponent = 0;
    private Dimension prevDimension = null;
    private Dimension nextDimension = null;
    transient boolean lengthProcessed;
    transient boolean percentageProcessed;

    Dimension() {
    }

    public Dimension getFirst() {
        Dimension dimension = this;
        Dimension dimension2 = this.prevDimension;
        while (dimension2 != null) {
            dimension = dimension2;
            dimension2 = dimension2.prevDimension;
        }
        return dimension;
    }

    public Dimension getNext() {
        return this.nextDimension;
    }

    public boolean isLengthProcessed() {
        return this.lengthProcessed;
    }

    public boolean isPercentageProcessed() {
        return this.percentageProcessed;
    }

    public Dimension incrExponent() {
        ++this.exponent;
        if (this.exponent == 0) {
            return this.remove();
        }
        return this.getFirst();
    }

    public Dimension decrExponent() {
        --this.exponent;
        if (this.exponent == 0) {
            return this.remove();
        }
        return this.getFirst();
    }

    public boolean sum(Dimension dimension) {
        Dimension dimension2 = this;
        do {
            if (!dimension2.sumDimension(dimension)) {
                return false;
            }
            dimension2 = dimension2.getNext();
            dimension = dimension.getNext();
            if (dimension2 != null) continue;
            return dimension == null;
        } while (dimension != null);
        return false;
    }

    public boolean sumDimension(Dimension dimension) {
        if (this.category == dimension.category) {
            if (this.category == CSSValueSyntax.Category.lengthPercentage) {
                this.lengthProcessed = this.lengthProcessed || dimension.lengthProcessed;
                this.percentageProcessed = this.percentageProcessed || dimension.percentageProcessed;
            }
            return true;
        }
        switch (this.category) {
            case length: {
                if (dimension.category == CSSValueSyntax.Category.lengthPercentage) {
                    this.category = CSSValueSyntax.Category.lengthPercentage;
                    this.percentageProcessed = this.percentageProcessed || dimension.percentageProcessed;
                    break;
                }
                if (dimension.category == CSSValueSyntax.Category.percentage) {
                    this.category = CSSValueSyntax.Category.lengthPercentage;
                    this.percentageProcessed = true;
                    break;
                }
                return false;
            }
            case percentage: {
                if (dimension.category == CSSValueSyntax.Category.lengthPercentage) {
                    this.category = CSSValueSyntax.Category.lengthPercentage;
                    this.lengthProcessed = this.lengthProcessed || dimension.lengthProcessed;
                    break;
                }
                if (dimension.category == CSSValueSyntax.Category.length) {
                    this.category = CSSValueSyntax.Category.lengthPercentage;
                    this.lengthProcessed = true;
                    break;
                }
                return false;
            }
            case lengthPercentage: {
                if (dimension.category == CSSValueSyntax.Category.length) {
                    this.lengthProcessed = true;
                    break;
                }
                if (dimension.category == CSSValueSyntax.Category.percentage) {
                    this.percentageProcessed = true;
                    break;
                }
                return false;
            }
            case number: {
                if (dimension.category == CSSValueSyntax.Category.integer) break;
                return false;
            }
            case integer: {
                if (dimension.category == CSSValueSyntax.Category.number) {
                    this.category = CSSValueSyntax.Category.number;
                    break;
                }
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public Dimension multiply(Dimension dimension) {
        block0: do {
            Dimension dimension2 = this;
            do {
                if (!dimension2.multiplyDimension(dimension)) continue;
                if (this.exponent != 0) continue block0;
                return this.remove();
            } while ((dimension2 = dimension2.getNext()) != null);
            this.append(dimension);
        } while ((dimension = dimension.getNext()) != null);
        return this;
    }

    private boolean multiplyDimension(Dimension dimension) {
        if (this.category == dimension.category) {
            this.exponent += dimension.exponent;
            return true;
        }
        Dimension dimension2 = this;
        switch (dimension2.category) {
            case number: 
            case integer: {
                this.category = dimension.category;
                this.exponent = dimension.exponent;
                break;
            }
            case length: {
                if (dimension.category == CSSValueSyntax.Category.lengthPercentage || dimension.category == CSSValueSyntax.Category.percentage) {
                    dimension2.category = CSSValueSyntax.Category.lengthPercentage;
                    dimension2.exponent += dimension.exponent;
                    break;
                }
                return false;
            }
            case percentage: {
                if (dimension.category == CSSValueSyntax.Category.lengthPercentage || dimension.category == CSSValueSyntax.Category.length) {
                    this.category = CSSValueSyntax.Category.lengthPercentage;
                    this.exponent += dimension.exponent;
                    break;
                }
                return false;
            }
            case lengthPercentage: {
                if (dimension.category == CSSValueSyntax.Category.length) {
                    this.exponent += dimension.exponent;
                    this.lengthProcessed = true;
                    break;
                }
                if (dimension.category == CSSValueSyntax.Category.percentage) {
                    this.exponent += dimension.exponent;
                    this.percentageProcessed = true;
                    break;
                }
                return false;
            }
            case frequency: {
                if (dimension.category == CSSValueSyntax.Category.time) {
                    this.exponent -= dimension.exponent;
                    break;
                }
                return false;
            }
            case time: {
                if (dimension.category == CSSValueSyntax.Category.frequency) {
                    this.exponent -= dimension.exponent;
                    break;
                }
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public Dimension divide(Dimension dimension) {
        block0: do {
            Dimension dimension2 = this;
            do {
                if (!dimension2.divideDimension(dimension)) continue;
                if (this.exponent != 0) continue block0;
                return this.remove();
            } while ((dimension2 = dimension2.getNext()) != null);
            this.append(dimension);
        } while ((dimension = dimension.getNext()) != null);
        return this;
    }

    private boolean divideDimension(Dimension dimension) {
        if (this.category == dimension.category) {
            this.exponent -= dimension.exponent;
            return true;
        }
        switch (this.category) {
            case number: 
            case integer: {
                this.category = dimension.category;
                this.exponent = -dimension.exponent;
                if (this.exponent != -1) break;
                if (this.category == CSSValueSyntax.Category.time) {
                    this.category = CSSValueSyntax.Category.frequency;
                    this.exponent = 1;
                    break;
                }
                if (this.category != CSSValueSyntax.Category.frequency) break;
                this.category = CSSValueSyntax.Category.time;
                this.exponent = 1;
                break;
            }
            case length: {
                if (dimension.category == CSSValueSyntax.Category.lengthPercentage || dimension.category == CSSValueSyntax.Category.percentage) {
                    this.category = CSSValueSyntax.Category.lengthPercentage;
                    this.exponent -= dimension.exponent;
                    break;
                }
                return false;
            }
            case percentage: {
                if (dimension.category == CSSValueSyntax.Category.lengthPercentage || dimension.category == CSSValueSyntax.Category.length) {
                    this.category = CSSValueSyntax.Category.lengthPercentage;
                    this.exponent -= dimension.exponent;
                    break;
                }
                return false;
            }
            case lengthPercentage: {
                if (dimension.category == CSSValueSyntax.Category.length) {
                    this.exponent -= dimension.exponent;
                    this.lengthProcessed = true;
                    break;
                }
                if (dimension.category == CSSValueSyntax.Category.percentage) {
                    this.exponent -= dimension.exponent;
                    this.percentageProcessed = true;
                    break;
                }
                return false;
            }
            case frequency: {
                if (dimension.category == CSSValueSyntax.Category.time) {
                    this.exponent += dimension.exponent;
                    break;
                }
                return false;
            }
            case time: {
                if (dimension.category == CSSValueSyntax.Category.frequency) {
                    this.exponent += dimension.exponent;
                    break;
                }
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean sumUnit(short s) {
        switch (this.category) {
            case number: 
            case integer: {
                return s == 0;
            }
            case length: {
                if (CSSUnit.isLengthUnitType(s)) {
                    this.lengthProcessed = true;
                    break;
                }
                if (s == 2) {
                    this.category = CSSValueSyntax.Category.lengthPercentage;
                    this.percentageProcessed = true;
                    break;
                }
                return false;
            }
            case percentage: {
                if (s == 2) {
                    this.percentageProcessed = true;
                    break;
                }
                if (CSSUnit.isLengthUnitType(s)) {
                    this.category = CSSValueSyntax.Category.lengthPercentage;
                    this.lengthProcessed = true;
                    break;
                }
                return false;
            }
            case lengthPercentage: {
                if (s == 2) {
                    this.percentageProcessed = true;
                    return true;
                }
                if (CSSUnit.isLengthUnitType(s)) {
                    this.lengthProcessed = true;
                    return true;
                }
            }
            case angle: {
                return CSSUnit.isAngleUnitType(s);
            }
            case time: {
                return CSSUnit.isTimeUnitType(s);
            }
            case frequency: {
                return s == 100 || s == 101;
            }
            case flex: {
                return s == 70;
            }
            case resolution: {
                return CSSUnit.isResolutionUnitType(s);
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public Dimension multiplyByUnit(short s) {
        Dimension dimension;
        block40: {
            if (s == 0) {
                return this;
            }
            dimension = this;
            if (CSSUnit.isLengthUnitType(s)) {
                while (true) {
                    if (this.category == CSSValueSyntax.Category.length) {
                        dimension = dimension.incrExponent();
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.percentage) {
                        dimension.category = CSSValueSyntax.Category.lengthPercentage;
                        dimension = dimension.incrExponent();
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.lengthPercentage) {
                        dimension = dimension.incrExponent();
                        this.lengthProcessed = true;
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.number || dimension.category == CSSValueSyntax.Category.integer) {
                        dimension.exponent = 1;
                        dimension.category = CSSValueSyntax.Category.length;
                        break block40;
                    }
                    Dimension dimension2 = dimension.getNext();
                    if (dimension2 == null) {
                        Dimension dimension3 = new Dimension();
                        dimension3.category = CSSValueSyntax.Category.length;
                        dimension3.exponent = 1;
                        dimension.append(dimension3);
                        break block40;
                    }
                    dimension = dimension2;
                }
            }
            if (s == 2) {
                while (true) {
                    switch (dimension.category) {
                        case lengthPercentage: {
                            this.percentageProcessed = true;
                        }
                        case percentage: {
                            dimension = dimension.incrExponent();
                            break;
                        }
                    }
                    if (dimension.category == CSSValueSyntax.Category.length) {
                        dimension.category = CSSValueSyntax.Category.lengthPercentage;
                        dimension = dimension.incrExponent();
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.number || dimension.category == CSSValueSyntax.Category.integer) {
                        dimension.exponent = 1;
                        dimension.category = CSSValueSyntax.Category.percentage;
                        break block40;
                    }
                    Dimension dimension4 = dimension.getNext();
                    if (dimension4 == null) {
                        Dimension dimension5 = new Dimension();
                        dimension5.category = CSSValueSyntax.Category.percentage;
                        dimension5.exponent = 1;
                        dimension.append(dimension5);
                        break block40;
                    }
                    dimension = dimension4;
                }
            }
            if (CSSUnit.isAngleUnitType(s)) {
                while (true) {
                    if (dimension.category == CSSValueSyntax.Category.angle) {
                        dimension = dimension.incrExponent();
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.number || dimension.category == CSSValueSyntax.Category.integer) {
                        dimension.exponent = 1;
                        dimension.category = CSSValueSyntax.Category.angle;
                        break block40;
                    }
                    Dimension dimension6 = dimension.getNext();
                    if (dimension6 == null) {
                        Dimension dimension7 = new Dimension();
                        dimension7.category = CSSValueSyntax.Category.angle;
                        dimension7.exponent = 1;
                        dimension.append(dimension7);
                        break block40;
                    }
                    dimension = dimension6;
                }
            }
            if (CSSUnit.isTimeUnitType(s)) {
                while (true) {
                    if (dimension.category == CSSValueSyntax.Category.time) {
                        dimension = dimension.incrExponent();
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.number || dimension.category == CSSValueSyntax.Category.integer) {
                        dimension.exponent = 1;
                        dimension.category = CSSValueSyntax.Category.time;
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.frequency) {
                        dimension = dimension.decrExponent();
                        break block40;
                    }
                    Dimension dimension8 = dimension.getNext();
                    if (dimension8 == null) {
                        Dimension dimension9 = new Dimension();
                        dimension9.category = CSSValueSyntax.Category.time;
                        dimension9.exponent = 1;
                        dimension.append(dimension9);
                        break block40;
                    }
                    dimension = dimension8;
                }
            }
            if (s == 100 || s == 101) {
                while (true) {
                    if (dimension.category == CSSValueSyntax.Category.frequency) {
                        dimension = dimension.incrExponent();
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.number || dimension.category == CSSValueSyntax.Category.integer) {
                        dimension.exponent = 1;
                        dimension.category = CSSValueSyntax.Category.frequency;
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.time) {
                        dimension = dimension.decrExponent();
                        break block40;
                    }
                    Dimension dimension10 = dimension.getNext();
                    if (dimension10 == null) {
                        Dimension dimension11 = new Dimension();
                        dimension11.category = CSSValueSyntax.Category.frequency;
                        dimension11.exponent = 1;
                        dimension.append(dimension11);
                        break block40;
                    }
                    dimension = dimension10;
                }
            }
            if (CSSUnit.isResolutionUnitType(s)) {
                while (true) {
                    if (dimension.category == CSSValueSyntax.Category.resolution) {
                        dimension = dimension.incrExponent();
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.number || dimension.category == CSSValueSyntax.Category.integer) {
                        dimension.exponent = 1;
                        dimension.category = CSSValueSyntax.Category.resolution;
                        break block40;
                    }
                    Dimension dimension12 = dimension.getNext();
                    if (dimension12 == null) {
                        Dimension dimension13 = new Dimension();
                        dimension13.category = CSSValueSyntax.Category.resolution;
                        dimension13.exponent = 1;
                        dimension.append(dimension13);
                        break block40;
                    }
                    dimension = dimension12;
                }
            }
            throw new IllegalStateException("Do not know how to handle unit " + s);
        }
        if (this.exponent == 0) {
            return this.remove();
        }
        return dimension;
    }

    public Dimension divideByUnit(short s) {
        Dimension dimension;
        block40: {
            if (s == 0) {
                return this;
            }
            dimension = this;
            if (CSSUnit.isLengthUnitType(s)) {
                while (true) {
                    if (dimension.category == CSSValueSyntax.Category.length) {
                        dimension = dimension.decrExponent();
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.percentage) {
                        dimension.category = CSSValueSyntax.Category.lengthPercentage;
                        dimension = dimension.decrExponent();
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.lengthPercentage) {
                        dimension = dimension.decrExponent();
                        this.lengthProcessed = true;
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.number || dimension.category == CSSValueSyntax.Category.integer) {
                        dimension.exponent = -1;
                        dimension.category = CSSValueSyntax.Category.length;
                        break block40;
                    }
                    Dimension dimension2 = dimension.getNext();
                    if (dimension2 == null) {
                        Dimension dimension3 = new Dimension();
                        dimension3.category = CSSValueSyntax.Category.length;
                        dimension3.exponent = -1;
                        dimension.append(dimension3);
                        break block40;
                    }
                    dimension = dimension2;
                }
            }
            if (s == 2) {
                while (true) {
                    switch (dimension.category) {
                        case lengthPercentage: {
                            this.percentageProcessed = true;
                        }
                        case percentage: {
                            dimension = dimension.decrExponent();
                            break;
                        }
                    }
                    if (dimension.category == CSSValueSyntax.Category.length) {
                        dimension.category = CSSValueSyntax.Category.lengthPercentage;
                        dimension = dimension.decrExponent();
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.number || dimension.category == CSSValueSyntax.Category.integer) {
                        dimension.exponent = -1;
                        dimension.category = CSSValueSyntax.Category.percentage;
                        break block40;
                    }
                    Dimension dimension4 = dimension.getNext();
                    if (dimension4 == null) {
                        Dimension dimension5 = new Dimension();
                        dimension5.category = CSSValueSyntax.Category.percentage;
                        dimension5.exponent = -1;
                        dimension.append(dimension5);
                        break block40;
                    }
                    dimension = dimension4;
                }
            }
            if (CSSUnit.isAngleUnitType(s)) {
                while (true) {
                    if (dimension.category == CSSValueSyntax.Category.angle) {
                        dimension = dimension.decrExponent();
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.number || dimension.category == CSSValueSyntax.Category.integer) {
                        dimension.exponent = -1;
                        dimension.category = CSSValueSyntax.Category.angle;
                        break block40;
                    }
                    Dimension dimension6 = dimension.getNext();
                    if (dimension6 == null) {
                        Dimension dimension7 = new Dimension();
                        dimension7.category = CSSValueSyntax.Category.angle;
                        dimension7.exponent = -1;
                        dimension.append(dimension7);
                        break block40;
                    }
                    dimension = dimension6;
                }
            }
            if (CSSUnit.isTimeUnitType(s)) {
                while (true) {
                    if (dimension.category == CSSValueSyntax.Category.time) {
                        dimension = dimension.decrExponent();
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.number || dimension.category == CSSValueSyntax.Category.integer) {
                        dimension.exponent = 1;
                        dimension.category = CSSValueSyntax.Category.frequency;
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.frequency) {
                        dimension = dimension.incrExponent();
                        break block40;
                    }
                    Dimension dimension8 = dimension.getNext();
                    if (dimension8 == null) {
                        Dimension dimension9 = new Dimension();
                        dimension9.category = CSSValueSyntax.Category.frequency;
                        dimension9.exponent = 1;
                        dimension.append(dimension9);
                        break block40;
                    }
                    dimension = dimension8;
                }
            }
            if (s == 100 || s == 101) {
                while (true) {
                    if (dimension.category == CSSValueSyntax.Category.frequency) {
                        dimension = dimension.decrExponent();
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.number || dimension.category == CSSValueSyntax.Category.integer) {
                        dimension.exponent = 1;
                        dimension.category = CSSValueSyntax.Category.time;
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.time) {
                        dimension = dimension.incrExponent();
                        break block40;
                    }
                    Dimension dimension10 = dimension.getNext();
                    if (dimension10 == null) {
                        Dimension dimension11 = new Dimension();
                        dimension11.category = CSSValueSyntax.Category.time;
                        dimension11.exponent = 1;
                        dimension.append(dimension11);
                        break block40;
                    }
                    dimension = dimension10;
                }
            }
            if (CSSUnit.isResolutionUnitType(s)) {
                while (true) {
                    if (dimension.category == CSSValueSyntax.Category.resolution) {
                        dimension = dimension.decrExponent();
                        break block40;
                    }
                    if (dimension.category == CSSValueSyntax.Category.number || dimension.category == CSSValueSyntax.Category.integer) {
                        dimension.exponent = -1;
                        dimension.category = CSSValueSyntax.Category.resolution;
                        break block40;
                    }
                    Dimension dimension12 = dimension.getNext();
                    if (dimension12 == null) {
                        Dimension dimension13 = new Dimension();
                        dimension13.category = CSSValueSyntax.Category.resolution;
                        dimension13.exponent = -1;
                        dimension.append(dimension13);
                        break block40;
                    }
                    dimension = dimension12;
                }
            }
            throw new IllegalStateException("Do not know how to handle unit " + s);
        }
        if (this.exponent == 0) {
            return this.remove();
        }
        return dimension;
    }

    public Dimension remove() {
        if (this.nextDimension == null) {
            if (this.prevDimension == null) {
                this.category = CSSValueSyntax.Category.number;
                this.exponent = 0;
                return this;
            }
            return this.prevDimension.getFirst();
        }
        this.nextDimension.prevDimension = this.prevDimension;
        if (this.prevDimension != null) {
            this.prevDimension.nextDimension = this.nextDimension;
            return this.prevDimension.getFirst();
        }
        return this.nextDimension;
    }

    public void append(Dimension dimension) {
        if (this.nextDimension != null) {
            this.nextDimension.prevDimension = dimension;
        }
        dimension.nextDimension = this.nextDimension;
        this.nextDimension = dimension;
        dimension.prevDimension = this;
    }

    public boolean isCSS() {
        return this.nextDimension == null && (this.exponent == 1 || this.exponent == 0);
    }

    public CSSValueSyntax.Match matches(CSSValueSyntax cSSValueSyntax) {
        CSSValueSyntax.Category category;
        if (this.nextDimension == null && (this.category == (category = cSSValueSyntax.getCategory()) || this.category == CSSValueSyntax.Category.length && category == CSSValueSyntax.Category.lengthPercentage || this.category == CSSValueSyntax.Category.percentage && category == CSSValueSyntax.Category.lengthPercentage || this.category == CSSValueSyntax.Category.integer && category == CSSValueSyntax.Category.number || this.category == CSSValueSyntax.Category.number && category == CSSValueSyntax.Category.integer)) {
            return CSSValueSyntax.Match.TRUE;
        }
        return CSSValueSyntax.Match.FALSE;
    }

    public String toString() {
        return this.category.name() + '^' + Integer.toString(this.exponent);
    }
}

