/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.AnimatableGenericSVGBridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.bridge.GVTBuilder;
import io.sf.carte.echosvg.bridge.MarkerBridge;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.bridge.UnitProcessor;
import io.sf.carte.echosvg.bridge.ViewBox;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.ext.awt.image.renderable.ClipRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.ClipRable8Bit;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.gvt.CompositeGraphicsNode;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.gvt.Marker;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.Element;

public class SVGMarkerElementBridge
extends AnimatableGenericSVGBridge
implements MarkerBridge,
ErrorConstants {
    protected SVGMarkerElementBridge() {
    }

    @Override
    public String getLocalName() {
        return "marker";
    }

    @Override
    public Marker createMarker(BridgeContext bridgeContext, Element element, Element element2) {
        Filter filter;
        Object object;
        AffineTransform affineTransform;
        double d;
        Object object2;
        Object object3;
        GVTBuilder gVTBuilder = bridgeContext.getGVTBuilder();
        CompositeGraphicsNode compositeGraphicsNode = new CompositeGraphicsNode();
        boolean bl = false;
        for (object3 = element.getFirstChild(); object3 != null; object3 = object3.getNextSibling()) {
            GraphicsNode graphicsNode;
            if (object3.getNodeType() != 1 || (graphicsNode = gVTBuilder.build(bridgeContext, (Element)(object2 = (Element)object3))) == null) continue;
            bl = true;
            compositeGraphicsNode.getChildren().add(graphicsNode);
        }
        if (!bl) {
            return null;
        }
        object2 = UnitProcessor.createContext(bridgeContext, element2);
        float f = 3.0f;
        object3 = element.getAttributeNS(null, "markerWidth");
        if (((String)object3).length() != 0) {
            f = UnitProcessor.svgHorizontalLengthToUserSpace((String)object3, "markerWidth", object2);
        }
        if (f == 0.0f) {
            return null;
        }
        float f2 = 3.0f;
        object3 = element.getAttributeNS(null, "markerHeight");
        if (((String)object3).length() != 0) {
            f2 = UnitProcessor.svgVerticalLengthToUserSpace((String)object3, "markerHeight", object2);
        }
        if (f2 == 0.0f) {
            return null;
        }
        object3 = element.getAttributeNS(null, "orient");
        if (((String)object3).length() == 0) {
            d = 0.0;
        } else if ("auto".equals(object3)) {
            d = Double.NaN;
        } else {
            try {
                d = SVGUtilities.convertSVGNumber((String)object3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"orient", object3});
            }
        }
        Value value = CSSUtilities.getComputedStyle(element2, 56);
        float f3 = value.getFloatValue();
        object3 = element.getAttributeNS(null, "markerUnits");
        int n = ((String)object3).length() == 0 ? 3 : (int)SVGUtilities.parseMarkerCoordinateSystem(element, "markerUnits", (String)object3, bridgeContext);
        if (n == 3) {
            affineTransform = new AffineTransform();
            affineTransform.scale(f3, f3);
        } else {
            affineTransform = new AffineTransform();
        }
        AffineTransform affineTransform2 = ViewBox.getPreserveAspectRatioTransform(element, f, f2, bridgeContext);
        if (affineTransform2 == null) {
            return null;
        }
        affineTransform.concatenate(affineTransform2);
        compositeGraphicsNode.setTransform(affineTransform);
        if (CSSUtilities.convertOverflow(element)) {
            float[] fArray = CSSUtilities.convertClip(element);
            Rectangle2D.Float float_ = fArray == null ? new Rectangle2D.Float(0.0f, 0.0f, f3 * f, f3 * f2) : new Rectangle2D.Float(fArray[3], fArray[0], f3 * f - fArray[1] - fArray[3], f3 * f2 - fArray[2] - fArray[0]);
            object = new CompositeGraphicsNode();
            object.getChildren().add(compositeGraphicsNode);
            filter = object.getGraphicsNodeRable(true);
            object.setClip((ClipRable)new ClipRable8Bit(filter, (Shape)float_));
            compositeGraphicsNode = object;
        }
        float f4 = 0.0f;
        object3 = element.getAttributeNS(null, "refX");
        if (((String)object3).length() != 0) {
            f4 = UnitProcessor.svgHorizontalCoordinateToUserSpace((String)object3, "refX", object2);
        }
        float f5 = 0.0f;
        object3 = element.getAttributeNS(null, "refY");
        if (((String)object3).length() != 0) {
            f5 = UnitProcessor.svgVerticalCoordinateToUserSpace((String)object3, "refY", object2);
        }
        object = new float[]{f4, f5};
        affineTransform.transform((float[])object, 0, (float[])object, 0, 1);
        filter = new Marker((GraphicsNode)compositeGraphicsNode, (Point2D)new Point2D.Float((float)object[0], (float)object[1]), d);
        return filter;
    }
}

