/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSEngineUserAgent;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.IdentifierManager;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.StringValue;
import io.sf.carte.echosvg.css.engine.value.URIValue;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import java.util.Iterator;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class SrcManager
extends IdentifierManager {
    protected static final StringMap values = new StringMap();

    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public boolean isAnimatableProperty() {
        return false;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 38;
    }

    @Override
    public String getPropertyName() {
        return "src";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NONE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: {
                return this.createLexicalValue(lexicalUnit);
            }
            default: {
                throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
            }
            case IDENT: 
            case STRING: 
            case URI: 
        }
        ListValue listValue = new ListValue();
        LexicalUnit lexicalUnit2 = lexicalUnit;
        do {
            switch (lexicalUnit2.getLexicalUnitType()) {
                case STRING: {
                    listValue.append(new StringValue(lexicalUnit2.getStringValue()));
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                    break;
                }
                case URI: {
                    String string = SrcManager.resolveURI(cSSEngine.getCSSBaseURI(), lexicalUnit2.getStringValue());
                    listValue.append(new URIValue(lexicalUnit2.getStringValue(), string));
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                    if (lexicalUnit2 == null) break;
                    switch (lexicalUnit2.getLexicalUnitType()) {
                        case FUNCTION: {
                            if (!lexicalUnit2.getFunctionName().equalsIgnoreCase("format")) break;
                            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                            break;
                        }
                        case VAR: {
                            return this.createLexicalValue(lexicalUnit);
                        }
                    }
                    break;
                }
                case IDENT: {
                    StringBuilder stringBuilder = new StringBuilder(lexicalUnit2.getStringValue());
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                    if (lexicalUnit2 == null) break;
                    if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                        do {
                            stringBuilder.append(' ');
                            stringBuilder.append(lexicalUnit2.getStringValue());
                        } while ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null && lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT);
                        listValue.append(new StringValue(stringBuilder.toString()));
                        break;
                    }
                    if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                        return this.createLexicalValue(lexicalUnit);
                    }
                    String string = stringBuilder.toString();
                    String string2 = string.toLowerCase(Locale.ROOT).intern();
                    Value value = (Value)values.get(string2);
                    listValue.append(value != null ? value : new StringValue(string));
                    break;
                }
                case VAR: {
                    return this.createLexicalValue(lexicalUnit);
                }
            }
            if (lexicalUnit2 == null) {
                return listValue;
            }
            if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) continue;
            if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                return this.createLexicalValue(lexicalUnit);
            }
            throw this.createInvalidLexicalUnitDOMException(lexicalUnit2.getLexicalUnitType());
        } while ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null);
        throw this.createMalformedLexicalUnitDOMException();
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (styleMap.isAttrTainted(n) && value.getCssValueType() == CSSValue.CssType.LIST) {
            Iterator iterator = ((ListValue)value).iterator();
            while (iterator.hasNext()) {
                Value value2 = (Value)iterator.next();
                if (value2.getPrimitiveType() != CSSValue.Type.URI) continue;
                CSSEngineUserAgent cSSEngineUserAgent = cSSEngine.getCSSEngineUserAgent();
                if (cSSEngineUserAgent != null) {
                    cSSEngineUserAgent.displayMessage("attr()-tainted value: " + value.getCssText());
                }
                return null;
            }
        }
        return super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value);
    }

    @Override
    public StringMap getIdentifiers() {
        return values;
    }

    static {
        values.put("none", ValueConstants.NONE_VALUE);
    }
}

