#############################################################################
##
#D  $2.A_6$ as $2 \times 2$ matrices over the quaternions over $\Q( r_3 )$
##
local result, r3, gens, e, i, alpha;
result:= rec();
result.comment:=
"2.A6 as 2x2 matrices over the quaternions over Q( r3 ).\n\
";
r3:= ER(3);
gens:= GeneratorsOfAlgebra( QuaternionAlgebra( Field( r3 ) ) );;
e:= gens[1];
i:= gens[2];
alpha:= r3/6 * gens[3];
result.generators:= [
[ [ 2*(e-i)*alpha,             -e/2 - alpha ],
  [   e/2 - alpha, -i*(e/2-alpha) - 2*alpha ] ],
[ [           0*e,                       -e ],
  [             i,                      0*e ] ] ];
return result;

