/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.freeplane.core.ui.components.JComboBoxFactory;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.FilterComposerDialog;
import org.freeplane.features.filter.FilterConditionEditor;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.DefaultConditionRenderer;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.mindmapmode.DefaultStyleRenderer;

class ConditionalStyleTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private MapStyleModel styleModel;
    private DefaultConditionRenderer conditionRenderer;
    private FilterComposerDialog filterComposerDialog;
    private FilterConditionEditor.Variant filterComposerVariant;
    private ConditionalStyleModel conditionalStyleModel;

    ConditionalStyleTable(MapStyleModel styleModel, ConditionalStyleModel conditionalStyleModel, TableModel tableModel, FilterConditionEditor.Variant filterComposerVariant) {
        super(tableModel);
        this.styleModel = styleModel;
        this.conditionalStyleModel = conditionalStyleModel;
        this.filterComposerVariant = filterComposerVariant;
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        TableColumnModel columnModel = this.getColumnModel();
        this.setAutoResizeMode(0);
        this.setRowHeight(UITools.getDefaultLabelFont().getSize() * 5 / 4);
        this.conditionRenderer = ConditionalStyleTable.createConditionRenderer();
        columnModel.getColumn(1).setCellRenderer((TableCellRenderer)this.conditionRenderer);
        columnModel.getColumn(1).setCellEditor(new ConditionEditor());
        final JComboBox styleBox = JComboBoxFactory.create();
        styleBox.setEditable(false);
        columnModel.getColumn(2).setCellEditor(new DefaultCellEditor(styleBox){
            private static final long serialVersionUID = 1L;
            {
                super(arg0);
                this.setClickCountToStart(2);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                List styles = ConditionalStyleTable.this.styleModel.getNodeStyles();
                DefaultComboBoxModel<Object> boxContent = new DefaultComboBoxModel<Object>(styles.toArray());
                styleBox.setModel(boxContent);
                return super.getTableCellEditorComponent(table, value, isSelected, row, column);
            }
        });
        columnModel.getColumn(1).setPreferredWidth(300);
        columnModel.getColumn(2).setPreferredWidth(180);
        columnModel.getColumn(2).setCellRenderer(new DefaultStyleRenderer());
    }

    static DefaultConditionRenderer createConditionRenderer() {
        return new DefaultConditionRenderer(TextUtils.getText((String)"always"), true);
    }

    public MapStyleModel getStyles() {
        return this.styleModel;
    }

    FilterComposerDialog filterComposer() {
        if (this.filterComposerDialog == null) {
            this.filterComposerDialog = this.createFilterComposer();
        }
        return this.filterComposerDialog;
    }

    private FilterComposerDialog createFilterComposer() {
        FilterComposerDialog filterComposerDialog = new FilterComposerDialog(this.filterComposerVariant, this.conditionalStyleModel);
        filterComposerDialog.addCondition(null);
        filterComposerDialog.setConditionRenderer((ListCellRenderer)ConditionalStyleTable.createConditionRenderer());
        for (int i = 0; i < this.getRowCount(); ++i) {
            ASelectableCondition condition = (ASelectableCondition)this.getValueAt(i, 1);
            filterComposerDialog.addCondition(condition);
        }
        return filterComposerDialog;
    }

    private class ConditionEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JButton btn;
        private Object cellEditorValue;

        public ConditionEditor() {
            this.btn = new JButton(){
                {
                    this.setUI(BasicButtonUI.createUI(this));
                }

                @Override
                public Color getBackground() {
                    return ConditionalStyleTable.this.getSelectionBackground();
                }
            };
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, final Object value, boolean isSelected, int row, int column) {
            this.btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConditionEditor.this.cellEditorValue = ConditionalStyleTable.this.filterComposer().editCondition((ASelectableCondition)value);
                    ConditionEditor.this.btn.removeActionListener(this);
                    ConditionEditor.this.fireEditingStopped();
                }
            });
            return this.btn;
        }

        @Override
        public Object getCellEditorValue() {
            return this.cellEditorValue;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= 2;
            }
            return true;
        }
    }
}

