/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.freeplane.api.Script;
import org.freeplane.core.util.ClassLoaderFactory;
import org.freeplane.plugin.script.GenericScript;
import org.freeplane.plugin.script.ScriptResources;
import org.freeplane.plugin.script.ScriptingSecurityManager;

public final class ScriptClassLoader
extends GroovyClassLoader {
    private static final Permission ALL_PERMISSION = new AllPermission();
    private ScriptingSecurityManager securityManager = null;

    public static ScriptClassLoader createClassLoader() {
        List<String> classpath = ScriptResources.getClasspath();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : classpath) {
            urls.add(ScriptClassLoader.pathToUrl(path));
        }
        urls.addAll(ClassLoaderFactory.jarsInExtDir());
        ScriptClassLoader classLoader = new ScriptClassLoader(urls.toArray(new URL[urls.size()]), GenericScript.class.getClassLoader());
        return classLoader;
    }

    static URL pathToUrl(String path) {
        File file = new File(path);
        return ScriptClassLoader.pathToUrl(file);
    }

    static URL pathToUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ScriptClassLoader(URL[] urls, ClassLoader parent) {
        super(parent);
        for (URL url : urls) {
            this.addURL(url);
        }
    }

    public URL getResource(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return ScriptClassLoader.this.superGetResource(name);
            }
        });
    }

    private URL superGetResource(String name) {
        if (name.startsWith(Script.class.getPackage().getName().replace('.', '/') + '/')) {
            return Script.class.getClassLoader().getResource(name);
        }
        return super.getResource(name);
    }

    public Enumeration<URL> getResources(final String name) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){

                @Override
                public Enumeration<URL> run() throws IOException {
                    return ScriptClassLoader.this.superGetResources(name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    private Enumeration<URL> superGetResources(String name) throws IOException {
        return super.getResources(name);
    }

    protected Class<?> loadClass(final String name, final boolean resolve) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws ClassNotFoundException {
                    return ScriptClassLoader.this.superLoadClass(name, resolve);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (ClassNotFoundException)e.getCause();
        }
    }

    private Class<?> superLoadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    public void setSecurityManager(ScriptingSecurityManager securityManager) {
        if (System.getSecurityManager() != null) {
            AccessController.checkPermission(ALL_PERMISSION);
        }
        this.securityManager = securityManager;
    }

    public boolean implies(Permission permission) {
        return this.securityManager != null && this.securityManager.implies(permission);
    }
}

