/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util;

import java.io.PrintStream;

public class Printer {
    private PrintStream out;
    private String indent = "";
    private boolean newLine = true;

    public Printer() {
        this(System.out);
    }

    public Printer(PrintStream out) {
        this.out = out;
    }

    public void beginSection() {
        this.indent = String.valueOf(this.indent) + "  ";
    }

    public void beginSection(String title) {
        this.println(title);
        this.indent = String.valueOf(this.indent) + "  ";
    }

    public void endSection() {
        this.indent = this.indent.substring(2);
    }

    public void print(String str) {
        if (this.newLine) {
            this.out.print(this.indent);
        }
        this.out.print(str);
        this.newLine = false;
    }

    public void println(String str) {
        if (this.newLine) {
            this.out.print(this.indent);
        }
        this.out.println(str);
        this.newLine = true;
    }

    public void println() {
        if (this.newLine) {
            this.out.print(this.indent);
        }
        this.out.println();
        this.newLine = true;
    }
}

