/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.properties;

import net.infonode.docking.properties.DockingWindowDropFilterProperties;
import net.infonode.docking.properties.WindowTabProperties;
import net.infonode.docking.title.DockingWindowTitleProvider;
import net.infonode.docking.title.DockingWindowTitleProviderProperty;
import net.infonode.properties.base.PropertyGroup;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapContainer;
import net.infonode.properties.propertymap.PropertyMapFactory;
import net.infonode.properties.propertymap.PropertyMapGroup;
import net.infonode.properties.propertymap.PropertyMapProperty;
import net.infonode.properties.propertymap.PropertyMapValueHandler;
import net.infonode.properties.types.BooleanProperty;

public class DockingWindowProperties
extends PropertyMapContainer {
    public static final PropertyMapGroup PROPERTIES = new PropertyMapGroup("Docking Window Properties", "");
    public static final PropertyMapProperty TAB_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Tab Properties", "Property values for the window tab when the window is located in a TabWindow or a WindowBar.", WindowTabProperties.PROPERTIES);
    public static final PropertyMapProperty DROP_FILTER_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Drop Filter Properties", "Property values for drop filters.", DockingWindowDropFilterProperties.PROPERTIES);
    public static final BooleanProperty DRAG_ENABLED = new BooleanProperty((PropertyGroup)PROPERTIES, "Drag Enabled", "Enables/disables window drag by the user.", PropertyMapValueHandler.INSTANCE);
    public static final BooleanProperty UNDOCK_ENABLED = new BooleanProperty((PropertyGroup)PROPERTIES, "Undock Enabled", "Enables/disables if a window can be undocked to a floating window.", PropertyMapValueHandler.INSTANCE);
    public static final BooleanProperty UNDOCK_ON_DROP = new BooleanProperty((PropertyGroup)PROPERTIES, "Undock when Dropped", "Enables/disables window undock to floating window when a drag and drop is performed outside the root window.", PropertyMapValueHandler.INSTANCE);
    public static final BooleanProperty DOCK_ENABLED = new BooleanProperty((PropertyGroup)PROPERTIES, "Dock Enabled", "Enables/disables if a window can be docked to the root window from a floating window.", PropertyMapValueHandler.INSTANCE);
    public static final BooleanProperty MINIMIZE_ENABLED = new BooleanProperty((PropertyGroup)PROPERTIES, "Minimize Enabled", "Enables/disables window minimize by the user.", PropertyMapValueHandler.INSTANCE);
    public static final BooleanProperty CLOSE_ENABLED = new BooleanProperty((PropertyGroup)PROPERTIES, "Close Enabled", "Enables/disables window close by the user.", PropertyMapValueHandler.INSTANCE);
    public static final BooleanProperty RESTORE_ENABLED = new BooleanProperty((PropertyGroup)PROPERTIES, "Restore Enabled", "Enables/disables window restore by the user.", PropertyMapValueHandler.INSTANCE);
    public static final BooleanProperty MAXIMIZE_ENABLED = new BooleanProperty((PropertyGroup)PROPERTIES, "Maximize Enabled", "Enables/disables window maximize by the user.", PropertyMapValueHandler.INSTANCE);
    public static final DockingWindowTitleProviderProperty TITLE_PROVIDER = new DockingWindowTitleProviderProperty((PropertyGroup)PROPERTIES, "Title Provider", "Provides a title for a window.", PropertyMapValueHandler.INSTANCE);

    public DockingWindowProperties() {
        super(PropertyMapFactory.create(PROPERTIES));
    }

    public DockingWindowProperties(PropertyMap map) {
        super(map);
    }

    public DockingWindowProperties(DockingWindowProperties inheritFrom) {
        super(PropertyMapFactory.create(inheritFrom.getMap()));
    }

    public DockingWindowProperties addSuperObject(DockingWindowProperties properties) {
        this.getMap().addSuperMap(properties.getMap());
        return this;
    }

    public DockingWindowProperties removeSuperObject() {
        this.getMap().removeSuperMap();
        return this;
    }

    public DockingWindowProperties removeSuperObject(DockingWindowProperties superObject) {
        this.getMap().removeSuperMap(superObject.getMap());
        return this;
    }

    public WindowTabProperties getTabProperties() {
        return new WindowTabProperties(TAB_PROPERTIES.get(this.getMap()));
    }

    public DockingWindowDropFilterProperties getDropFilterProperties() {
        return new DockingWindowDropFilterProperties(DROP_FILTER_PROPERTIES.get(this.getMap()));
    }

    public boolean getDragEnabled() {
        return DRAG_ENABLED.get(this.getMap());
    }

    public DockingWindowProperties setDragEnabled(boolean enabled) {
        DRAG_ENABLED.set(this.getMap(), enabled);
        return this;
    }

    public boolean getUndockEnabled() {
        return UNDOCK_ENABLED.get(this.getMap());
    }

    public DockingWindowProperties setUndockEnabled(boolean enabled) {
        UNDOCK_ENABLED.set(this.getMap(), enabled);
        return this;
    }

    public boolean getUndockOnDropEnabled() {
        return UNDOCK_ON_DROP.get(this.getMap());
    }

    public DockingWindowProperties setUndockOnDropEnabled(boolean enabled) {
        UNDOCK_ON_DROP.set(this.getMap(), enabled);
        return this;
    }

    public boolean getDockEnabled() {
        return DOCK_ENABLED.get(this.getMap());
    }

    public DockingWindowProperties setDockEnabled(boolean enabled) {
        DOCK_ENABLED.set(this.getMap(), enabled);
        return this;
    }

    public boolean getMinimizeEnabled() {
        return MINIMIZE_ENABLED.get(this.getMap());
    }

    public DockingWindowProperties setMinimizeEnabled(boolean enabled) {
        MINIMIZE_ENABLED.set(this.getMap(), enabled);
        return this;
    }

    public boolean getMaximizeEnabled() {
        return MAXIMIZE_ENABLED.get(this.getMap());
    }

    public DockingWindowProperties setMaximizeEnabled(boolean enabled) {
        MAXIMIZE_ENABLED.set(this.getMap(), enabled);
        return this;
    }

    public boolean getCloseEnabled() {
        return CLOSE_ENABLED.get(this.getMap());
    }

    public DockingWindowProperties setCloseEnabled(boolean enabled) {
        CLOSE_ENABLED.set(this.getMap(), enabled);
        return this;
    }

    public boolean getRestoreEnabled() {
        return RESTORE_ENABLED.get(this.getMap());
    }

    public DockingWindowProperties setRestoreEnabled(boolean enabled) {
        RESTORE_ENABLED.set(this.getMap(), enabled);
        return this;
    }

    public DockingWindowTitleProvider getTitleProvider() {
        return TITLE_PROVIDER.get(this.getMap());
    }

    public DockingWindowProperties setTitleProvider(DockingWindowTitleProvider titleProvider) {
        TITLE_PROVIDER.set(this.getMap(), titleProvider);
        return this;
    }
}

