/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.menu;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.dpolivaev.mnemonicsetter.MnemonicSetter;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.ActionEnabler;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.MenuSplitter;
import org.freeplane.core.ui.menubuilders.action.AcceleratebleActionProvider;
import org.freeplane.core.ui.menubuilders.action.IAcceleratorMap;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryPopupListener;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.RecursiveMenuStructureProcessor;
import org.freeplane.core.ui.menubuilders.generic.ResourceAccessor;
import org.freeplane.core.ui.menubuilders.menu.ComponentProvider;
import org.freeplane.core.ui.menubuilders.menu.IconReplacer;
import org.freeplane.core.ui.menubuilders.menu.MenuActionComponentProvider;
import org.freeplane.core.ui.menubuilders.menu.PopupMenuListenerForEntry;
import org.freeplane.core.ui.textchanger.TranslatedElement;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;

public class JMenuItemBuilder
implements EntryVisitor {
    private final EntryPopupListener popupListener;
    final ResourceAccessor resourceAccessor;
    private final MenuSplitter menuSplitter;
    private final EntryAccessor entryAccessor;
    private final ComponentProvider menuActionComponentProvider;

    public JMenuItemBuilder(EntryPopupListener popupListener, IAcceleratorMap accelerators, AcceleratebleActionProvider acceleratebleActionProvider, ResourceAccessor resourceAccessor) {
        this(popupListener, new MenuActionComponentProvider(accelerators, acceleratebleActionProvider, resourceAccessor), resourceAccessor);
    }

    public JMenuItemBuilder(EntryPopupListener popupListener, ComponentProvider menuActionComponentProvider, ResourceAccessor resourceAccessor) {
        this.popupListener = popupListener;
        this.resourceAccessor = resourceAccessor;
        this.entryAccessor = new EntryAccessor(resourceAccessor);
        this.menuSplitter = new MenuSplitter(resourceAccessor.getIntProperty("max_menu_item_count", 10));
        this.menuActionComponentProvider = menuActionComponentProvider;
    }

    @Override
    public void visit(Entry entry) {
        if (Boolean.FALSE.equals(entry.getAttribute("allowed"))) {
            return;
        }
        if (this.containsSubmenu(entry)) {
            this.addSubmenu(entry);
        } else {
            this.addActionItem(entry);
        }
    }

    public boolean containsSubmenu(Entry entry) {
        return (entry.hasChildren() || this.entryAccessor.getAction(entry) == null) && !this.entryAccessor.getText(entry).isEmpty();
    }

    private void addActionItem(Entry entry) {
        Component actionComponent = this.createActionComponent(entry);
        if (actionComponent != null) {
            this.setTranslationKey(entry, actionComponent);
            this.addComponent(entry, actionComponent);
        }
    }

    private Component createActionComponent(Entry entry) {
        Component alreadyExistingComponent = this.entryAccessor.getComponent(entry);
        if (alreadyExistingComponent != null) {
            LogUtils.severe("BUG : component already exists at " + entry.getPath());
            return null;
        }
        Component component = this.menuActionComponentProvider.createComponent(entry);
        AFreeplaneAction action = this.entryAccessor.getAction(entry);
        if (action != null) {
            ActionEnabler actionEnabler = new ActionEnabler(component);
            action.addPropertyChangeListener(actionEnabler);
            entry.setAttribute(actionEnabler.getClass(), (Object)actionEnabler);
        }
        return component;
    }

    private void addComponent(Entry entry, Component component) {
        this.entryAccessor.setComponent(entry, component);
        Container container = (Container)this.entryAccessor.getAncestorComponent(entry);
        if (container != null) {
            this.menuSplitter.addComponent(container, component);
        }
    }

    private void addSubmenu(Entry entry) {
        Component actionComponent = this.createActionComponent(entry);
        JMenu menu = new JMenu();
        String rawText = this.entryAccessor.getText(entry);
        LabelAndMnemonicSetter.setLabelAndMnemonic(menu, rawText);
        if (!this.entryAccessor.shouldRemoveMenuIcon(entry)) {
            IconReplacer.replaceByImageIcon(entry, menu, this.entryAccessor);
        }
        this.addComponent(entry, menu);
        if (actionComponent != null) {
            this.menuSplitter.addMenuComponent(menu, actionComponent);
        }
        PopupMenuListenerForEntry popupMenuListener = new PopupMenuListenerForEntry(entry, this.popupListener, this.resourceAccessor);
        if (Compat.isMacOsX()) {
            this.addPopupMenuListenersForMacOsX(menu, popupMenuListener);
        } else {
            JPopupMenu popupMenu = menu.getPopupMenu();
            popupMenu.addPopupMenuListener(MnemonicSetter.INSTANCE);
            popupMenu.addPopupMenuListener(popupMenuListener);
        }
        this.setTranslationKey(entry, menu);
    }

    private void addPopupMenuListenersForMacOsX(JMenu menu, final PopupMenuListener popupMenuListener) {
        menu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PopupMenuEvent popupMenuEvent = new PopupMenuEvent(e.getSource());
                if (e.getStateChange() == 1) {
                    popupMenuListener.popupMenuWillBecomeVisible(popupMenuEvent);
                }
                if (e.getStateChange() == 2) {
                    popupMenuListener.popupMenuWillBecomeInvisible(popupMenuEvent);
                }
            }
        });
    }

    private void setTranslationKey(Entry entry, Component actionComponent) {
        if (actionComponent instanceof JComponent) {
            String textKey = this.entryAccessor.getTextKey(entry);
            if (textKey != null) {
                TranslatedElement.TEXT.setKey((JComponent)actionComponent, textKey);
            }
            String tooltipKey = this.entryAccessor.getTooltipKey(entry);
            if (textKey != null) {
                TranslatedElement.TOOLTIP.setKey((JComponent)actionComponent, tooltipKey);
            }
        }
    }

    @Override
    public boolean shouldSkipChildren(Entry entry) {
        return Boolean.FALSE.equals(entry.getAttribute("allowed")) || RecursiveMenuStructureProcessor.shouldProcessUiOnEvent(entry);
    }
}

