/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.generic;

import java.io.IOException;
import java.util.LinkedHashMap;
import org.freeplane.core.ui.menubuilders.generic.EntryNavigator;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;

class EntryNavigatorFactory {
    private static final String MENU_ALIASES_PROPERTIES = "/menu_aliases.properties";
    private static LinkedHashMap<String, String> aliases;

    static EntryNavigator createNavigator() {
        aliases = new LinkedHashMap();
        try {
            String content = FileUtils.slurpResource(MENU_ALIASES_PROPERTIES);
            for (String line : content.split("[\n\r]+")) {
                EntryNavigatorFactory.parseLine(line);
            }
        }
        catch (IOException e) {
            LogUtils.severe("cannot load /menu_aliases.properties", e);
        }
        EntryNavigator entryNavigator = new EntryNavigator(aliases);
        return entryNavigator;
    }

    private static void parseLine(String line) {
        if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
            String[] words = line.split("\\s*=\\s*");
            if (words.length != 2) {
                throw new RuntimeException("parse error in /menu_aliases.properties line '" + line + "'");
            }
            aliases.put(words[0], words[1]);
        }
    }

    private EntryNavigatorFactory() {
    }
}

