/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.DTOId;
import org.knopflerfish.framework.ImportPkg;
import org.knopflerfish.framework.Pkg;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;

class ExportPkg
extends DTOId
implements BundleCapability,
Comparable<ExportPkg> {
    private static int exportPkgCount = 0;
    final int orderal = ++exportPkgCount;
    final String name;
    final BundlePackages bpkgs;
    final Set<String> uses;
    final Set<String> mandatory;
    final Set<String> include;
    final Set<String> exclude;
    final Version version;
    final Map<String, Object> attributes;
    boolean zombie = false;
    Pkg pkg = null;

    ExportPkg(String name, Util.HeaderEntry he, BundlePackages b) {
        this.bpkgs = b;
        this.name = name;
        if (name.startsWith("java.")) {
            throw new IllegalArgumentException("You can not export a java.* package");
        }
        this.uses = Util.parseEnumeration("uses", he.getDirectives().get("uses"));
        this.mandatory = Util.parseEnumeration("mandatory", he.getDirectives().get("mandatory"));
        this.include = Util.parseEnumeration("include", he.getDirectives().get("include"));
        this.exclude = Util.parseEnumeration("exclude", he.getDirectives().get("exclude"));
        String versionStr = (String)he.getAttributes().remove("version");
        String SPEC_VERSION = "specification-version";
        String specVersionStr = (String)he.getAttributes().remove("specification-version");
        if (specVersionStr != null) {
            this.version = new Version(specVersionStr);
            if (versionStr != null && !this.version.equals(new Version(versionStr))) {
                throw new IllegalArgumentException("Both version and specification-version are specified, and differs");
            }
        } else {
            this.version = versionStr != null ? new Version(versionStr) : Version.emptyVersion;
        }
        if (he.getAttributes().containsKey("bundle-version")) {
            throw new IllegalArgumentException("Export definition illegally contains attribute, bundle-version");
        }
        if (he.getAttributes().containsKey("bundle-symbolic-name")) {
            throw new IllegalArgumentException("Export definition illegally contains attribute, bundle-symbolic-name");
        }
        this.attributes = Collections.unmodifiableMap(he.getAttributes());
    }

    ExportPkg(ExportPkg ep, String name) {
        this.name = name;
        this.bpkgs = ep.bpkgs;
        this.uses = ep.uses;
        this.mandatory = ep.mandatory;
        this.include = ep.include;
        this.exclude = ep.exclude;
        this.version = ep.version;
        this.attributes = ep.attributes;
    }

    ExportPkg(ExportPkg ep, BundlePackages b) {
        this.name = ep.name;
        this.bpkgs = b;
        this.uses = ep.uses;
        this.mandatory = ep.mandatory;
        this.include = ep.include;
        this.exclude = ep.exclude;
        this.version = ep.version;
        this.attributes = ep.attributes;
    }

    void attachPkg(Pkg p) {
        this.pkg = p;
    }

    void detachPkg() {
        this.pkg = null;
        this.zombie = false;
    }

    boolean checkFilter(String fullClassName) {
        String clazz = null;
        boolean ok = true;
        if (fullClassName != null) {
            if (this.include != null) {
                clazz = fullClassName.substring(this.name.length() + 1);
                Iterator<String> i = this.include.iterator();
                while (i.hasNext() && !Util.filterMatch(i.next(), clazz)) {
                    if (i.hasNext()) continue;
                    ok = false;
                }
            }
            if (ok && this.exclude != null) {
                if (clazz == null) {
                    clazz = fullClassName.substring(this.name.length() + 1);
                }
                for (String string : this.exclude) {
                    if (!Util.filterMatch(string, clazz)) continue;
                    ok = false;
                    break;
                }
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isProvider() {
        Pkg p = this.pkg;
        if (p != null) {
            Pkg pkg = p;
            synchronized (pkg) {
                return p.providers.contains(this) || this.bpkgs.isRequired();
            }
        }
        return false;
    }

    boolean isExported() {
        BundlePackages bp = this.bpkgs;
        if (this.checkPermission() && this.pkg != null && (bp.bg.bundle.isResolved() || this.zombie)) {
            BundlePackages pbp = bp.getProviderBundlePackages(this.name);
            return pbp == null || pbp.bg.bundle == this.bpkgs.bg.bundle;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ImportPkg> getPackageImporters() {
        Pkg p = this.pkg;
        if (p != null) {
            ArrayList<ImportPkg> res = new ArrayList<ImportPkg>();
            Pkg pkg = p;
            synchronized (pkg) {
                for (ImportPkg ip : p.importers) {
                    if (ip.provider != this || ip.bpkgs == this.bpkgs) continue;
                    res.add(ip);
                }
            }
            return res;
        }
        return null;
    }

    boolean checkPermission() {
        return this.bpkgs.bg.bundle.fwCtx.perm.hasExportPackagePermission(this);
    }

    boolean pkgEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o) {
            return false;
        }
        ExportPkg ep = (ExportPkg)o;
        return this.name.equals(ep.name) && this.version.equals(ep.version) && (this.uses == null ? ep.uses == null : ((Object)this.uses).equals(ep.uses)) && (this.mandatory == null ? ep.mandatory == null : ((Object)this.mandatory).equals(ep.mandatory)) && (this.include == null ? ep.include == null : ((Object)this.include).equals(ep.include)) && (this.exclude == null ? ep.exclude == null : ((Object)this.exclude).equals(ep.exclude)) && ((Object)this.attributes).equals(ep.attributes);
    }

    public String pkgString() {
        if (this.version != Version.emptyVersion) {
            return this.name + ";" + "version" + "=" + this.version;
        }
        return this.name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.pkgString());
        sb.append(' ');
        if (this.zombie) {
            sb.append("Zombie");
        }
        sb.append("Bundle");
        sb.append(this.bpkgs.bundleGenInfo());
        return sb.toString();
    }

    @Override
    public String getNamespace() {
        return "osgi.wiring.package";
    }

    @Override
    public Map<String, String> getDirectives() {
        HashMap<String, String> res = new HashMap<String, String>(1);
        if (this.uses != null) {
            StringBuffer sb = new StringBuffer(this.uses.size() * 30);
            for (String pkg : this.uses) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(pkg);
            }
            res.put("uses", sb.toString());
        }
        return res;
    }

    @Override
    public Map<String, Object> getAttributes() {
        HashMap<String, Object> res = new HashMap<String, Object>(4 + this.attributes.size());
        res.put("osgi.wiring.package", this.name);
        res.put("version", this.version);
        res.put("bundle-symbolic-name", this.bpkgs.bg.symbolicName);
        res.put("bundle-version", this.bpkgs.bg.version);
        res.putAll(this.attributes);
        return Collections.unmodifiableMap(res);
    }

    @Override
    public BundleRevision getRevision() {
        return this.bpkgs.bg.bundleRevision;
    }

    @Override
    public BundleRevision getResource() {
        return this.bpkgs.bg.bundleRevision;
    }

    @Override
    public int compareTo(ExportPkg o) {
        return this.orderal - o.orderal;
    }
}

