/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerExecutionContext;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableTrigger;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTriggerManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class SQLServerTableTriggerManager
extends SQLTriggerManager<SQLServerTableTrigger, SQLServerTableBase> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, SQLServerTableTrigger> getObjectsCache(SQLServerTableTrigger object) {
        return object.getSchema().getTriggerCache();
    }

    protected SQLServerTableTrigger createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        SQLServerTableBase table = (SQLServerTableBase)container;
        String newTriggerName = "NewTrigger";
        SQLServerTableTrigger newTrigger = new SQLServerTableTrigger(table, newTriggerName);
        newTrigger.setBody("CREATE OR ALTER TRIGGER " + newTriggerName + " ON " + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + "\nAFTER INSERT\nAS\n;\n");
        return newTrigger;
    }

    protected void createOrReplaceTriggerQuery(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLServerTableTrigger trigger, boolean create) {
        SQLServerTableBase table;
        SQLServerDatabase defaultDatabase = ((SQLServerExecutionContext)executionContext).getDefaultCatalog();
        if (defaultDatabase != (table = trigger.getTable()).getDatabase()) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Set current database", "USE " + DBUtils.getQuotedIdentifier((DBSObject)table.getDatabase()), false));
        }
        if (create) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create trigger", trigger.getBody(), true));
        } else {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Alter trigger", SQLServerUtils.changeCreateToAlterDDL(trigger.getDataSource(), trigger.getBody()), true));
        }
        if (defaultDatabase != table.getDatabase()) {
            String defaultCatalogName = SQLServerTableTriggerManager.getDefaultCatalogName((SQLServerExecutionContext)executionContext, (DBSObject)defaultDatabase, table);
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Set current database ", "USE " + defaultCatalogName, false));
        }
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        SQLServerTableBase table;
        SQLServerTableTrigger trigger = (SQLServerTableTrigger)command.getObject();
        SQLServerDatabase defaultDatabase = ((SQLServerExecutionContext)executionContext).getDefaultCatalog();
        if (defaultDatabase != (table = trigger.getTable()).getDatabase()) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Set current database", "USE " + DBUtils.getQuotedIdentifier((DBSObject)table.getDatabase()), false));
        }
        super.addObjectDeleteActions(monitor, executionContext, actions, command, options);
        if (defaultDatabase != table.getDatabase()) {
            String defaultCatalogName = SQLServerTableTriggerManager.getDefaultCatalogName((SQLServerExecutionContext)executionContext, (DBSObject)defaultDatabase, table);
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Set current database ", "USE " + defaultCatalogName, false));
        }
    }

    @NotNull
    private static String getDefaultCatalogName(@NotNull SQLServerExecutionContext executionContext, @Nullable DBSObject defaultDatabase, @NotNull SQLServerTableBase table) {
        String defaultCatalogName = defaultDatabase != null ? DBUtils.getQuotedIdentifier((DBSObject)defaultDatabase) : DBUtils.getQuotedIdentifier((DBPDataSource)table.getDataSource(), (String)executionContext.getActiveDatabaseName());
        return defaultCatalogName;
    }
}

