/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.binary;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.editors.binary.ActionHistory;
import org.jkiss.dbeaver.utils.ContentUtils;

public class BinaryContent {
    private static final long mappedFileBufferLength = 0x200000L;
    private ActionHistory actions = null;
    private ActionHistory actionsTemp = null;
    private boolean dirty = false;
    private long exclusiveEnd = -1L;
    private long lastUpperNibblePosition = -1L;
    private List<ModifyListener> listeners = null;
    private List<Integer> changeList = null;
    private boolean changesInserted = false;
    private long changesPosition = -1L;
    private TreeSet<Range> ranges = new TreeSet();
    private Iterator<Range> tailTree = null;

    BinaryContent() {
    }

    BinaryContent(File aFile) throws IOException {
        this();
        if (aFile == null || aFile.length() < 1L) {
            return;
        }
        this.ranges.add(new Range(0L, aFile, false));
    }

    void actionsOn(boolean on) {
        if (on) {
            if (this.actions == null) {
                this.actions = this.actionsTemp;
            }
        } else {
            this.actionsTemp = this.actions;
            this.actions = null;
        }
    }

    public void addModifyListener(ModifyListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ModifyListener>();
        }
        this.listeners.add(listener);
    }

    public boolean canRedo() {
        return this.actions != null && this.actions.canRedo();
    }

    public boolean canUndo() {
        return this.actions != null && this.actions.canUndo();
    }

    void commitChanges() {
        if (this.changeList == null) {
            return;
        }
        ByteBuffer store = ByteBuffer.allocate(this.changeList.size());
        for (Integer myChange : this.changeList) {
            store.put(myChange.byteValue());
        }
        store.position(0);
        this.changeList = null;
        if (this.changesInserted) {
            this.insertRange(new Range(this.changesPosition, store, true));
        } else {
            this.overwriteRange(new Range(this.changesPosition, store, true));
        }
        this.changesInserted = false;
        this.changesPosition = -1L;
    }

    public void delete(long position, long length) {
        if (position < 0L || position >= this.length() || length < 1L) {
            return;
        }
        this.dirty = true;
        if (length > this.length() - position) {
            length = this.length() - position;
        }
        if (this.actions != null) {
            this.lastUpperNibblePosition = -1L;
            this.actions.eventPreModify(ActionHistory.ActionType.DELETE, position, length == 1L);
        }
        if (this.changeList != null && this.changesInserted && this.changesPosition <= position && this.changesPosition + (long)this.changeList.size() >= position + length) {
            int deleteStart = (int)(position - this.changesPosition);
            List<Integer> subList = this.changeList.subList(deleteStart, deleteStart + (int)length);
            if (this.actions != null) {
                this.actions.addDeleted(position, subList, length == 1L);
                if (length > 1L) {
                    this.actions.endAction();
                }
            }
            if (length < (long)this.changeList.size()) {
                subList.clear();
            } else {
                this.changeList = null;
            }
        } else {
            this.commitChanges();
            this.deleteAndShift(position, length);
        }
        this.notifyListeners();
    }

    private void deleteAndShift(long start, long length) {
        this.deleteInternal(start, length);
        this.initSubtreeTraversing(start, 0L);
        this.shiftRemainingRanges(-length);
    }

    private void deleteInternal(long startPosition, long length) {
        if (length < 1L) {
            return;
        }
        this.initSubtreeTraversing(startPosition, length);
        if (!this.tailTree.hasNext()) {
            return;
        }
        ArrayList<Range> deleted = new ArrayList<Range>();
        Range firstRange = this.tailTree.next();
        Range secondRange = (Range)firstRange.clone();
        Range lastRange = null;
        if (firstRange.position < startPosition) {
            firstRange.length = startPosition - firstRange.position;
            secondRange.length = secondRange.exclusiveEnd() - startPosition;
            secondRange.dataOffset += startPosition - secondRange.position;
            secondRange.position = startPosition;
        } else {
            this.tailTree.remove();
        }
        long endSoFar = secondRange.exclusiveEnd();
        boolean toBeAdded = false;
        if (endSoFar > this.exclusiveEnd) {
            lastRange = (Range)secondRange.clone();
            toBeAdded = true;
            secondRange.length = this.exclusiveEnd - secondRange.position;
        }
        deleted.add(secondRange);
        if (endSoFar < this.exclusiveEnd) {
            while (this.tailTree.hasNext() && lastRange == null) {
                lastRange = this.tailTree.next();
                if (lastRange.exclusiveEnd() > this.exclusiveEnd) continue;
                this.tailTree.remove();
                deleted.add(lastRange);
                lastRange = null;
            }
            if (lastRange != null && lastRange.position < this.exclusiveEnd) {
                Range beforeLastRange = (Range)lastRange.clone();
                beforeLastRange.length = this.exclusiveEnd - beforeLastRange.position;
                deleted.add(beforeLastRange);
            }
        }
        if (lastRange != null && lastRange.position < this.exclusiveEnd && lastRange.exclusiveEnd() > this.exclusiveEnd) {
            long delta = this.exclusiveEnd - lastRange.position;
            lastRange.position += delta;
            lastRange.length -= delta;
            lastRange.dataOffset += delta;
            if (toBeAdded) {
                this.ranges.add(lastRange);
            }
        }
        if (this.actions != null) {
            this.actions.addLostRanges(deleted);
        }
    }

    private long[] deleteRanges(List<Range> currentAction) {
        long[] result = new long[2];
        result[0] = result[1] = currentAction.get((int)0).position;
        this.actionsOn(false);
        this.deleteAndShift(result[0], currentAction.get(currentAction.size() - 1).exclusiveEnd() - result[0]);
        this.actionsOn(true);
        return result;
    }

    public void dispose() {
        if (this.ranges == null) {
            return;
        }
        for (Range value : this.ranges) {
            if (!(value.data instanceof Closeable)) continue;
            ContentUtils.close((Closeable)((Closeable)value.data));
        }
        if (this.actions != null) {
            this.actions.dispose();
            this.actions = null;
        }
        this.ranges = null;
        this.listeners = null;
    }

    private int fillWithChanges(ByteBuffer dst, long position) {
        long relativePosition = position - this.changesPosition;
        int changesSize = this.changeList.size();
        if (relativePosition < 0L || relativePosition >= (long)changesSize) {
            return 0;
        }
        int remaining = dst.remaining();
        int i = (int)relativePosition;
        while (remaining > 0 && i < changesSize) {
            dst.put(this.changeList.get(i).byteValue());
            ++i;
            --remaining;
        }
        return i - (int)relativePosition;
    }

    private int fillWithPartOfRange(ByteBuffer dst, Range sourceRange, long overlapBytes, int maxCopyLength) throws IOException {
        int dstInitialPosition = dst.position();
        if (sourceRange.data instanceof ByteBuffer) {
            ByteBuffer src = (ByteBuffer)sourceRange.data;
            src.limit((int)(sourceRange.dataOffset + sourceRange.length));
            src.position((int)(sourceRange.dataOffset + overlapBytes));
            if (src.remaining() > dst.remaining() || src.remaining() > maxCopyLength) {
                src.limit(src.position() + Math.min(dst.remaining(), maxCopyLength));
            }
            dst.put(src);
        } else if (sourceRange.data instanceof RandomAccessFile) {
            RandomAccessFile src = (RandomAccessFile)sourceRange.data;
            long start = sourceRange.dataOffset + overlapBytes;
            int length = (int)Math.min(sourceRange.length - overlapBytes, (long)maxCopyLength);
            int limit = -1;
            if (dst.remaining() > length) {
                limit = dst.limit();
                dst.limit(dst.position() + length);
            }
            src.getChannel().read(dst, start);
            if (limit > 0) {
                dst.limit(limit);
            }
        }
        return dst.position() - dstInitialPosition;
    }

    private void fillWithRange(ByteBuffer dst, Range sourceRange, long overlapBytes, long position, List<Long> rangesModified) throws IOException {
        long positionSoFar = position;
        if (position < this.changesPosition) {
            int added = this.fillWithPartOfRange(dst, sourceRange, overlapBytes, (int)Math.min(this.changesPosition - position, Integer.MAX_VALUE));
            positionSoFar += (long)added;
            overlapBytes += (long)added;
        }
        int changesAdded = 0;
        long changesPosition = positionSoFar;
        if (this.changeList != null && positionSoFar >= this.changesPosition && positionSoFar < this.changesPosition + (long)this.changeList.size() && overlapBytes < sourceRange.length) {
            changesAdded = this.fillWithChanges(dst, positionSoFar);
            if (this.changesInserted) {
                positionSoFar += (long)changesAdded;
            } else {
                overlapBytes += (long)changesAdded;
            }
        }
        positionSoFar += (long)this.fillWithPartOfRange(dst, sourceRange, overlapBytes, Integer.MAX_VALUE);
        if (rangesModified != null) {
            if (sourceRange.dirty) {
                rangesModified.add(position);
                rangesModified.add(positionSoFar - position);
            } else if (changesAdded > 0) {
                rangesModified.add(changesPosition);
                rangesModified.add(Long.valueOf(changesAdded));
            }
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public int get(ByteBuffer dst, long position) throws IOException {
        return this.get(dst, null, position);
    }

    /*
     * Unable to fully structure code
     */
    public int get(ByteBuffer dst, List<Long> rangesModified, long position) throws IOException {
        if (rangesModified != null) {
            rangesModified.clear();
        }
        positionShift = 0L;
        dstInitialRemaining = dst.remaining();
        if (this.changeList != null && this.changesInserted && position > this.changesPosition) {
            positionShift = (int)Math.min((long)this.changeList.size(), position - this.changesPosition);
        }
        positionSoFar = position - positionShift;
        this.initSubtreeTraversing(positionSoFar, dst.remaining());
        if (true) ** GOTO lbl16
        do {
            this.fillWithRange(dst, partialRange, positionSoFar - partialRange.position, positionSoFar + positionShift, rangesModified);
            positionSoFar = partialRange.exclusiveEnd();
            if (this.changeList != null && this.changesInserted && positionSoFar + positionShift > this.changesPosition) {
                positionShift = this.changeList.size();
            }
lbl16:
            // 4 sources

            if (!this.tailTree.hasNext()) break;
            partialRange = this.tailTree.next();
        } while (partialRange.position < this.exclusiveEnd);
        if (dst.remaining() > 0 && this.changeList != null && positionSoFar + positionShift < this.changesPosition + (long)this.changeList.size()) {
            size = this.fillWithChanges(dst, positionSoFar + positionShift);
            if (rangesModified != null) {
                rangesModified.add(positionSoFar + positionShift);
                rangesModified.add(Long.valueOf(size));
            }
        }
        return dstInitialRemaining - dst.remaining();
    }

    public long get(File destinationFile) throws IOException {
        return this.get(destinationFile, 0L, this.length());
    }

    public long get(File destinationFile, long start, long length) throws IOException {
        if (start < 0L || length < 0L || start + length > this.length()) {
            return 0L;
        }
        if (this.actions != null) {
            this.actions.endAction();
        }
        this.commitChanges();
        RandomAccessFile dst = new RandomAccessFile(destinationFile, "rws");
        try {
            dst.setLength(length);
            FileChannel channel = dst.getChannel();
            ByteBuffer buffer = null;
            long position = 0L;
            while (position < length) {
                int partLength = (int)Math.min(0x200000L, length - position);
                boolean bufferFromMap = true;
                try {
                    buffer = channel.map(FileChannel.MapMode.READ_WRITE, position, partLength);
                }
                catch (IOException iOException) {
                    bufferFromMap = false;
                    if (buffer == null) {
                        buffer = ByteBuffer.allocateDirect(0x200000);
                    }
                    buffer.position(0);
                    buffer.limit(partLength);
                }
                this.get(buffer, start + position);
                if (bufferFromMap) {
                    ((MappedByteBuffer)buffer).force();
                    buffer = null;
                } else {
                    buffer.position(0);
                    buffer.limit(partLength);
                    channel.write(buffer, position);
                }
                position += 0x200000L;
            }
            channel.force(true);
            channel.close();
        }
        finally {
            ContentUtils.close((Closeable)dst);
        }
        return length;
    }

    private int getFromRanges(long position) throws IOException {
        int result = 0;
        Range range = this.getRangeAt(position);
        if (range != null) {
            Object value = range.data;
            if (value instanceof ByteBuffer) {
                ByteBuffer data = (ByteBuffer)value;
                data.limit(data.capacity());
                data.position((int)range.dataOffset);
                result = data.get((int)(position - range.position)) & 0xFF;
            } else if (value instanceof RandomAccessFile) {
                RandomAccessFile randomFile = (RandomAccessFile)value;
                randomFile.seek(position);
                result = randomFile.read();
            }
        }
        return result;
    }

    Range getRangeAt(long position) {
        SortedSet<Range> subSet = this.ranges.tailSet(new Range(position, 1L));
        if (subSet.isEmpty()) {
            return null;
        }
        return subSet.first();
    }

    private Set<Range> initSubtreeTraversing(long position, long length) {
        SortedSet<Range> result = this.ranges.tailSet(new Range(position, 1L));
        this.tailTree = result.iterator();
        this.exclusiveEnd = position + length;
        if (this.exclusiveEnd > this.length()) {
            this.exclusiveEnd = this.length();
        }
        return result;
    }

    public void insert(byte source, long position) throws IOException {
        if (position > this.length()) {
            return;
        }
        this.dirty = true;
        this.lastUpperNibblePosition = position;
        if (this.actions != null) {
            this.actions.eventPreModify(ActionHistory.ActionType.INSERT, position, true);
        }
        this.updateChanges(position, true);
        this.changeList.set((int)(position - this.changesPosition), source & 0xFF);
        this.notifyListeners();
    }

    public void insert(ByteBuffer source, long position) {
        if (source.remaining() < 1 || position > this.length()) {
            return;
        }
        this.dirty = true;
        this.lastUpperNibblePosition = -1L;
        if (this.actions != null) {
            this.actions.eventPreModify(ActionHistory.ActionType.INSERT, position, false);
        }
        this.commitChanges();
        Range newRange = new Range(position, source, true);
        this.insertRange(newRange);
        if (this.actions != null) {
            this.actions.addInserted((Range)newRange.clone());
        }
        this.notifyListeners();
    }

    public void insert(File aFile, long position) throws IOException {
        long fileLength = aFile.length();
        if (fileLength < 1L || position > this.length()) {
            return;
        }
        Range newRange = new Range(position, aFile, true);
        this.dirty = true;
        this.lastUpperNibblePosition = -1L;
        if (this.actions != null) {
            this.actions.eventPreModify(ActionHistory.ActionType.INSERT, position, false);
        }
        this.commitChanges();
        this.insertRange(newRange);
        if (this.actions != null) {
            this.actions.addInserted((Range)newRange.clone());
        }
        this.notifyListeners();
    }

    private void insertRange(Range newRange) {
        this.splitAndShift(newRange.position, newRange.length);
        this.ranges.add(newRange);
    }

    private long[] insertRanges(List<Range> ranges) {
        Range firstRange = ranges.get(0);
        Range lastRange = ranges.get(ranges.size() - 1);
        this.splitAndShift(firstRange.position, lastRange.exclusiveEnd() - firstRange.position);
        ArrayList<Range> cloned = new ArrayList<Range>(ranges.size());
        for (Range range : ranges) {
            cloned.add((Range)range.clone());
        }
        this.ranges.addAll(cloned);
        return new long[]{firstRange.position, lastRange.exclusiveEnd()};
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public long length() {
        long result = 0L;
        if (this.ranges.size() > 0) {
            result = this.ranges.last().exclusiveEnd();
        }
        if (this.changeList != null && this.changesInserted) {
            result += (long)this.changeList.size();
        }
        return result;
    }

    private void notifyListeners() {
        if (this.listeners == null) {
            return;
        }
        for (ModifyListener listener : this.listeners) {
            listener.modified();
        }
    }

    public void overwrite(byte source, long position) throws IOException {
        this.overwrite(source, 0, 8, position);
    }

    public void overwrite(byte source, int offset, int length, long position) throws IOException {
        if (offset < 0 || offset > 7 || length < 0 || position >= this.length()) {
            return;
        }
        this.dirty = true;
        if (this.actions != null) {
            if (this.lastUpperNibblePosition == position && offset == 4 && length == 4) {
                this.actionsOn(false);
            } else {
                this.actions.eventPreModify(ActionHistory.ActionType.OVERWRITE, position, true);
            }
        }
        if (length + offset > 8) {
            length = 8 - offset;
        }
        Range range = this.updateChanges(position, false);
        int previous = this.changeList.get((int)(position - this.changesPosition));
        int mask = 255 >>> offset & 255 << 8 - offset - length;
        int newValue = previous & ~mask | source << 8 - offset - length & mask;
        this.changeList.set((int)(position - this.changesPosition), newValue);
        if (this.actions != null) {
            if (range == null) {
                this.actions.addLostByte(position, previous);
            } else {
                Range clone = (Range)range.clone();
                clone.position = position;
                clone.length = 1L;
                clone.dataOffset = range.dataOffset + position - range.position;
                this.actions.addLostRange(clone);
            }
        }
        this.actionsOn(true);
        this.lastUpperNibblePosition = this.actions != null && offset == 0 && length == 4 ? position : -1L;
        this.notifyListeners();
    }

    public void overwrite(ByteBuffer source, long position) {
        if (source.remaining() > 0 && position < this.length()) {
            this.overwriteInternal(new Range(position, source, true));
        }
    }

    public void overwrite(File aFile, long position) throws IOException {
        if (aFile.length() > 0L && position < this.length()) {
            this.overwriteInternal(new Range(position, aFile, true));
        }
    }

    private void overwriteInternal(Range newRange) {
        this.dirty = true;
        this.lastUpperNibblePosition = -1L;
        if (this.actions != null) {
            this.actions.eventPreModify(ActionHistory.ActionType.OVERWRITE, newRange.position, false);
        }
        this.commitChanges();
        this.overwriteRange(newRange);
        if (this.actions != null) {
            this.actions.addRangeToCurrentAction((Range)newRange.clone());
        }
        this.notifyListeners();
    }

    private void overwriteRange(Range aRange) {
        this.deleteInternal(aRange.position, aRange.length);
        this.ranges.add(aRange);
    }

    private long[] overwriteRanges(List<Range> ranges) {
        Range firstRange = ranges.get(0);
        Range lastRange = ranges.get(ranges.size() - 1);
        this.splitAndShift(firstRange.position, 0L);
        this.splitAndShift(lastRange.exclusiveEnd(), 0L);
        this.initSubtreeTraversing(firstRange.position, 0L);
        if (this.tailTree.hasNext()) {
            Range goingRange = this.tailTree.next();
            while (goingRange != null && goingRange.exclusiveEnd() <= lastRange.exclusiveEnd()) {
                this.tailTree.remove();
                goingRange = null;
                if (!this.tailTree.hasNext()) continue;
                goingRange = this.tailTree.next();
            }
        }
        ArrayList<Range> cloned = new ArrayList<Range>(ranges.size());
        for (Range range : ranges) {
            cloned.add((Range)range.clone());
        }
        this.ranges.addAll(cloned);
        return new long[]{firstRange.position, lastRange.exclusiveEnd()};
    }

    public long[] redo() {
        if (this.actions == null) {
            return null;
        }
        Object[] action = this.actions.redoAction();
        if (action == null) {
            return null;
        }
        long[] result = null;
        List currentAction = (List)action[1];
        if (action[0] == ActionHistory.ActionType.DELETE) {
            result = this.deleteRanges(currentAction);
        } else if (action[0] == ActionHistory.ActionType.INSERT) {
            result = this.insertRanges(currentAction);
        } else if (action[0] == ActionHistory.ActionType.OVERWRITE) {
            int size = currentAction.size();
            result = this.overwriteRanges(currentAction.subList(size - 1, size));
        }
        this.notifyListeners();
        return result;
    }

    void setActionsHistory() {
        if (this.actions == null) {
            this.commitChanges();
            this.actions = new ActionHistory(this);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void shiftRemainingRanges(long increment) {
        if (increment != 0L) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            currentRange = this.tailTree.next();
            currentRange.position += increment;
lbl5:
            // 2 sources

            ** while (this.tailTree.hasNext())
        }
lbl6:
        // 1 sources

    }

    private void splitAndShift(long position, long increment) {
        this.initSubtreeTraversing(position, 0L);
        if (!this.tailTree.hasNext()) {
            return;
        }
        Range firstRange = this.tailTree.next();
        Range secondRange = null;
        if (firstRange.position < position) {
            long delta;
            secondRange = (Range)firstRange.clone();
            firstRange.length = delta = position - firstRange.position;
            secondRange.length -= delta;
            secondRange.dataOffset += delta;
            secondRange.position = secondRange.position + delta + increment;
        } else {
            firstRange.position += increment;
        }
        this.shiftRemainingRanges(increment);
        if (secondRange != null) {
            this.ranges.add(secondRange);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder("BinaryContent: {length:").append(this.length()).append("}\n");
        for (Range myRange : this.ranges) {
            result.append(myRange).append('\n');
        }
        return result.toString();
    }

    public long[] undo() {
        if (this.actions == null) {
            return null;
        }
        Object[] action = this.actions.undoAction();
        if (action == null) {
            return null;
        }
        this.commitChanges();
        long[] result = null;
        List currentAction = (List)action[1];
        if (action[0] == ActionHistory.ActionType.DELETE) {
            result = this.insertRanges(currentAction);
        } else if (action[0] == ActionHistory.ActionType.INSERT) {
            result = this.deleteRanges(currentAction);
        } else if (action[0] == ActionHistory.ActionType.OVERWRITE) {
            result = this.overwriteRanges(currentAction.subList(0, currentAction.size() - 1));
        }
        this.notifyListeners();
        return result;
    }

    private Range updateChanges(long position, boolean insert) throws IOException {
        Range result = null;
        if (this.changeList != null) {
            long lowerLimit = this.changesPosition;
            long upperLimit = this.changesPosition + (long)this.changeList.size();
            if (!insert && position >= lowerLimit && position < upperLimit) {
                return null;
            }
            if (!insert) {
                --lowerLimit;
            }
            if (insert == this.changesInserted && position >= lowerLimit && position <= upperLimit) {
                if (insert) {
                    this.changeList.add((int)(position - this.changesPosition), 0);
                } else {
                    result = this.getRangeAt(position);
                    if (this.changesPosition > position) {
                        this.changesPosition = position;
                        this.changeList.add(0, this.getFromRanges(position));
                    } else if (this.changesPosition + (long)this.changeList.size() <= position) {
                        this.changeList.add(this.getFromRanges(position));
                    }
                }
                return result;
            }
            this.commitChanges();
        }
        this.changeList = new ArrayList<Integer>();
        this.changeList.add(this.getFromRanges(position));
        this.changesInserted = insert;
        this.changesPosition = position;
        if (!insert) {
            result = this.getRangeAt(position);
        }
        return result;
    }

    public static interface ModifyListener
    extends EventListener {
        public void modified();
    }

    static final class Range
    implements Comparable<Range>,
    Cloneable {
        long position = -1L;
        long length = -1L;
        long dataOffset = 0L;
        Object data = null;
        private boolean dirty = true;

        Range(long aPosition, long aLength) {
            this.position = aPosition;
            this.length = aLength;
        }

        Range(long aPosition, ByteBuffer aBuffer, boolean isDirty) {
            this(aPosition, aBuffer.remaining());
            this.data = aBuffer;
            this.dirty = isDirty;
        }

        Range(long aPosition, File aFile, boolean isDirty) throws IOException {
            this(aPosition, aFile.length());
            if (this.length < 0L) {
                throw new IOException("File error");
            }
            this.data = new RandomAccessFile(aFile, "r");
            this.dirty = isDirty;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public int compareTo(@NotNull Range other) {
            if (this.position < other.position && this.exclusiveEnd() <= other.position) {
                return -1;
            }
            if (other.position < this.position && other.exclusiveEnd() <= this.position) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof Range && this.compareTo((Range)obj) == 0;
        }

        long exclusiveEnd() {
            return this.position + this.length;
        }

        public String toString() {
            return "Range {position:" + this.position + ", length:" + this.length + "}";
        }
    }
}

