/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.GraphVisitor;
import org.eclipse.draw2d.graph.Node;

abstract class SpanningTreeVisitor
extends GraphVisitor {
    SpanningTreeVisitor() {
    }

    Edge getParentEdge(Node node) {
        return (Edge)node.workingData[1];
    }

    EdgeList getSpanningTreeChildren(Node node) {
        return (EdgeList)node.workingData[0];
    }

    protected Node getTreeHead(Edge edge) {
        if (this.getParentEdge(edge.source) == edge) {
            return edge.target;
        }
        return edge.source;
    }

    Node getTreeParent(Node node) {
        Edge e = this.getParentEdge(node);
        if (e == null) {
            return null;
        }
        return e.opposite(node);
    }

    protected Node getTreeTail(Edge edge) {
        if (this.getParentEdge(edge.source) == edge) {
            return edge.source;
        }
        return edge.target;
    }

    void setParentEdge(Node node, Edge edge) {
        node.workingData[1] = edge;
    }
}

