/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.info;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DB2Parameter
implements DBSObject {
    private DB2DataSource dataSource;
    private String name;
    private String value;
    private String flags;
    private String defferedValue;
    private String defferedValueFlags;
    private String dataType;

    public DB2Parameter(DB2DataSource dataSource, ResultSet dbResult) {
        this.dataSource = dataSource;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NAME");
        this.value = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VALUE");
        this.flags = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VALUE_FLAGS");
        this.defferedValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEFERRED_VALUE");
        this.dataType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATATYPE");
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return false;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Property(viewable=true, editable=false, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, editable=false, order=2)
    public String getValue() {
        return this.value;
    }

    @Property(viewable=true, editable=false, order=3)
    public String getFlags() {
        return this.flags;
    }

    @Property(viewable=true, editable=false, order=4)
    public String getDefferedValue() {
        return this.defferedValue;
    }

    @Property(viewable=true, editable=false, order=5)
    public String getDefferedValueFlags() {
        return this.defferedValueFlags;
    }

    @Property(viewable=true, editable=false, order=6)
    public String getDataType() {
        return this.dataType;
    }
}

