/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.editors;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.model.DB2Alias;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2DataType;
import org.jkiss.dbeaver.ext.db2.model.DB2Index;
import org.jkiss.dbeaver.ext.db2.model.DB2MaterializedQueryTable;
import org.jkiss.dbeaver.ext.db2.model.DB2Package;
import org.jkiss.dbeaver.ext.db2.model.DB2Routine;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2Sequence;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TableCheckConstraint;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableForeignKey;
import org.jkiss.dbeaver.ext.db2.model.DB2TableReference;
import org.jkiss.dbeaver.ext.db2.model.DB2TableUniqueKey;
import org.jkiss.dbeaver.ext.db2.model.DB2Tablespace;
import org.jkiss.dbeaver.ext.db2.model.DB2Trigger;
import org.jkiss.dbeaver.ext.db2.model.DB2Variable;
import org.jkiss.dbeaver.ext.db2.model.DB2View;
import org.jkiss.dbeaver.ext.db2.model.DB2XMLSchema;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2Nickname;
import org.jkiss.dbeaver.ext.db2.model.module.DB2Module;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public enum DB2ObjectType implements DBSObjectType
{
    ALIAS((DBPImage)DBIcon.TREE_SYNONYM, DB2Alias.class, new ObjectFinder(){

        @Override
        public DB2Alias findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            return (DB2Alias)schema.getAliasCache().getObject(monitor, schema, objectName);
        }
    }),
    CHECK((DBPImage)DBIcon.TREE_CONSTRAINT, DB2TableCheckConstraint.class, new ObjectFinder(){

        @Override
        public DB2TableCheckConstraint findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            return (DB2TableCheckConstraint)schema.getCheckCache().getObject(monitor, schema, objectName);
        }
    }),
    COLUMN((DBPImage)DBIcon.TREE_COLUMN, DB2TableColumn.class, new ObjectFinder(){

        public DB2TableColumn findObject(DBRProgressMonitor monitor, DB2Table db2Table, String objectName) throws DBException {
            return db2Table.getAttribute(monitor, objectName);
        }

        public DB2TableColumn findObject(DBRProgressMonitor monitor, DB2View db2View, String objectName) throws DBException {
            return db2View.getAttribute(monitor, objectName);
        }
    }),
    FOREIGN_KEY((DBPImage)DBIcon.TREE_FOREIGN_KEY, DB2TableForeignKey.class, new ObjectFinder(){

        public DB2TableForeignKey findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            return (DB2TableForeignKey)schema.getAssociationCache().getObject(monitor, schema, objectName);
        }
    }),
    MODULE((DBPImage)DBIcon.TREE_PACKAGE, DB2Module.class, new ObjectFinder(){

        @Override
        public DB2Module findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            return (DB2Module)schema.getModuleCache().getObject(monitor, (DBSObject)schema, objectName);
        }
    }),
    MQT((DBPImage)DBIcon.TREE_TABLE, DB2MaterializedQueryTable.class, new ObjectFinder(){

        @Override
        public DB2MaterializedQueryTable findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            return (DB2MaterializedQueryTable)schema.getMaterializedQueryTableCache().getObject(monitor, schema, objectName);
        }
    }),
    INDEX((DBPImage)DBIcon.TREE_INDEX, DB2Index.class, new ObjectFinder(){

        public DB2Index findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            return (DB2Index)schema.getIndexCache().getObject(monitor, schema, objectName);
        }
    }),
    NICKNAME((DBPImage)DBIcon.TREE_SYNONYM, DB2View.class, new ObjectFinder(){

        @Override
        public DB2Nickname findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            return (DB2Nickname)schema.getNicknameCache().getObject(monitor, schema, objectName, DB2Nickname.class);
        }
    }),
    PACKAGE((DBPImage)DBIcon.TREE_PACKAGE, DB2Package.class, new ObjectFinder(){

        @Override
        public DB2Package findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            return (DB2Package)schema.getPackageCache().getObject(monitor, (DBSObject)schema, objectName);
        }
    }),
    PROCEDURE((DBPImage)DBIcon.TREE_PROCEDURE, DB2Routine.class, new ObjectFinder(){

        @Override
        public DB2Routine findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            DB2Routine procedure;
            String[] tokens = objectName.split(DB2ObjectType.SPLIT_DOT);
            if (tokens.length == 1) {
                procedure = (DB2Routine)schema.getProcedureCache().getObject(monitor, schema, tokens[0]);
            } else {
                DB2Module module = (DB2Module)schema.getModuleCache().getObject(monitor, (DBSObject)schema, tokens[0]);
                procedure = (DB2Routine)module.getProcedureCache().getObject(monitor, (DBSObject)module, tokens[1]);
            }
            return procedure;
        }
    }),
    REFERENCE((DBPImage)DBIcon.TREE_REFERENCE, DB2TableReference.class, new ObjectFinder(){

        public DB2TableReference findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            return (DB2TableReference)schema.getReferenceCache().getObject(monitor, schema, objectName);
        }
    }),
    ROUTINE((DBPImage)DBIcon.TREE_PROCEDURE, DB2Routine.class, new ObjectFinder(){

        @Override
        public DB2Routine findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            DB2Routine routine;
            String[] tokens = objectName.split(DB2ObjectType.SPLIT_DOT);
            if (tokens.length == 1) {
                routine = (DB2Routine)schema.getUdfCache().getObject(monitor, schema, tokens[0]);
                if (routine == null && (routine = (DB2Routine)schema.getProcedureCache().getObject(monitor, schema, tokens[0])) == null) {
                    routine = (DB2Routine)schema.getMethodCache().getObject(monitor, (DBSObject)schema, tokens[0]);
                }
            } else {
                DB2Module module = (DB2Module)schema.getModuleCache().getObject(monitor, (DBSObject)schema, tokens[0]);
                routine = (DB2Routine)module.getFunctionCache().getObject(monitor, (DBSObject)module, tokens[1]);
                if (routine == null && (routine = (DB2Routine)module.getProcedureCache().getObject(monitor, (DBSObject)module, tokens[1])) == null) {
                    routine = (DB2Routine)module.getMethodCache().getObject(monitor, (DBSObject)module, tokens[1]);
                }
            }
            return routine;
        }
    }),
    SCHEMA((DBPImage)DBIcon.TREE_SCHEMA, DB2Schema.class, null),
    SEQUENCE((DBPImage)DBIcon.TREE_SEQUENCE, DB2Sequence.class, new ObjectFinder(){

        @Override
        public DB2Sequence findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            return (DB2Sequence)schema.getSequenceCache().getObject(monitor, (DBSObject)schema, objectName);
        }
    }),
    TABLE((DBPImage)DBIcon.TREE_TABLE, DB2Table.class, new ObjectFinder(){

        @Override
        public DB2Table findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            return (DB2Table)schema.getTableCache().getObject(monitor, schema, objectName);
        }
    }),
    TABLESPACE((DBPImage)DBIcon.TREE_TABLESPACE, DB2Tablespace.class, new ObjectFinder(){

        @Override
        public DB2Tablespace findObject(DBRProgressMonitor monitor, DB2DataSource db2DataSource, String objectName) throws DBException {
            return db2DataSource.getTablespace(monitor, objectName);
        }
    }),
    TRIGGER((DBPImage)DBIcon.TREE_TABLE, DB2Trigger.class, new ObjectFinder(){

        @Override
        public DB2Trigger findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            return (DB2Trigger)schema.getTriggerCache().getObject(monitor, schema, objectName);
        }
    }),
    UDF((DBPImage)DBIcon.TREE_PROCEDURE, DB2Routine.class, new ObjectFinder(){

        @Override
        public DB2Routine findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            DB2Routine udf;
            String[] tokens = objectName.split(DB2ObjectType.SPLIT_DOT);
            if (tokens.length == 1) {
                udf = (DB2Routine)schema.getUdfCache().getObject(monitor, schema, tokens[0]);
            } else {
                DB2Module module = (DB2Module)schema.getModuleCache().getObject(monitor, (DBSObject)schema, tokens[0]);
                udf = (DB2Routine)module.getFunctionCache().getObject(monitor, (DBSObject)module, tokens[1]);
            }
            return udf;
        }
    }),
    UDT((DBPImage)DBIcon.TREE_DATA_TYPE, DB2DataType.class, new ObjectFinder(){

        @Override
        public DB2DataType findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            String[] tokens = objectName.split(DB2ObjectType.SPLIT_DOT);
            if (tokens.length == 1) {
                return (DB2DataType)schema.getUdtCache().getObject(monitor, (DBSObject)schema, tokens[0]);
            }
            DB2Module module = (DB2Module)schema.getModuleCache().getObject(monitor, (DBSObject)schema, tokens[0]);
            return (DB2DataType)module.getTypeCache().getObject(monitor, (DBSObject)module, tokens[1]);
        }
    }),
    UNIQUE_KEY((DBPImage)DBIcon.TREE_UNIQUE_KEY, DB2TableUniqueKey.class, new ObjectFinder(){

        public DB2TableUniqueKey findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            return (DB2TableUniqueKey)schema.getConstraintCache().getObject(monitor, schema, objectName);
        }
    }),
    VIEW((DBPImage)DBIcon.TREE_VIEW, DB2View.class, new ObjectFinder(){

        @Override
        public DB2View findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            return (DB2View)schema.getViewCache().getObject(monitor, schema, objectName, DB2View.class);
        }
    }),
    VARIABLE((DBPImage)DBIcon.TREE_ATTRIBUTE, DB2Variable.class, new ObjectFinder(){

        @Override
        public DB2Variable findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            DB2Variable variable;
            DB2DataSource db2DataSource = schema.getDataSource();
            String[] tokens = objectName.split(DB2ObjectType.SPLIT_DOT);
            if (tokens.length == 1) {
                variable = (DB2Variable)db2DataSource.getVariableCache().getObject(monitor, (DBSObject)db2DataSource, tokens[0]);
            } else {
                DB2Module module = (DB2Module)schema.getModuleCache().getObject(monitor, (DBSObject)schema, tokens[0]);
                variable = (DB2Variable)module.getVariableCache().getObject(monitor, (DBSObject)module, tokens[1]);
            }
            return variable;
        }
    }),
    XML_SCHEMA((DBPImage)DBIcon.TREE_DATA_TYPE, DB2XMLSchema.class, new ObjectFinder(){

        @Override
        public DB2XMLSchema findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            return (DB2XMLSchema)schema.getXmlSchemaCache().getObject(monitor, (DBSObject)schema, objectName);
        }
    });

    private static final Log LOG;
    private static final String SPLIT_DOT = "\\.";
    private final DBPImage image;
    private final Class<? extends DBSObject> typeClass;
    private final ObjectFinder finder;
    private static Map<String, DB2ObjectType> typeMap;

    static {
        LOG = Log.getLog(DB2ObjectType.class);
        typeMap = new HashMap<String, DB2ObjectType>();
        DB2ObjectType[] dB2ObjectTypeArray = DB2ObjectType.values();
        int n = dB2ObjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DB2ObjectType type = dB2ObjectTypeArray[n2];
            typeMap.put(type.getTypeName(), type);
            ++n2;
        }
    }

    private <OBJECT_TYPE extends DBSObject> DB2ObjectType(DBPImage image, Class<OBJECT_TYPE> typeClass, ObjectFinder finder) {
        this.image = image;
        this.typeClass = typeClass;
        this.finder = finder;
    }

    public String getTypeName() {
        return this.name();
    }

    public boolean isBrowsable() {
        return this.finder != null;
    }

    public DBSObject findObject(DBRProgressMonitor monitor, DB2DataSource db2DataSource, String objectName) throws DBException {
        if (this.finder != null) {
            return this.finder.findObject(monitor, db2DataSource, objectName);
        }
        return null;
    }

    public DBSObject findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
        if (this.finder != null) {
            return this.finder.findObject(monitor, schema, objectName);
        }
        return null;
    }

    public DBSObject findObject(DBRProgressMonitor monitor, DB2Table db2Table, String objectName) throws DBException {
        if (this.finder != null) {
            return this.finder.findObject(monitor, db2Table, objectName);
        }
        return null;
    }

    public DBSObject findObject(DBRProgressMonitor monitor, DB2View db2View, String objectName) throws DBException {
        if (this.finder != null) {
            return this.finder.findObject(monitor, db2View, objectName);
        }
        return null;
    }

    public String getDescription() {
        return null;
    }

    public DBPImage getImage() {
        return this.image;
    }

    public Class<? extends DBSObject> getTypeClass() {
        return this.typeClass;
    }

    public static DB2ObjectType getByType(String typeName) {
        return typeMap.get(typeName);
    }

    public static Object resolveObject(DBRProgressMonitor monitor, DB2DataSource dataSource, String objectTypeName, String objectOwner, String objectName) throws DBException {
        DB2ObjectType objectType = DB2ObjectType.getByType(objectTypeName);
        if (objectType == null) {
            LOG.debug((Object)("Unrecognized object type: " + objectTypeName));
            return objectName;
        }
        if (!objectType.isBrowsable()) {
            LOG.debug((Object)("Unsupported object type: " + objectTypeName));
            return objectName;
        }
        DB2Schema schema = dataSource.getSchema(monitor, objectOwner);
        if (schema == null) {
            LOG.debug((Object)("Schema '" + objectOwner + "' not found"));
            return objectName;
        }
        DBSObject object = objectType.findObject(monitor, schema, objectName);
        if (object == null) {
            LOG.debug((Object)(objectTypeName + " '" + objectName + "' not found in '" + schema.getName() + "'"));
            return objectName;
        }
        return object;
    }

    private static class ObjectFinder {
        private ObjectFinder() {
        }

        DBSObject findObject(DBRProgressMonitor monitor, DB2DataSource db2DataSource, String objectName) throws DBException {
            return null;
        }

        DBSObject findObject(DBRProgressMonitor monitor, DB2Schema schema, String objectName) throws DBException {
            return null;
        }

        DBSObject findObject(DBRProgressMonitor monitor, DB2Table db2Table, String objectName) throws DBException {
            return null;
        }

        DBSObject findObject(DBRProgressMonitor monitor, DB2View db2View, String objectName) throws DBException {
            return null;
        }
    }
}

