/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.validator;

import java.util.EnumSet;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.alter.AlterExpression;
import net.sf.jsqlparser.statement.alter.AlterOperation;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.ValidationUtil;
import net.sf.jsqlparser.util.validation.metadata.NamedObject;
import net.sf.jsqlparser.util.validation.validator.AbstractValidator;

public class AlterValidator
extends AbstractValidator<Alter> {
    @Override
    public void validate(Alter alter) {
        this.validateFeature(Feature.alterTable);
        this.validateOptionalFromItem(alter.getTable());
        alter.getAlterExpressions().forEach(e -> this.validate(alter, (AlterExpression)e));
    }

    public void validate(Alter alter, AlterExpression e) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateOptionalColumnName(c, e.getColumnOldName());
            this.validateOptionalColumnName(c, e.getColumnName());
            if (e.getColumnDropNotNullList() != null) {
                this.validateOptionalColumnNames(c, ValidationUtil.map(e.getColumnDropNotNullList(), AlterExpression.ColumnDropNotNull::getColumnName), new NamedObject[0]);
            }
            if (e.getColDataTypeList() != null) {
                boolean validateForExist = !EnumSet.of(AlterOperation.ADD).contains((Object)e.getOperation());
                this.validateOptionalColumnNames(c, ValidationUtil.map(e.getColDataTypeList(), ColumnDefinition::getColumnName), validateForExist, NamedObject.table);
            }
            this.validateOptionalName(c, NamedObject.constraint, e.getConstraintName(), new NamedObject[0]);
            if (e.getPkColumns() != null) {
                this.validateOptionalColumnNames(c, e.getPkColumns(), new NamedObject[0]);
            }
            if (e.getFkColumns() != null) {
                this.validateName(c, NamedObject.table, e.getFkSourceTable());
                this.validateOptionalColumnNames(c, e.getFkColumns(), new NamedObject[0]);
                this.validateOptionalColumnNames(c, e.getFkSourceColumns(), new NamedObject[0]);
            }
            if (e.getUk()) {
                this.validateName(c, NamedObject.uniqueConstraint, e.getUkName());
                this.validateOptionalColumnNames(c, e.getUkColumns(), NamedObject.uniqueConstraint);
            }
            if (e.getIndex() == null) continue;
            this.validateName(c, NamedObject.index, e.getIndex().getName());
            if (e.getIndex().getColumns() == null) continue;
            this.validateOptionalColumnNames(c, e.getIndex().getColumnsNames(), NamedObject.index);
        }
    }
}

