/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.OrderByVisitor;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.LimitDeparser;
import net.sf.jsqlparser.util.deparser.OrderByDeParser;

public class UpdateDeParser
extends AbstractDeParser<Update>
implements OrderByVisitor<StringBuilder> {
    private ExpressionVisitor<StringBuilder> expressionVisitor = new ExpressionVisitorAdapter<StringBuilder>();

    public UpdateDeParser() {
        super(new StringBuilder());
    }

    public UpdateDeParser(ExpressionVisitor<StringBuilder> expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(Update update) {
        if (update.getWithItemsList() != null && !update.getWithItemsList().isEmpty()) {
            this.builder.append("WITH ");
            Iterator<WithItem<?>> iter = update.getWithItemsList().iterator();
            while (iter.hasNext()) {
                WithItem<?> withItem = iter.next();
                this.builder.append(withItem);
                if (iter.hasNext()) {
                    this.builder.append(",");
                }
                this.builder.append(" ");
            }
        }
        this.builder.append("UPDATE ");
        if (update.getOracleHint() != null) {
            this.builder.append(update.getOracleHint()).append(" ");
        }
        if (update.getModifierPriority() != null) {
            this.builder.append((Object)update.getModifierPriority()).append(" ");
        }
        if (update.isModifierIgnore()) {
            this.builder.append("IGNORE ");
        }
        this.builder.append(update.getTable());
        if (update.getStartJoins() != null) {
            for (Join join : update.getStartJoins()) {
                if (join.isSimple()) {
                    this.builder.append(", ").append(join);
                    continue;
                }
                this.builder.append(" ").append(join);
            }
        }
        this.builder.append(" SET ");
        this.deparseUpdateSetsClause(update);
        if (update.getOutputClause() != null) {
            update.getOutputClause().appendTo(this.builder);
        }
        if (update.getFromItem() != null) {
            this.builder.append(" FROM ").append(update.getFromItem());
            if (update.getJoins() != null) {
                for (Join join : update.getJoins()) {
                    if (join.isSimple()) {
                        this.builder.append(", ").append(join);
                        continue;
                    }
                    this.builder.append(" ").append(join);
                }
            }
        }
        this.deparseWhereClause(update);
        if (update.getPreferringClause() != null) {
            this.builder.append(" ").append(update.getPreferringClause());
        }
        if (update.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.builder).deParse(update.getOrderByElements());
        }
        if (update.getLimit() != null) {
            new LimitDeparser(this.expressionVisitor, this.builder).deParse(update.getLimit());
        }
        if (update.getReturningClause() != null) {
            update.getReturningClause().appendTo(this.builder);
        }
    }

    protected void deparseWhereClause(Update update) {
        if (update.getWhere() != null) {
            this.builder.append(" WHERE ");
            update.getWhere().accept(this.expressionVisitor, null);
        }
    }

    protected void deparseUpdateSetsClause(Update update) {
        UpdateDeParser.deparseUpdateSets(update.getUpdateSets(), this.builder, this.expressionVisitor);
    }

    public ExpressionVisitor<StringBuilder> getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor<StringBuilder> visitor) {
        this.expressionVisitor = visitor;
    }

    @Override
    public <S> StringBuilder visit(OrderByElement orderBy, S context) {
        orderBy.getExpression().accept(this.expressionVisitor, context);
        if (!orderBy.isAsc()) {
            this.builder.append(" DESC");
        } else if (orderBy.isAscDescPresent()) {
            this.builder.append(" ASC");
        }
        if (orderBy.getNullOrdering() != null) {
            this.builder.append(' ');
            this.builder.append(orderBy.getNullOrdering() == OrderByElement.NullOrdering.NULLS_FIRST ? "NULLS FIRST" : "NULLS LAST");
        }
        return this.builder;
    }
}

