/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.action;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDEditorPart;

public class ERDEditorPropertyTester
extends PropertyTester {
    public static final String NAMESPACE = "org.jkiss.dbeaver.ui.editors.erd.editor";
    public static final String PROP_CAN_UNDO = "canUndo";
    public static final String PROP_CAN_REDO = "canRedo";
    public static final String PROP_CAN_DELETE = "canDelete";
    public static final String PROP_EDITABLE = "editable";
    public static final String PROP_EDIT_MODE = "editMode";
    public static final String SUPPORTS_STRUCTURE_EDIT = "supportsStructureEdit";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof ERDEditorPart)) {
            return false;
        }
        ERDEditorPart erdEditor = (ERDEditorPart)((Object)receiver);
        switch (property) {
            case "canUndo": {
                return erdEditor.getCommandStack().canUndo();
            }
            case "canRedo": {
                return erdEditor.getCommandStack().canRedo();
            }
            case "editable": {
                return !erdEditor.isReadOnly() && DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("database-developer");
            }
            case "canDelete": {
                DeleteAction deleteAction = new DeleteAction((IWorkbenchPart)erdEditor);
                deleteAction.update();
                return deleteAction.isEnabled();
            }
            case "editMode": {
                return erdEditor.getDiagram().isEditEnabled();
            }
            case "supportsStructureEdit": {
                return erdEditor.getDecorator().supportsStructureEdit() && erdEditor.getCommandContext() != null;
            }
        }
        return false;
    }
}

