/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console.ansi.utils;

import java.util.ArrayList;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.console.ansi.AnsiConsoleUtils;
import org.eclipse.ui.internal.console.ansi.preferences.AnsiConsolePreferenceUtils;

public class AnsiClipboardUtils {
    public static void textToClipboard(StyledText styledText, boolean removeEscapeSeq) {
        Clipboard clipboard = new Clipboard(Display.getDefault());
        clipboard.clearContents();
        styledText.copy();
        if (!removeEscapeSeq) {
            clipboard.dispose();
            return;
        }
        ArrayList<String> clipboardData = new ArrayList<String>(3);
        ArrayList<Object> clipboardTransfers = new ArrayList<Object>(3);
        TextTransfer textTransfer = TextTransfer.getInstance();
        Object textData = clipboard.getContents((Transfer)textTransfer);
        if (textData != null && textData instanceof String) {
            String plainText = AnsiConsoleUtils.ESCAPE_SEQUENCE_REGEX_TXT.matcher((String)textData).replaceAll("");
            clipboardData.add(plainText);
            clipboardTransfers.add(textTransfer);
        }
        if (AnsiConsolePreferenceUtils.putRtfInClipboard()) {
            HTMLTransfer htmlTransfer;
            Object htmlData;
            RTFTransfer rtfTransfer = RTFTransfer.getInstance();
            Object rtfData = clipboard.getContents((Transfer)rtfTransfer);
            if (rtfData != null && rtfData instanceof String) {
                String rtfText = AnsiConsoleUtils.ESCAPE_SEQUENCE_REGEX_RTF.matcher((String)rtfData).replaceAll("");
                rtfText = AnsiConsoleUtils.ESCAPE_SEQUENCE_REGEX_RTF_FIX_SRC.matcher(rtfText).replaceAll("$0\\\\cb$1");
                clipboardData.add(rtfText);
                clipboardTransfers.add(rtfTransfer);
            }
            if ((htmlData = clipboard.getContents((Transfer)(htmlTransfer = HTMLTransfer.getInstance()))) != null && htmlData instanceof String) {
                String htmlText = AnsiConsoleUtils.ESCAPE_SEQUENCE_REGEX_HTML.matcher((String)htmlData).replaceAll("");
                clipboardData.add(htmlText);
                clipboardTransfers.add(htmlTransfer);
            }
        }
        clipboard.setContents(clipboardData.toArray(), clipboardTransfers.toArray(new Transfer[0]));
        clipboard.dispose();
    }
}

