/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.util.Arrays;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.visitor.AllAnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationTypeFilter;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPresenceFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.LibraryClassFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberDescriptorReferencedClassVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.ProgramClassFilter;
import proguard.classfile.visitor.SignatureAttributeReferencedClassVisitor;
import proguard.optimize.gson.DuplicateJsonFieldNameChecker;
import proguard.optimize.gson.LocalOrAnonymousClassChecker;
import proguard.optimize.gson.TypeParameterClassChecker;

public class GsonDomainClassFinder
extends SimplifiedVisitor
implements ClassVisitor {
    private static final boolean DEBUG = false;
    private final ClassPool typeAdapterClassPool;
    private final ClassPool gsonDomainClassPool;
    private final WarningPrinter notePrinter;
    private final LocalOrAnonymousClassChecker localOrAnonymousClassChecker = new LocalOrAnonymousClassChecker();
    private final TypeParameterClassChecker typeParameterClassChecker = new TypeParameterClassChecker();
    private final DuplicateJsonFieldNameChecker duplicateFieldNameChecker = new DuplicateJsonFieldNameChecker();

    public GsonDomainClassFinder(ClassPool typeAdapterClassPool, ClassPool gsonDomainClassPool, WarningPrinter notePrinter) {
        this.typeAdapterClassPool = typeAdapterClassPool;
        this.gsonDomainClassPool = gsonDomainClassPool;
        this.notePrinter = notePrinter;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (this.gsonDomainClassPool.getClass(programClass.getName()) == null) {
            programClass.accept(this.localOrAnonymousClassChecker);
            if (this.localOrAnonymousClassChecker.isLocalOrAnonymous()) {
                return;
            }
            if (this.librarySuperClassCount(programClass) != 0) {
                this.note(programClass.getName(), "Note: " + ClassUtil.externalClassName(programClass.getName() + " can not be optimized for GSON because it is or inherits from a library class."));
                return;
            }
            if (this.gsonSuperClassCount(programClass) != 0) {
                this.note(programClass.getName(), "Note: " + ClassUtil.externalClassName(programClass.getName() + " can not be optimized for GSON because it is or inherits from a GSON API class."));
                return;
            }
            this.typeParameterClassChecker.hasFieldWithTypeParameter = false;
            programClass.hierarchyAccept(true, true, false, false, this.typeParameterClassChecker);
            if (this.typeParameterClassChecker.hasFieldWithTypeParameter) {
                this.note(programClass.getName(), "Note: " + ClassUtil.externalClassName(programClass.getName() + " can not be optimized for GSON because it uses generic type variables."));
                return;
            }
            this.duplicateFieldNameChecker.hasDuplicateJsonFieldNames = false;
            programClass.hierarchyAccept(true, true, false, false, this.duplicateFieldNameChecker);
            if (this.duplicateFieldNameChecker.hasDuplicateJsonFieldNames) {
                this.note(programClass.getName(), "Note: " + ClassUtil.externalClassName(programClass.getName() + " can not be optimized for GSON because it contains duplicate field names in its JSON representation."));
                return;
            }
            ClassCounter typeAdapterClassCounter = new ClassCounter();
            programClass.hierarchyAccept(true, true, false, false, new ClassPresenceFilter(this.typeAdapterClassPool, typeAdapterClassCounter, null));
            if (typeAdapterClassCounter.getCount() > 0) {
                this.note(programClass.getName(), "Note: " + ClassUtil.externalClassName(programClass.getName() + " can not be optimized for GSON because a custom type adapter is registered for it."));
                return;
            }
            AnnotationFinder annotationFinder = new AnnotationFinder();
            programClass.hierarchyAccept(true, true, false, false, new MultiClassVisitor(new AllAttributeVisitor(true, new AllAnnotationVisitor(new AnnotationTypeFilter("Lcom/google/gson/annotations/JsonAdapter;", (AnnotationVisitor)annotationFinder)))));
            if (annotationFinder.found) {
                this.note(programClass.getName(), "Note: " + ClassUtil.externalClassName(programClass.getName() + " can not be optimized for GSON because it contains a JsonAdapter annotation."));
                return;
            }
            if ((programClass.getAccessFlags() & 0x200) == 0) {
                this.gsonDomainClassPool.addClass(programClass);
                programClass.fieldsAccept(new MemberAccessFilter(0, 4096, new MultiMemberVisitor(new MemberDescriptorReferencedClassVisitor(this), new AllAttributeVisitor(new SignatureAttributeReferencedClassVisitor(this)))));
            }
            programClass.hierarchyAccept(false, true, false, true, this);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    private int librarySuperClassCount(ProgramClass programClass) {
        ClassCounter nonObjectLibrarySuperClassCounter = new ClassCounter();
        programClass.hierarchyAccept(true, true, false, false, new LibraryClassFilter(new ClassNameFilter(Arrays.asList("!java/lang/Object", "!java/lang/Enum"), (ClassVisitor)nonObjectLibrarySuperClassCounter)));
        return nonObjectLibrarySuperClassCounter.getCount();
    }

    private int gsonSuperClassCount(ProgramClass programClass) {
        ClassCounter gsonSuperClassCounter = new ClassCounter();
        programClass.hierarchyAccept(true, true, false, false, new ProgramClassFilter(new ClassNameFilter("com/google/gson/**", (ClassVisitor)gsonSuperClassCounter)));
        return gsonSuperClassCounter.getCount();
    }

    private void note(String className, String note) {
        if (this.notePrinter != null) {
            this.notePrinter.print(className, note);
            this.notePrinter.print(className, "      You should consider keeping this class and its fields.");
        }
    }

    private class AnnotationFinder
    extends SimplifiedVisitor
    implements AnnotationVisitor {
        private boolean found;

        private AnnotationFinder() {
        }

        @Override
        public void visitAnnotation(Clazz clazz, Annotation annotation) {
            this.found = true;
        }
    }
}

