/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import proguard.io.DataEntry;

public class ZipFileDataEntry
implements DataEntry {
    private final DataEntry parent;
    private final ZipEntry zipEntry;
    private ZipFile zipFile;
    private InputStream zipInputStream;
    private InputStream bufferedInputStream;

    public ZipFileDataEntry(DataEntry parent, ZipEntry zipEntry, ZipFile zipFile) {
        this.parent = parent;
        this.zipEntry = zipEntry;
        this.zipFile = zipFile;
    }

    @Override
    public String getName() {
        String name = this.zipEntry.getName().replace(File.separatorChar, '/');
        int length = name.length();
        return length > 0 && name.charAt(length - 1) == '/' ? name.substring(0, length - 1) : name;
    }

    @Override
    public String getOriginalName() {
        return this.getName();
    }

    @Override
    public long getSize() {
        return this.zipEntry.getSize();
    }

    @Override
    public boolean isDirectory() {
        return this.zipEntry.isDirectory();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.zipInputStream == null) {
            this.zipInputStream = this.zipFile.getInputStream(this.zipEntry);
        }
        if (this.bufferedInputStream == null) {
            this.bufferedInputStream = new BufferedInputStream(this.zipInputStream);
        }
        return this.bufferedInputStream;
    }

    @Override
    public void closeInputStream() throws IOException {
        this.zipInputStream.close();
        this.zipFile = null;
        this.bufferedInputStream = null;
    }

    @Override
    public DataEntry getParent() {
        return this.parent;
    }

    public String toString() {
        return this.parent.toString() + ':' + this.getName();
    }
}

