/*
 * Decompiled with CFR 0.152.
 */
package proguard.configuration;

import java.io.IOException;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.configuration.ConfigurationLogger;
import proguard.configuration.ConfigurationLoggingInstructionSequenceConstants;
import proguard.configuration.ConfigurationLoggingInstructionSequencesReplacer;
import proguard.io.ClassPathDataEntry;
import proguard.io.ClassReader;
import proguard.optimize.peephole.BranchTargetFinder;
import proguard.optimize.peephole.PeepholeOptimizer;
import proguard.util.MultiValueMap;

public class ConfigurationLoggingAdder
extends SimplifiedVisitor
implements InstructionVisitor {
    private final Configuration configuration;
    private MultiValueMap<String, String> injectedClassMap;

    public ConfigurationLoggingAdder(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool programClassPool, ClassPool libraryClassPool, MultiValueMap<String, String> injectedClassMap) {
        ClassReader classReader = new ClassReader(false, false, false, null, new MultiClassVisitor(new ClassPoolFiller(programClassPool), new ClassReferenceInitializer(programClassPool, libraryClassPool), new ClassSubHierarchyInitializer()));
        try {
            classReader.read(new ClassPathDataEntry(ConfigurationLogger.MethodSignature.class));
            classReader.read(new ClassPathDataEntry(ConfigurationLogger.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ConfigurationLoggingInstructionSequenceConstants constants = new ConfigurationLoggingInstructionSequenceConstants(programClassPool, libraryClassPool);
        BranchTargetFinder branchTargetFinder = new BranchTargetFinder();
        CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
        this.injectedClassMap = injectedClassMap;
        programClassPool.classesAccept(new ClassNameFilter("!proguard/**", (ClassVisitor)new AllMethodVisitor(new AllAttributeVisitor(new PeepholeOptimizer(branchTargetFinder, codeAttributeEditor, new ConfigurationLoggingInstructionSequencesReplacer(constants.CONSTANTS, constants.RESOURCE, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)this))))));
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        this.injectedClassMap.put(clazz.getName(), ClassUtil.internalClassName(ConfigurationLogger.class.getName()));
        this.injectedClassMap.put(clazz.getName(), ClassUtil.internalClassName(ConfigurationLogger.MethodSignature.class.getName()));
    }
}

