﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mediaconvert/MediaConvert_EXPORTS.h>

namespace Aws {
namespace MediaConvert {
namespace Model {
enum class CmafWriteHLSManifest { NOT_SET, DISABLED, ENABLED };

namespace CmafWriteHLSManifestMapper {
AWS_MEDIACONVERT_API CmafWriteHLSManifest GetCmafWriteHLSManifestForName(const Aws::String& name);

AWS_MEDIACONVERT_API Aws::String GetNameForCmafWriteHLSManifest(CmafWriteHLSManifest value);
}  // namespace CmafWriteHLSManifestMapper
}  // namespace Model
}  // namespace MediaConvert
}  // namespace Aws
