﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/DataSourceStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GuardDuty {
namespace Model {

/**
 * <p>Contains information on the status of DNS logs as a data
 * source.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DNSLogsConfigurationResult">AWS
 * API Reference</a></p>
 */
class DNSLogsConfigurationResult {
 public:
  AWS_GUARDDUTY_API DNSLogsConfigurationResult() = default;
  AWS_GUARDDUTY_API DNSLogsConfigurationResult(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API DNSLogsConfigurationResult& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Denotes whether DNS logs is enabled as a data source.</p>
   */
  inline DataSourceStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(DataSourceStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline DNSLogsConfigurationResult& WithStatus(DataSourceStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}
 private:
  DataSourceStatus m_status{DataSourceStatus::NOT_SET};
  bool m_statusHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
