﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudtrail/CloudTrail_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/cloudtrail/model/SourceConfig.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/cloudtrail/model/IngestionStatus.h>
#include <aws/cloudtrail/model/Destination.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace CloudTrail
{
namespace Model
{
  class GetChannelResult
  {
  public:
    AWS_CLOUDTRAIL_API GetChannelResult() = default;
    AWS_CLOUDTRAIL_API GetChannelResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_CLOUDTRAIL_API GetChannelResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The ARN of an channel returned by a <code>GetChannel</code> request.</p>
     */
    inline const Aws::String& GetChannelArn() const { return m_channelArn; }
    template<typename ChannelArnT = Aws::String>
    void SetChannelArn(ChannelArnT&& value) { m_channelArnHasBeenSet = true; m_channelArn = std::forward<ChannelArnT>(value); }
    template<typename ChannelArnT = Aws::String>
    GetChannelResult& WithChannelArn(ChannelArnT&& value) { SetChannelArn(std::forward<ChannelArnT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p> The name of the CloudTrail channel. For service-linked channels, the name is
     * <code>aws-service-channel/service-name/custom-suffix</code> where
     * <code>service-name</code> represents the name of the Amazon Web Services service
     * that created the channel and <code>custom-suffix</code> represents the suffix
     * generated by the Amazon Web Services service. </p>
     */
    inline const Aws::String& GetName() const { return m_name; }
    template<typename NameT = Aws::String>
    void SetName(NameT&& value) { m_nameHasBeenSet = true; m_name = std::forward<NameT>(value); }
    template<typename NameT = Aws::String>
    GetChannelResult& WithName(NameT&& value) { SetName(std::forward<NameT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The source for the CloudTrail channel.</p>
     */
    inline const Aws::String& GetSource() const { return m_source; }
    template<typename SourceT = Aws::String>
    void SetSource(SourceT&& value) { m_sourceHasBeenSet = true; m_source = std::forward<SourceT>(value); }
    template<typename SourceT = Aws::String>
    GetChannelResult& WithSource(SourceT&& value) { SetSource(std::forward<SourceT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p> Provides information about the advanced event selectors configured for the
     * channel, and whether the channel applies to all Regions or a single Region. </p>
     */
    inline const SourceConfig& GetSourceConfig() const { return m_sourceConfig; }
    template<typename SourceConfigT = SourceConfig>
    void SetSourceConfig(SourceConfigT&& value) { m_sourceConfigHasBeenSet = true; m_sourceConfig = std::forward<SourceConfigT>(value); }
    template<typename SourceConfigT = SourceConfig>
    GetChannelResult& WithSourceConfig(SourceConfigT&& value) { SetSourceConfig(std::forward<SourceConfigT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The destinations for the channel. For channels created for integrations, the
     * destinations are the event data stores that log events arriving through the
     * channel. For service-linked channels, the destination is the Amazon Web Services
     * service that created the service-linked channel to receive events.</p>
     */
    inline const Aws::Vector<Destination>& GetDestinations() const { return m_destinations; }
    template<typename DestinationsT = Aws::Vector<Destination>>
    void SetDestinations(DestinationsT&& value) { m_destinationsHasBeenSet = true; m_destinations = std::forward<DestinationsT>(value); }
    template<typename DestinationsT = Aws::Vector<Destination>>
    GetChannelResult& WithDestinations(DestinationsT&& value) { SetDestinations(std::forward<DestinationsT>(value)); return *this;}
    template<typename DestinationsT = Destination>
    GetChannelResult& AddDestinations(DestinationsT&& value) { m_destinationsHasBeenSet = true; m_destinations.emplace_back(std::forward<DestinationsT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>A table showing information about the most recent successful and failed
     * attempts to ingest events.</p>
     */
    inline const IngestionStatus& GetIngestionStatus() const { return m_ingestionStatus; }
    template<typename IngestionStatusT = IngestionStatus>
    void SetIngestionStatus(IngestionStatusT&& value) { m_ingestionStatusHasBeenSet = true; m_ingestionStatus = std::forward<IngestionStatusT>(value); }
    template<typename IngestionStatusT = IngestionStatus>
    GetChannelResult& WithIngestionStatus(IngestionStatusT&& value) { SetIngestionStatus(std::forward<IngestionStatusT>(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const { return m_requestId; }
    template<typename RequestIdT = Aws::String>
    void SetRequestId(RequestIdT&& value) { m_requestIdHasBeenSet = true; m_requestId = std::forward<RequestIdT>(value); }
    template<typename RequestIdT = Aws::String>
    GetChannelResult& WithRequestId(RequestIdT&& value) { SetRequestId(std::forward<RequestIdT>(value)); return *this;}
    ///@}
  private:

    Aws::String m_channelArn;
    bool m_channelArnHasBeenSet = false;

    Aws::String m_name;
    bool m_nameHasBeenSet = false;

    Aws::String m_source;
    bool m_sourceHasBeenSet = false;

    SourceConfig m_sourceConfig;
    bool m_sourceConfigHasBeenSet = false;

    Aws::Vector<Destination> m_destinations;
    bool m_destinationsHasBeenSet = false;

    IngestionStatus m_ingestionStatus;
    bool m_ingestionStatusHasBeenSet = false;

    Aws::String m_requestId;
    bool m_requestIdHasBeenSet = false;
  };

} // namespace Model
} // namespace CloudTrail
} // namespace Aws
